#!/bin/sh
#
# @(#) Fibranet NSP, SL
# Copyright (C) 2005-2009 by Jordi Sanfeliu <jordi@fibranet.cat>
#
# Monitorix report for CATALAN language
#
# Syntax: traffic_report.sh $to_address $prev_month $pc $html $graph $logo
#			    $tit_info $blank $signature
#

TO_ADDRESS=$1
PREV_MONTH=$2
PC=$3
TEXT=$4
GRAPH=$5
LOGO_01=$6
LOGO_02=$7
LOGO_03=$8
LOGO_04=$9

FROM_ADDRESS="root@localhost"

TSEC=`/bin/date +%s`
YEAR=`/bin/date +%Y`
MONTH=`/bin/date +%m`
DAY=`/bin/date +%d`
CID_01="$TSEC@$YEAR$MONTH$DAY@01@fnsp"
CID_02="$TSEC@$YEAR$MONTH$DAY@02@fnsp"
CID_03="$TSEC@$YEAR$MONTH$DAY@03@fnsp"
CID_04="$TSEC@$YEAR$MONTH$DAY@04@fnsp"
CID_05="$TSEC@$YEAR$MONTH$DAY@05@fnsp"

TMPFILE="tmp.$$"
TMPFILE2="tmp2.$$"

/bin/cp -f $TEXT $TMPFILE
/bin/cat $TMPFILE  | /bin/sed 's/"cid:XXX_01"/"cid:'$CID_01'"/' > $TMPFILE2
/bin/cat $TMPFILE2 | /bin/sed 's/"cid:XXX_02"/"cid:'$CID_02'"/' > $TMPFILE
/bin/cat $TMPFILE  | /bin/sed 's/"cid:XXX_03"/"cid:'$CID_03'"/' > $TMPFILE2
/bin/cat $TMPFILE2 | /bin/sed 's/"cid:XXX_04"/"cid:'$CID_04'"/' > $TMPFILE
/bin/cat $TMPFILE  | /bin/sed 's/"cid:XXX_05"/"cid:'$CID_05'"/' > $TMPFILE2
/bin/cp -f $TMPFILE2 $TMPFILE

SUBJECT="Monitorix: Informe Trafic Internet ($PC) $PREV_MONTH-$YEAR"
echo "Enviant informe mensual de trafic Internet a <$TO_ADDRESS> ..."
/usr/bin/metasend -b		\
	-F $FROM_ADDRESS	\
	-s "$SUBJECT"		\
	-t $TO_ADDRESS		\
	-f $TMPFILE		\
	-m "text/html"		\
	-n			\
	-f $LOGO_01		\
	-m "image/jpg"		\
	-i "<$CID_01>"		\
	-n			\
	-f $LOGO_02		\
	-m "image/jpg"		\
	-i "<$CID_02>"		\
	-n			\
	-f $LOGO_03		\
	-m "image/png"		\
	-i "<$CID_03>"		\
	-n			\
	-f $GRAPH		\
	-m "image/png"		\
	-i "<$CID_04>"		\
	-n			\
	-f $LOGO_04		\
	-m "image/png"		\
	-i "<$CID_05>"		\
	-/ "related"
rm -f $TMPFILE
/bin/rm -f $TMPFILE $TMPFILE2

