#       @(#) Fibranet NSP, SL
#       Copyright (C) 2005-2011 by Jordi Sanfeliu <jordi@fibranet.cat>
#
#       rpm spec for Monitorix
#

Summary: Monitorix is a system monitoring tool
Name: monitorix
Version: 2.1.0
Release: 1
License: GPL
Group: Applications/System
URL: http://www.monitorix.org
Distribution: RedHat/Fedora/CentOS Linux
Vendor: Fibranet NSP, SL
Packager: Jordi Sanfeliu <jordi@fibranet.cat>

Source: %{name}-%{version}.tar.gz
Requires: bash, rrdtool, perl, perl-libwww-perl, perl-MailTools, perl-MIME-Lite
BuildRoot: /var/tmp/%{name}-build
BuildArch: noarch

%description
Monitorix is a free, open source, lightweight system monitoring tool.

%prep
%setup -q

%build

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
install -m 0755 monitorix.init ${RPM_BUILD_ROOT}/etc/init.d/monitorix
mkdir -p ${RPM_BUILD_ROOT}/etc/httpd/conf.d
install -m 0644 monitorix-apache.conf ${RPM_BUILD_ROOT}/etc/httpd/conf.d/monitorix.conf
mkdir -p ${RPM_BUILD_ROOT}/etc/logrotate.d
install -m 0644 monitorix.logrotate ${RPM_BUILD_ROOT}/etc/logrotate.d/monitorix
mkdir -p ${RPM_BUILD_ROOT}/etc
install -m 0644 monitorix.conf ${RPM_BUILD_ROOT}/etc/monitorix.conf
mkdir -p ${RPM_BUILD_ROOT}/usr/bin
install -m 0755 monitorix ${RPM_BUILD_ROOT}/usr/bin
mkdir -p ${RPM_BUILD_ROOT}/usr/share/monitorix
install -m 0644 logo_top.png ${RPM_BUILD_ROOT}/usr/share/monitorix
install -m 0644 logo_bot.png ${RPM_BUILD_ROOT}/usr/share/monitorix
install -m 0644 monitorixico.png ${RPM_BUILD_ROOT}/usr/share/monitorix
mkdir -p ${RPM_BUILD_ROOT}/usr/share/monitorix/imgs
mkdir -p ${RPM_BUILD_ROOT}/usr/share/monitorix/cgi-bin
install -m 0755 monitorix.cgi ${RPM_BUILD_ROOT}/usr/share/monitorix/cgi-bin
mkdir -p ${RPM_BUILD_ROOT}/var/lib/monitorix/reports
install -m 0644 reports/*.html ${RPM_BUILD_ROOT}/var/lib/monitorix/reports
install -m 0755 reports/send_reports ${RPM_BUILD_ROOT}/var/lib/monitorix/reports
mkdir -p ${RPM_BUILD_ROOT}/var/lib/monitorix/usage
mkdir -p ${RPM_BUILD_ROOT}/usr/share/man/man5
mkdir -p ${RPM_BUILD_ROOT}/usr/share/man/man8
install -m 0644 man/man5/monitorix.conf.5 ${RPM_BUILD_ROOT}/usr/share/man/man5
install -m 0644 man/man8/monitorix.8 ${RPM_BUILD_ROOT}/usr/share/man/man8

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add monitorix
mkdir -p /usr/share/monitorix/imgs
mkdir -p /var/lib/monitorix/usage
chown apache:apache /usr/share/monitorix/imgs

%files
%defattr(-, root, root)
/etc/init.d/monitorix
%config(noreplace) /etc/httpd/conf.d/monitorix.conf
%config(noreplace) /etc/logrotate.d/monitorix
%config(noreplace) /etc/monitorix.conf
/usr/bin/monitorix
/usr/share/monitorix/logo_top.png
/usr/share/monitorix/logo_bot.png
/usr/share/monitorix/monitorixico.png
/usr/share/monitorix/cgi-bin/monitorix.cgi
%config(noreplace) /var/lib/monitorix/reports/*.html
/var/lib/monitorix/reports/send_reports
%doc %{_mandir}/man5/monitorix.conf.5.gz
%doc %{_mandir}/man8/monitorix.8.gz
%doc Changes COPYING README README.nginx README.FreeBSD monitorix-alert.sh

%changelog
* Thu Sep 01 2005 Jordi Sanfeliu <jordi@fibranet.cat>
- Release 0.7.8.
- First public release.
- All changes are described in the Changes file.
