#       @(#) Fibranet NSP, SL
#       Copyright (C) 2005-2010 by Jordi Sanfeliu <jordi@fibranet.cat>
#
#       rpm spec for Monitorix
#

Summary: Monitorix is a system monitoring tool
Name: monitorix
Version: 1.5.2
Release: 1
License: GPL
Group: Applications/System
URL: http://www.monitorix.org
Distribution: RedHat/Fedora/CentOS Linux
Vendor: Fibranet NSP, SL
Packager: Jordi Sanfeliu <jordi@fibranet.cat>

Source: %{name}-%{version}.tar.gz
Requires: bash, rrdtool, perl, perl-libwww-perl
BuildRoot: /var/tmp/%{name}-build
BuildArch: noarch

%description
Monitorix is a free, open source, lightweight system monitoring tool.

%prep
%setup -q

%build

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
install -m 0755 ports/Linux-RHFC/monitorix.init ${RPM_BUILD_ROOT}/etc/init.d/monitorix
mkdir -p ${RPM_BUILD_ROOT}/etc/httpd/conf.d
install -m 0644 monitorix-apache.conf ${RPM_BUILD_ROOT}/etc/httpd/conf.d/monitorix.conf
mkdir -p ${RPM_BUILD_ROOT}/etc
install -m 0644 monitorix.conf ${RPM_BUILD_ROOT}/etc/monitorix.conf
mkdir -p ${RPM_BUILD_ROOT}/usr/sbin
install -m 0755 monitorix.pl ${RPM_BUILD_ROOT}/usr/sbin
mkdir -p ${RPM_BUILD_ROOT}/var/www/html/monitorix
install -m 0644 logo_top.png ${RPM_BUILD_ROOT}/var/www/html/monitorix
install -m 0644 logo_bot.png ${RPM_BUILD_ROOT}/var/www/html/monitorix
install -m 0644 monitorixico.png ${RPM_BUILD_ROOT}/var/www/html/monitorix
mkdir -p ${RPM_BUILD_ROOT}/var/www/html/monitorix/imgs
mkdir -p ${RPM_BUILD_ROOT}/var/www/cgi-bin
install -m 0755 monitorix.cgi ${RPM_BUILD_ROOT}/var/www/cgi-bin
mkdir -p ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/ca/imgs_email
install -m 0644 reports/ca/traffic_report.html ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/ca
install -m 0755 reports/ca/traffic_report.sh ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/ca
install -m 0644 reports/ca/imgs_email/blank.png ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/ca/imgs_email
install -m 0644 reports/ca/imgs_email/logo.jpg ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/ca/imgs_email
install -m 0644 reports/ca/imgs_email/signature.png ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/ca/imgs_email
install -m 0644 reports/ca/imgs_email/title.jpg ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/ca/imgs_email
mkdir -p ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/en/imgs_email
install -m 0644 reports/en/traffic_report.html ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/en
install -m 0755 reports/en/traffic_report.sh ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/en
install -m 0644 reports/en/imgs_email/blank.png ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/en/imgs_email
install -m 0644 reports/en/imgs_email/logo.jpg ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/en/imgs_email
install -m 0644 reports/en/imgs_email/signature.png ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/en/imgs_email
install -m 0644 reports/en/imgs_email/title.jpg ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/en/imgs_email
mkdir -p ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/de/imgs_email
install -m 0644 reports/de/traffic_report.html ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/de
install -m 0755 reports/de/traffic_report.sh ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/de
install -m 0644 reports/de/imgs_email/blank.png ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/de/imgs_email
install -m 0644 reports/de/imgs_email/logo.jpg ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/de/imgs_email
install -m 0644 reports/de/imgs_email/signature.png ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/de/imgs_email
install -m 0644 reports/de/imgs_email/title.jpg ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/de/imgs_email
mkdir -p ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/it/imgs_email
install -m 0644 reports/it/traffic_report.html ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/it
install -m 0755 reports/it/traffic_report.sh ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/it
install -m 0644 reports/it/imgs_email/blank.png ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/it/imgs_email
install -m 0644 reports/it/imgs_email/logo.jpg ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/it/imgs_email
install -m 0644 reports/it/imgs_email/signature.png ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/it/imgs_email
install -m 0644 reports/it/imgs_email/title.jpg ${RPM_BUILD_ROOT}/var/lib/monitorix/reports/it/imgs_email
mkdir -p ${RPM_BUILD_ROOT}/var/lib/monitorix/usage
mkdir -p ${RPM_BUILD_ROOT}/usr/share/man/man5
install -m 0644 man/man5/monitorix* ${RPM_BUILD_ROOT}/usr/share/man/man5

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add monitorix
mkdir -p /var/www/html/monitorix/imgs
mkdir -p /var/lib/monitorix/usage
chown apache:apache /var/www/html/monitorix/imgs

%files
%defattr(-, root, root)
/etc/init.d/monitorix
/etc/httpd/conf.d/monitorix.conf
%config(noreplace) /etc/monitorix.conf
/usr/sbin/monitorix.pl
%defattr(-, apache, apache)
/var/www/html/monitorix/logo_top.png
/var/www/html/monitorix/logo_bot.png
/var/www/html/monitorix/monitorixico.png
/var/www/cgi-bin/monitorix.cgi
%config(noreplace) /var/lib/monitorix/reports/ca/traffic_report.html
%config(noreplace) /var/lib/monitorix/reports/ca/traffic_report.sh
%config(noreplace) /var/lib/monitorix/reports/ca/imgs_email/blank.png
%config(noreplace) /var/lib/monitorix/reports/ca/imgs_email/logo.jpg
%config(noreplace) /var/lib/monitorix/reports/ca/imgs_email/signature.png
%config(noreplace) /var/lib/monitorix/reports/ca/imgs_email/title.jpg
%config(noreplace) /var/lib/monitorix/reports/en/traffic_report.html
%config(noreplace) /var/lib/monitorix/reports/en/traffic_report.sh
%config(noreplace) /var/lib/monitorix/reports/en/imgs_email/blank.png
%config(noreplace) /var/lib/monitorix/reports/en/imgs_email/logo.jpg
%config(noreplace) /var/lib/monitorix/reports/en/imgs_email/signature.png
%config(noreplace) /var/lib/monitorix/reports/en/imgs_email/title.jpg
%config(noreplace) /var/lib/monitorix/reports/de/traffic_report.html
%config(noreplace) /var/lib/monitorix/reports/de/traffic_report.sh
%config(noreplace) /var/lib/monitorix/reports/de/imgs_email/blank.png
%config(noreplace) /var/lib/monitorix/reports/de/imgs_email/logo.jpg
%config(noreplace) /var/lib/monitorix/reports/de/imgs_email/signature.png
%config(noreplace) /var/lib/monitorix/reports/de/imgs_email/title.jpg
%config(noreplace) /var/lib/monitorix/reports/it/traffic_report.html
%config(noreplace) /var/lib/monitorix/reports/it/traffic_report.sh
%config(noreplace) /var/lib/monitorix/reports/it/imgs_email/blank.png
%config(noreplace) /var/lib/monitorix/reports/it/imgs_email/logo.jpg
%config(noreplace) /var/lib/monitorix/reports/it/imgs_email/signature.png
%config(noreplace) /var/lib/monitorix/reports/it/imgs_email/title.jpg
%defattr(-, root, root)
%doc %{_mandir}/man5/monitorix*
%doc COPYING Changes README README.Slackware README.nginx README.FreeBSD TODO monitorix-alert.sh

%changelog
* Thu Sep 01 2005 Jordi Sanfeliu <jordi@fibranet.cat>
- Release 0.7.8.
- First public release.
- All changes are described in the Changes file.

