#!/usr/bin/perl
#
# @(#) Fibranet NSP, SL
# Copyright (C) 2005-2010 by Jordi Sanfeliu <jordi@fibranet.cat>
#
# Monitorix cgi for localhost and multihost.
#
use strict;
use warnings;
use RRDs;
use CGI qw/:standard/;

our $CPU_RRD;
our $KERN_RRD;
our $PROC_RRD;
our $DISK_RRD;
our $NET_RRD;
our $SERVU_RRD;
our $MAIL_RRD;
our $PORT_RRD;
our $USER_RRD;
our $NGINX_RRD;
our $INT_RRD;
our $PC_RRD;
our $HPTEMP_RRD;
our $LMTEMP_RRD;

our $CPU1_RIGID;
our $CPU1_LIMIT;
our $CPU2_RIGID;
our $CPU2_LIMIT;
our $MEMORY;
our $DISK2_RIGID;
our $DISK2_LIMIT;
our $DISK3_RIGID;
our $DISK3_LIMIT;
our @MNT_LIST;
our @MNT_ACOL;
our @MNT_LCOL;
our @NET_LIST;
our @NET_TYPE;
our @NET_RIGID;
our @NET_LIMIT;
our $SERVU1_RIGID;
our $SERVU1_LIMIT;
our $SERVU2_RIGID;
our $SERVU2_LIMIT;
our $SERVU3_RIGID;
our $SERVU3_LIMIT;
our $MAIL1_RIGID;
our $MAIL1_LIMIT;
our $MAIL2_RIGID;
our $MAIL2_LIMIT;
our $PORT01_RIGID;
our $PORT01_LIMIT;
our $PORT02_RIGID;
our $PORT02_LIMIT;
our $PORT03_RIGID;
our $PORT03_LIMIT;
our $PORT04_RIGID;
our $PORT04_LIMIT;
our $PORT05_RIGID;
our $PORT05_LIMIT;
our $PORT06_RIGID;
our $PORT06_LIMIT;
our $PORT07_RIGID;
our $PORT07_LIMIT;
our $PORT08_RIGID;
our $PORT08_LIMIT;
our $PORT09_RIGID;
our $PORT09_LIMIT;
our $PORT10_RIGID;
our $PORT10_LIMIT;
our $PORT11_RIGID;
our $PORT11_LIMIT;
our $PORT12_RIGID;
our $PORT12_LIMIT;
our $USER1_RIGID;
our $USER1_LIMIT;
our $USER2_RIGID;
our $USER2_LIMIT;
our $USER3_RIGID;
our $USER3_LIMIT;
our $NGINX_PORT;
our $NGINX1_RIGID;
our $NGINX1_LIMIT;
our $NGINX2_RIGID;
our $NGINX2_LIMIT;
our $NGINX3_RIGID;
our $NGINX3_LIMIT;
our $INT1_RIGID;
our $INT1_LIMIT;
our $INT2_RIGID;
our $INT2_LIMIT;
our $INT3_RIGID;
our $INT3_LIMIT;

our $PORT01 = defined($PORT01) ? $PORT01 : "";
our $PORT02 = defined($PORT02) ? $PORT02 : "";
our $PORT03 = defined($PORT03) ? $PORT03 : "";
our $PORT04 = defined($PORT04) ? $PORT04 : "";
our $PORT05 = defined($PORT05) ? $PORT05 : "";
our $PORT06 = defined($PORT06) ? $PORT06 : "";
our $PORT07 = defined($PORT07) ? $PORT07 : "";
our $PORT08 = defined($PORT08) ? $PORT08 : "";
our $PORT09 = defined($PORT09) ? $PORT09 : "";
our $PORT10 = defined($PORT10) ? $PORT10 : "";
our $PORT11 = defined($PORT11) ? $PORT11 : "";
our $PORT12 = defined($PORT12) ? $PORT12 : "";
our $PORT01_NAME = defined($PORT01_NAME) ? $PORT01_NAME : "";
our $PORT02_NAME = defined($PORT02_NAME) ? $PORT02_NAME : "";
our $PORT03_NAME = defined($PORT03_NAME) ? $PORT03_NAME : "";
our $PORT04_NAME = defined($PORT04_NAME) ? $PORT04_NAME : "";
our $PORT05_NAME = defined($PORT05_NAME) ? $PORT05_NAME : "";
our $PORT06_NAME = defined($PORT06_NAME) ? $PORT06_NAME : "";
our $PORT07_NAME = defined($PORT07_NAME) ? $PORT07_NAME : "";
our $PORT08_NAME = defined($PORT08_NAME) ? $PORT08_NAME : "";
our $PORT09_NAME = defined($PORT09_NAME) ? $PORT09_NAME : "";
our $PORT10_NAME = defined($PORT10_NAME) ? $PORT10_NAME : "";
our $PORT11_NAME = defined($PORT11_NAME) ? $PORT11_NAME : "";
our $PORT12_NAME = defined($PORT12_NAME) ? $PORT12_NAME : "";

our %GRAPH_TITLE;
our %GRAPHS;
our %BLACK;

our @PC_LIST;
our $TITLE;
our $HOSTNAME;
our $OSTYPE;
our $BASE_URL;
our %BASE_WWW;

our $MACHINE;
our $ENABLE_LMTEMP;
our %SENSORS_LIST;
our @HDDTEMP_LIST;
our $INETIF;

our $MULTIHOST_FOOTER;
our $MULTIHOST_IMGPERLINE;
our @SERV_LIST;

# The current two locations where the configuration file can reside.
if(-f "/etc/monitorix.conf") {
	require "/etc/monitorix.conf";
} elsif(-f "/usr/local/etc/monitorix.conf") {
	require "/usr/local/etc/monitorix.conf";
} else {
	print("Monitorix configuration file not found!.\n");
	exit(1);
}

our $REFRESH_RATE = defined($REFRESH_RATE) ? $REFRESH_RATE : "150";

our $ENABLE_CPU = defined($ENABLE_CPU) ? $ENABLE_CPU : "Y";
our $ENABLE_KERN = defined($ENABLE_KERN) ? $ENABLE_KERN : "Y";
our $ENABLE_PROC = defined($ENABLE_PROC) ? $ENABLE_PROC : "Y";
our $ENABLE_DISK = defined($ENABLE_DISK) ? $ENABLE_DISK : "Y";
our $ENABLE_NET = defined($ENABLE_NET) ? $ENABLE_NET : "Y";
our $ENABLE_SERVU = defined($ENABLE_SERVU) ? $ENABLE_SERVU : "Y";
our $ENABLE_MAIL = defined($ENABLE_MAIL) ? $ENABLE_MAIL : "Y";
our $ENABLE_PORT = defined($ENABLE_PORT) ? $ENABLE_PORT : "Y";
our $ENABLE_USER = defined($ENABLE_USER) ? $ENABLE_USER : "Y";
our $ENABLE_NGINX = defined($ENABLE_NGINX) ? $ENABLE_NGINX : "Y";
our $ENABLE_INT = defined($ENABLE_INT) ? $ENABLE_INT : "Y";

our $ENABLE_ZOOM = defined($ENABLE_ZOOM) ? $ENABLE_ZOOM : "N";
our $IFACE_MODE = defined($IFACE_MODE) ? $IFACE_MODE : "graph";
our $KERN_GRAPH_MODE = defined($KERN_GRAPH_MODE) ? $KERN_GRAPH_MODE : "R";

our $SHOW_QUEUE = defined($SHOW_QUEUE) ? $SHOW_QUEUE : "Y";

if(!($HOSTNAME)) {
	$HOSTNAME = $ENV{SERVER_NAME};
}

if(!($HOSTNAME)) {	# called from the command line
	$HOSTNAME = "127.0.0.1";
	$BASE_URL = "http://127.0.0.1";
}

my $when = param('when');
my $graph = param('graph');
my $color = param('color');
my $mode = defined(param('mode')) ? param('mode') : '';
my $val = defined(param('val')) ? param('val') : '';
if($mode ne "localhost") {
	my @host = split(/\./, $mode);
	$mode = $host[0];
	$val = $host[1];
}

my $silent = param('silent')	if(defined(param('silent')));
my $width = "450";
my $height = "150";
my $midwidth = "325";
my $midheight = "150";
my $miniwidth = "200";
my $miniheight = "66";
my $portwidth = "183";
my $zwidth = "800";
my $zheight = "300";

our ($res, $tc, $tb, $ts);

($res, $tc, $tb, $ts) = (3600, 'h', 24, 1) if $when eq "day";
($res, $tc, $tb, $ts) = (108000, 'd', 7, 1) if $when eq "week";
($res, $tc, $tb, $ts) = (216000, 'd', 30, 1) if $when eq "month";
($res, $tc, $tb, $ts) = (5184000, 'd', 365, 1) if $when eq "year";

our @graph_colors;
our $warning_color = "--color=CANVAS#880000";
our $back_color = "#FFFFFF";
our $fore_color = "#000000";
our $title_back_color = "#777777";
our $title_fore_color = "#CCCC00";
our $graph_back_color = "#CCCCCC";
if(defined($color)) {
	if($color eq "black") {
		$graph_colors[0] = "--color=CANVAS" . $BLACK{canvas};
		$graph_colors[1] = "--color=BACK" . $BLACK{back};
		$graph_colors[2] = "--color=FONT" . $BLACK{font};
		$graph_colors[3] = "--color=MGRID" . $BLACK{mgrid};
		$graph_colors[4] = "--color=GRID" . $BLACK{grid};
		$graph_colors[5] = "--color=FRAME" . $BLACK{frame};
		$graph_colors[6] = "--color=ARROW" . $BLACK{arrow};
		$graph_colors[7] = "--color=SHADEA" . $BLACK{shadea};
		$graph_colors[8] = "--color=SHADEB" . $BLACK{shadeb};
		$back_color = "#000000";
		$fore_color = "#FFFFFF";
		$title_back_color = "#333333";
		$title_fore_color = "#888800";
		$graph_back_color = "#888888";
	}
}

my $UPTIME;
my $DETECTED_MEM;

if(($OSTYPE eq "Linux-RHFC") ||
  ($OSTYPE eq "Linux-Arch") ||
  ($OSTYPE eq "Linux-Debian") ||
  ($OSTYPE eq "Linux-Gentoo") ||
  ($OSTYPE eq "Linux-Slack") ||
  ($OSTYPE eq "Linux-SuSE") ||
  ($OSTYPE eq "Linux-Generic")) {
	$UPTIME = `uptime | sed 's/^.*up//' | sed 's/..user.*\$//' | sed s'/,//g'`;
	$DETECTED_MEM = `grep -w MemTotal: /proc/meminfo | awk '{print \$2}'`;
	chomp($DETECTED_MEM);
} elsif($OSTYPE eq "FreeBSD") {
	$UPTIME = `uptime | sed 's/^.*up//' | sed 's/..user.*\$//' | sed s'/,//g'`;
	$DETECTED_MEM = `/sbin/sysctl -n hw.physmem`;	# in bytes
	chomp($DETECTED_MEM);
	$DETECTED_MEM = int($DETECTED_MEM / 1024);	# in KB
}
$DETECTED_MEM = int($DETECTED_MEM / 1024);		# in MB
$MEMORY = defined($MEMORY) ? $MEMORY : $DETECTED_MEM;

my @VERSION12;
my @VERSION12_23;
chomp($UPTIME);
if($RRDs::VERSION > 1.2) {
	my $n = 0;
	$UPTIME =~ s/:/\\:/;	# escape colons to support RRDtool v1.2+
	$VERSION12[$n++] = "--slope-mode";
	$VERSION12[$n++] = "--font=LEGEND:7:";
	$VERSION12[$n++] = "--font=TITLE:9:";
	$VERSION12[$n++] = "--font=UNIT:8:";
	if($RRDs::VERSION >= 1.3) {
		$VERSION12[$n++] = "--font=DEFAULT:0:Mono";
	}
	if($when eq "day") {
		$VERSION12[$n++] = "--x-grid=HOUR:1:HOUR:6:HOUR:6:0:%R";
	}
	$VERSION12_23[0] = "--font=TITLE:8:";
	$VERSION12_23[1] = "--font=UNIT:7:";
	if($RRDs::VERSION >= 1.3) {
		$VERSION12_23[2] = "--font=DEFAULT:0:Mono";
	}
} else {
	undef(@VERSION12);
	undef(@VERSION12_23);
}
my $DATE = `date`;

my $u = "";
if(defined($silent) && ($silent eq "yes" || $silent eq "imagetag")) {
	$fore_color = "#000000";	# visible color for text mode
	$u = "_";
}
if(defined($silent) && ($silent eq "imagetagbig")) {
	$fore_color = "#000000";	# visible color for text mode
	$u = "";
}

my $CPU1_PNG = "/monitorix/imgs/" . $u . "cpu1.$when.png";
my $CPU2_PNG = "/monitorix/imgs/" . $u . "cpu2.$when.png";
my $CPU3_PNG = "/monitorix/imgs/" . $u . "cpu3.$when.png";
my $KERN1_PNG = "/monitorix/imgs/" . $u . "kern1.$when.png";
my $KERN2_PNG = "/monitorix/imgs/" . $u . "kern2.$when.png";
my $KERN3_PNG = "/monitorix/imgs/" . $u . "kern3.$when.png";
my $PROC00_PNG = "/monitorix/imgs/" . $u . "proc00.$when.png";
my $PROC01_PNG = "/monitorix/imgs/" . $u . "proc01.$when.png";
my $PROC02_PNG = "/monitorix/imgs/" . $u . "proc02.$when.png";
my $PROC03_PNG = "/monitorix/imgs/" . $u . "proc03.$when.png";
my $PROC04_PNG = "/monitorix/imgs/" . $u . "proc04.$when.png";
my $PROC05_PNG = "/monitorix/imgs/" . $u . "proc05.$when.png";
my $PROC06_PNG = "/monitorix/imgs/" . $u . "proc06.$when.png";
my $PROC07_PNG = "/monitorix/imgs/" . $u . "proc07.$when.png";
my $HPTEMP1_PNG = "/monitorix/imgs/" . $u . "hptemp1.$when.png";
my $HPTEMP2_PNG = "/monitorix/imgs/" . $u . "hptemp2.$when.png";
my $HPTEMP3_PNG = "/monitorix/imgs/" . $u . "hptemp3.$when.png";
my $LMTEMP1_PNG = "/monitorix/imgs/" . $u . "lmtemp1.$when.png";
my $LMTEMP2_PNG = "/monitorix/imgs/" . $u . "lmtemp2.$when.png";
my $LMTEMP3_PNG = "/monitorix/imgs/" . $u . "lmtemp3.$when.png";
my $DISK1_PNG = "/monitorix/imgs/" . $u . "disk1.$when.png";
my $DISK2_PNG = "/monitorix/imgs/" . $u . "disk2.$when.png";
my $DISK3_PNG = "/monitorix/imgs/" . $u . "disk3.$when.png";
my @NET1_PNG;
my @NET2_PNG;
my @NET3_PNG;
{
my $n;
for($n = 0; $n < scalar(@NET_LIST); $n++) {
	$NET1_PNG[$n] = "/monitorix/imgs/" . $u . "net" . $n . "1.$when.png";
	$NET2_PNG[$n] = "/monitorix/imgs/" . $u . "net" . $n . "2.$when.png";
	$NET3_PNG[$n] = "/monitorix/imgs/" . $u . "net" . $n . "3.$when.png";
}
}
my $SERVU1_PNG = "/monitorix/imgs/" . $u . "servu1.$when.png";
my $SERVU2_PNG = "/monitorix/imgs/" . $u . "servu2.$when.png";
my $SERVU3_PNG = "/monitorix/imgs/" . $u . "servu3.$when.png";
my $MAIL1_PNG = "/monitorix/imgs/" . $u . "mail1.$when.png";
my $MAIL2_PNG = "/monitorix/imgs/" . $u . "mail2.$when.png";
my $MAIL3_PNG = "/monitorix/imgs/" . $u . "mail3.$when.png";
my $PORT01_PNG = "/monitorix/imgs/" . $u . "port01.$when.png";
my $PORT02_PNG = "/monitorix/imgs/" . $u . "port02.$when.png";
my $PORT03_PNG = "/monitorix/imgs/" . $u . "port03.$when.png";
my $PORT04_PNG = "/monitorix/imgs/" . $u . "port04.$when.png";
my $PORT05_PNG = "/monitorix/imgs/" . $u . "port05.$when.png";
my $PORT06_PNG = "/monitorix/imgs/" . $u . "port06.$when.png";
my $PORT07_PNG = "/monitorix/imgs/" . $u . "port07.$when.png";
my $PORT08_PNG = "/monitorix/imgs/" . $u . "port08.$when.png";
my $PORT09_PNG = "/monitorix/imgs/" . $u . "port09.$when.png";
my $PORT10_PNG = "/monitorix/imgs/" . $u . "port10.$when.png";
my $PORT11_PNG = "/monitorix/imgs/" . $u . "port11.$when.png";
my $PORT12_PNG = "/monitorix/imgs/" . $u . "port12.$when.png";
my $USER1_PNG = "/monitorix/imgs/" . $u . "user1.$when.png";
my $USER2_PNG = "/monitorix/imgs/" . $u . "user2.$when.png";
my $USER3_PNG = "/monitorix/imgs/" . $u . "user3.$when.png";
my $NGINX1_PNG = "/monitorix/imgs/" . $u . "nginx1.$when.png";
my $NGINX2_PNG = "/monitorix/imgs/" . $u . "nginx2.$when.png";
my $NGINX3_PNG = "/monitorix/imgs/" . $u . "nginx3.$when.png";
my $INT1_PNG = "/monitorix/imgs/" . $u . "int1.$when.png";
my $INT2_PNG = "/monitorix/imgs/" . $u . "int2.$when.png";
my $INT3_PNG = "/monitorix/imgs/" . $u . "int3.$when.png";
my @PC_PNG;
{
	my $n;
	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		$PC_PNG[$n] = "/monitorix/imgs/pc" . ($n+1) . ".$when.png";
	}
}
my @PANO_PNG;
{
	my $n;
	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		$PANO_PNG[$n] = "/monitorix/imgs/pano" . ($n+1) . ".$when.png";
	}
}

# Definition of the zoomed images
my $CPU1Z_PNG = "/monitorix/imgs/" . $u . "cpu1z.$when.png";
my $CPU2Z_PNG = "/monitorix/imgs/" . $u . "cpu2z.$when.png";
my $CPU3Z_PNG = "/monitorix/imgs/" . $u . "cpu3z.$when.png";
my $KERN1Z_PNG = "/monitorix/imgs/" . $u . "kern1z.$when.png";
my $KERN2Z_PNG = "/monitorix/imgs/" . $u . "kern2z.$when.png";
my $KERN3Z_PNG = "/monitorix/imgs/" . $u . "kern3z.$when.png";
my $PROC00Z_PNG = "/monitorix/imgs/" . $u . "proc00z.$when.png";
my $PROC01Z_PNG = "/monitorix/imgs/" . $u . "proc01z.$when.png";
my $PROC02Z_PNG = "/monitorix/imgs/" . $u . "proc02z.$when.png";
my $PROC03Z_PNG = "/monitorix/imgs/" . $u . "proc03z.$when.png";
my $PROC04Z_PNG = "/monitorix/imgs/" . $u . "proc04z.$when.png";
my $PROC05Z_PNG = "/monitorix/imgs/" . $u . "proc05z.$when.png";
my $PROC06Z_PNG = "/monitorix/imgs/" . $u . "proc06z.$when.png";
my $PROC07Z_PNG = "/monitorix/imgs/" . $u . "proc07z.$when.png";
my $HPTEMP1Z_PNG = "/monitorix/imgs/" . $u . "hptemp1z.$when.png";
my $HPTEMP2Z_PNG = "/monitorix/imgs/" . $u . "hptemp2z.$when.png";
my $HPTEMP3Z_PNG = "/monitorix/imgs/" . $u . "hptemp3z.$when.png";
my $LMTEMP1Z_PNG = "/monitorix/imgs/" . $u . "lmtemp1z.$when.png";
my $LMTEMP2Z_PNG = "/monitorix/imgs/" . $u . "lmtemp2z.$when.png";
my $LMTEMP3Z_PNG = "/monitorix/imgs/" . $u . "lmtemp3z.$when.png";
my $DISK1Z_PNG = "/monitorix/imgs/" . $u . "disk1z.$when.png";
my $DISK2Z_PNG = "/monitorix/imgs/" . $u . "disk2z.$when.png";
my $DISK3Z_PNG = "/monitorix/imgs/" . $u . "disk3z.$when.png";
my @NET1Z_PNG;
my @NET2Z_PNG;
my @NET3Z_PNG;
{
my $n;
for($n = 0; $n < scalar(@NET_LIST); $n++) {
	$NET1Z_PNG[$n] = "/monitorix/imgs/" . $u . "net" . $n . "1z.$when.png";
	$NET2Z_PNG[$n] = "/monitorix/imgs/" . $u . "net" . $n . "2z.$when.png";
	$NET3Z_PNG[$n] = "/monitorix/imgs/" . $u . "net" . $n . "3z.$when.png";
}
}
my $SERVU1Z_PNG = "/monitorix/imgs/" . $u . "servu1z.$when.png";
my $SERVU2Z_PNG = "/monitorix/imgs/" . $u . "servu2z.$when.png";
my $SERVU3Z_PNG = "/monitorix/imgs/" . $u . "servu3z.$when.png";
my $MAIL1Z_PNG = "/monitorix/imgs/" . $u . "mail1z.$when.png";
my $MAIL2Z_PNG = "/monitorix/imgs/" . $u . "mail2z.$when.png";
my $MAIL3Z_PNG = "/monitorix/imgs/" . $u . "mail3z.$when.png";
my $PORT01Z_PNG = "/monitorix/imgs/" . $u . "port01z.$when.png";
my $PORT02Z_PNG = "/monitorix/imgs/" . $u . "port02z.$when.png";
my $PORT03Z_PNG = "/monitorix/imgs/" . $u . "port03z.$when.png";
my $PORT04Z_PNG = "/monitorix/imgs/" . $u . "port04z.$when.png";
my $PORT05Z_PNG = "/monitorix/imgs/" . $u . "port05z.$when.png";
my $PORT06Z_PNG = "/monitorix/imgs/" . $u . "port06z.$when.png";
my $PORT07Z_PNG = "/monitorix/imgs/" . $u . "port07z.$when.png";
my $PORT08Z_PNG = "/monitorix/imgs/" . $u . "port08z.$when.png";
my $PORT09Z_PNG = "/monitorix/imgs/" . $u . "port09z.$when.png";
my $PORT10Z_PNG = "/monitorix/imgs/" . $u . "port10z.$when.png";
my $PORT11Z_PNG = "/monitorix/imgs/" . $u . "port11z.$when.png";
my $PORT12Z_PNG = "/monitorix/imgs/" . $u . "port12z.$when.png";
my $USER1Z_PNG = "/monitorix/imgs/" . $u . "user1z.$when.png";
my $USER2Z_PNG = "/monitorix/imgs/" . $u . "user2z.$when.png";
my $USER3Z_PNG = "/monitorix/imgs/" . $u . "user3z.$when.png";
my $NGINX1Z_PNG = "/monitorix/imgs/" . $u . "nginx1z.$when.png";
my $NGINX2Z_PNG = "/monitorix/imgs/" . $u . "nginx2z.$when.png";
my $NGINX3Z_PNG = "/monitorix/imgs/" . $u . "nginx3z.$when.png";
my $INT1Z_PNG = "/monitorix/imgs/" . $u . "int1z.$when.png";
my $INT2Z_PNG = "/monitorix/imgs/" . $u . "int2z.$when.png";
my $INT3Z_PNG = "/monitorix/imgs/" . $u . "int3z.$when.png";
my @PCZ_PNG;
{
	my $n;
	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		$PCZ_PNG[$n] = "/monitorix/imgs/pc" . ($n+1) . "z.$when.png";
	}
}
my @PANOZ_PNG;
{
	my $n;
	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		$PANOZ_PNG[$n] = "/monitorix/imgs/pano" . ($n+1) . "z.$when.png";
	}
}

my $inetpos;
{
	my $n;
	for($n = 0; $n < scalar(@NET_LIST); $n++) {
		if($NET_LIST[$n] eq $INETIF) {
			$inetpos = $n;
		}
	}
}

sub image_header {
	my $title = $_[0];
	my $colspan = $_[1];
	print "  <table cellspacing=5 cellpadding=0 width=1 bgcolor=" . $graph_back_color . " border=1>\n";
	print "  <tr>\n";
	print "  <td bgcolor=" . $title_back_color . " colspan=$colspan>\n";
	print "  <font face='Verdana, Tahoma, sans-serif' color=" . $title_fore_color . ">\n";
	print "    <b>&nbsp;&nbsp;$title<b>\n";
	print "  </font>\n";
	print "  </td>\n";
	print "  </tr>\n";
	print "  <tr>\n";
	print "  <td bgcolor=" . $title_back_color . ">\n";
}

sub image_footer {
	print "  </td>\n";
	print "  </tr>\n";
	print "  </table>\n";
}

print "Content-Type: text/html\n";
print "\n";
if(!defined($silent)) {
	my $title;

	print "<html>\n";
	print "  <head>\n";
	print "    <title>$TITLE</title>\n";
	print "    <link rel='shortcut icon' href='/monitorix/monitorixico.png'>\n";
	print "    <meta http-equiv=Refresh content=" . $REFRESH_RATE . ">\n";
	print "  </head>\n";
	print "  <body bgcolor=" . $back_color . " vlink='#888888' link='#888888'>\n";
	print "  <center>\n";
	print "  <table cellspacing=5 cellpadding=0 bgcolor=" . $graph_back_color . " border=1>\n";
	print "  <tr>\n";
	if($val ne "all" && $mode ne "multihost") {
		print "  <td bgcolor=" . $title_back_color . ">\n";
		print "  <font face='Verdana, Tahoma, sans-serif' color=" . $title_fore_color . ">\n";
		print "    <font size=5><b>&nbsp;&nbsp;Host:&nbsp;<b></font>\n";
		print "  </font>\n";
		print "  </td>\n";
	}
	print "  <td bgcolor=" . $back_color . ">\n";
	print "  <font face='Verdana, Tahoma, sans-serif' color=" . $fore_color . ">\n";
	if($mode eq "localhost" || $mode eq "pc") {
		$title = $HOSTNAME;
	} elsif($mode eq "multihost") {
		my %rgraphs = reverse %GRAPHS;
		$graph = $graph eq "all" ? "_cpu1" : $graph;
		$title = $rgraphs{$graph};
	}
	$title =~ s/ /&nbsp;/g;
	print "    <font size=5><b>&nbsp;&nbsp;$title&nbsp;&nbsp;</b></font>\n";
	print "  </font>\n";
	print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
		print "  <font face='Verdana, Tahoma, sans-serif' color=" . $title_fore_color . ">\n";
		print "    <font size=5><b>&nbsp;&nbsp;last&nbsp;$when&nbsp;&nbsp;<b></font>\n";
		print "  </font>\n";
		print "  </td>\n";
	print "  </tr>\n";
	print "  </table>\n";
	print "  <font face='Verdana, Tahoma, sans-serif' color=" . $fore_color . ">\n";
	print "  <h4><font color=888888>\n";
	print $DATE;
	print "  </font></h4>\n";
}
if(($mode eq "localhost") || ($silent)) {
	my $TITLE_CPU = $GRAPH_TITLE{cpu};
	my $TITLE_KERN = $GRAPH_TITLE{kern};
	my $TITLE_PROC = $GRAPH_TITLE{proc};
	my $TITLE_HPTEMP = $MACHINE . " " . $GRAPH_TITLE{hptemp};
	my $TITLE_LMTEMP = $GRAPH_TITLE{lmtemp};
	my $TITLE_DISK = $GRAPH_TITLE{disk};
	my $TITLE_NET = $GRAPH_TITLE{net};
	my $TITLE_SERVU = $GRAPH_TITLE{servu};
	my $TITLE_MAIL = $GRAPH_TITLE{mail};
	my $TITLE_PORT1 = $GRAPH_TITLE{port} . " (1/2)";
	my $TITLE_PORT2 = $GRAPH_TITLE{port} . " (2/2)";
	my $TITLE_USER = $GRAPH_TITLE{user};
	my $TITLE_NGINX = $GRAPH_TITLE{nginx};
	my $TITLE_INT = $GRAPH_TITLE{int};
	if($silent) {
		$TITLE_CPU = "";
		$TITLE_KERN = "";
		$TITLE_PROC = "";
		$TITLE_HPTEMP = "";
		$TITLE_LMTEMP = "";
		$TITLE_DISK = "";
		$TITLE_NET = "";
		$TITLE_SERVU = "";
		$TITLE_MAIL = "";
		$TITLE_PORT1 = "";
		$TITLE_PORT2 = "";
		$TITLE_USER = "";
		$TITLE_NGINX = "";
		$TITLE_INT = "";
		if($silent eq "imagetag") {
			$width = "300";
			$height = "100";
			$miniwidth = "300";
			$miniheight = "100";
			$portwidth = "300";
		}
		if($silent eq "imagetagbig") {
			$width = "450";
			$height = "150";
			$miniwidth = "450";
			$miniheight = "150";
			$portwidth = "450";
		}
	}
	if($graph eq "all" || $graph =~ /cpu/) {
		cpu_stats($TITLE_CPU) unless $ENABLE_CPU eq "N";
		print "  <br>\n" unless $ENABLE_CPU eq "N";
	}
	if($graph eq "all" || $graph =~ /kern/) {
		kern_stats($TITLE_KERN) unless $ENABLE_KERN eq "N";
		print "  <br>\n" unless $ENABLE_KERN eq "N";
	}
	if($graph eq "all" || $graph =~ /proc/) {
		proc_stats($TITLE_PROC) unless $ENABLE_PROC eq "N";
	}
	if($graph eq "all" || $graph =~ /lmtemp/) {
		lmtemp_stats($TITLE_LMTEMP) unless $ENABLE_LMTEMP eq "N";
	}
	if($MACHINE) {
		if($graph eq "all" || $graph =~ /hptemp/) {
			temp_HP($TITLE_HPTEMP);
			print "  <br>\n";
		}
	}
	if($graph eq "all" || $graph =~ /disk/) {
		disk_stats($TITLE_DISK) unless $ENABLE_DISK eq "N";
		print "  <br>\n" unless $ENABLE_DISK eq "N";
	}
	if($graph eq "all" || $graph =~ /net/) {
		net_stats($TITLE_NET) unless $ENABLE_NET eq "N";
	}
	if($graph eq "all" || $graph =~ /serv/) {
		servu_stats($TITLE_SERVU) unless $ENABLE_SERVU eq "N";
		print "  <br>\n" unless $ENABLE_SERVU eq "N";
	}
	if($graph eq "all" || $graph =~ /mail/) {
		mail_stats($TITLE_MAIL) unless $ENABLE_MAIL eq "N";
		print "  <br>\n" unless $ENABLE_MAIL eq "N";
	}
	if($graph eq "all" || $graph =~ /port/) {
		if(($graph eq "_port01") || ($graph eq "_port02") ||
		($graph eq "_port03") || ($graph eq "_port04") ||
		($graph eq "_port05") || ($graph eq "_port06") ||
		($graph eq "all")) {
			port1_stats($TITLE_PORT1) unless $ENABLE_PORT eq "N";
			print "  <br>\n" unless $ENABLE_PORT eq "N";
		}
	}
	if($graph eq "all" || $graph =~ /port/) {
		if(($graph eq "_port07") || ($graph eq "_port08") ||
		($graph eq "_port09") || ($graph eq "_port10") ||
		($graph eq "_port11") || ($graph eq "_port12") ||
		($graph eq "all")) {
			port2_stats($TITLE_PORT2) unless $ENABLE_PORT eq "N";
			print "  <br>\n" unless $ENABLE_PORT eq "N";
		}
	}
	if($graph eq "all" || $graph =~ /user/) {
		user_stats($TITLE_USER) unless $ENABLE_USER eq "N";
		print "  <br>\n" unless $ENABLE_USER eq "N";
	}
	if($graph eq "all" || $graph =~ /nginx/) {
		nginx_stats($TITLE_NGINX) unless $ENABLE_NGINX eq "N";
		print "  <br>\n" unless $ENABLE_NGINX eq "N";
	}
	if($graph eq "all" || $graph =~ /int/) {
		int_stats($TITLE_INT) unless $ENABLE_INT eq "N";
		print "  <br>\n" unless $ENABLE_INT eq "N";
	}
} elsif($mode eq "multihost") {
	multihost_stats();
} else {
	if($val eq "all") {
		panoramic_stats();
	} else {
		pc_stats();
	}
}

if(!defined($silent)) {
	print "  </font>\n";
	print "  </center>\n";
	print "  </body>\n";
	print "  <p>\n";
	print "  <a href=http://www.monitorix.org><img src=/monitorix/logo_bot.png border=0></a>\n";
	print "  <br>\n";
	print "  <font face='Verdana, Tahoma, sans-serif' color=" . $fore_color . " size=-2>\n";
	print "Copyright &copy; 2005-2010 Fibranet NSP, SL\n";
	print "  </font>\n";
	print "</html>\n";
}
exit(0);


sub cpu_stats {
	my @tmp;
	my @tmp2;
	my @area_freebsd;
	my @line_freebsd;
	my @osdep;
	my $err;

	unlink ("$BASE_WWW{$OSTYPE}$CPU1_PNG",
		"$BASE_WWW{$OSTYPE}$CPU2_PNG",
		"$BASE_WWW{$OSTYPE}$CPU3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$CPU1Z_PNG",
			"$BASE_WWW{$OSTYPE}$CPU2Z_PNG",
			"$BASE_WWW{$OSTYPE}$CPU3Z_PNG");
	}

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$CPU_RRD",
			"--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $CPU_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		print "       CPU load average    Memory usage in MB     Processes\n";
		print "Time   1min  5min 15min    Used  Cached Buffers   Total   Run\n";
		print "-------------------------------------------------------------\n";
		my $line;
		my @row;
		my $time;
		my $n;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			my ($cpu1, $cpu5, $cpu15, $nproc, $buff, $cach, $free, undef, $nprun) = @$line;
			$buff /= 1024;
			$cach /= 1024;
			$free /= 1024;
			@row = ($cpu1, $cpu5, $cpu15, $MEMORY - $free, $cach, $buff, $nproc, $nprun);
			$time = $time - (1 / $ts);
			printf " %2d$tc   %4.1f  %4.1f  %4.1f  %6d  %6d  %6d   %5d %5d \n", $time, @row;
		}
		print "\n";
		print "system uptime: " . `uptime | sed 's/^.*up//' | sed 's/..user.*\$//' | sed s'/,//g'`;
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 2);
		$tmp2[0] = "COMMENT: \\n";
		$tmp2[1] = "GPRINT:lcpu1:LAST: 1 minute average    Current\\: %2.2lf";
		$tmp2[2] = "GPRINT:lcpu1:AVERAGE:   Average\\: %2.2lf";
		$tmp2[3] = "GPRINT:lcpu1:MIN:   Min\\: %2.2lf";
		$tmp2[4] = "GPRINT:lcpu1:MAX:   Max\\: %2.2lf\\n";
		$tmp2[5] = "GPRINT:lcpu5:LAST: 5 minute average    Current\\: %2.2lf";
		$tmp2[6] = "GPRINT:lcpu5:AVERAGE:   Average\\: %2.2lf";
		$tmp2[7] = "GPRINT:lcpu5:MIN:   Min\\: %2.2lf";
		$tmp2[8] = "GPRINT:lcpu5:MAX:   Max\\: %2.2lf\\n";
		$tmp2[9] = "GPRINT:lcpu15:LAST:15 minute average    Current\\: %2.2lf";
		$tmp2[10] = "GPRINT:lcpu15:AVERAGE:   Average\\: %2.2lf";
		$tmp2[11] = "GPRINT:lcpu15:MIN:   Min\\: %2.2lf";
		$tmp2[12] = "GPRINT:lcpu15:MAX:   Max\\: %2.2lf\\n";
	}
	if($CPU1_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$CPU1_LIMIT";
	} else {
		if($CPU1_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$CPU1_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	my $UPTIMELINE;
	if($RRDs::VERSION > 1.2) {
		$UPTIMELINE = "COMMENT:system uptime\\: " . $UPTIME . "\\c";
	} else {
		$UPTIMELINE = "COMMENT:system uptime: " . $UPTIME . "\\c";
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$CPU1_PNG",
		"--title=CPU load average  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Load average",
		"--width=$width",
		"--height=$height",
		"--lower-limit=0",
		@VERSION12,
		@tmp,
		@graph_colors,
		"DEF:lcpu1=$CPU_RRD:cpu_load1:AVERAGE",
		"DEF:lcpu5=$CPU_RRD:cpu_load5:AVERAGE",
		"DEF:lcpu15=$CPU_RRD:cpu_load15:AVERAGE",
		"AREA:lcpu1#4444EE:1 minute average",
			"LINE1:lcpu1#0000EE",
			"LINE1:lcpu5#EEEE00:5 minute average",
			"LINE1:lcpu15#00EEEE:15 minute average",
		"COMMENT: \\n",
		@tmp2,
		"COMMENT: \\n",
		$UPTIMELINE);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$CPU1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$CPU1Z_PNG",
			"--title=CPU load average  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Load average",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@tmp,
			@graph_colors,
			"DEF:lcpu1=$CPU_RRD:cpu_load1:AVERAGE",
			"DEF:lcpu5=$CPU_RRD:cpu_load5:AVERAGE",
			"DEF:lcpu15=$CPU_RRD:cpu_load15:AVERAGE",
			"AREA:lcpu1#4444EE:1 minute average",
				"LINE1:lcpu1#0000EE",
				"LINE1:lcpu5#EEEE00:5 minute average",
				"LINE1:lcpu15#00EEEE:15 minute average");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$CPU1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /cpu1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $CPU1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$CPU1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$CPU1_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	if($CPU2_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$CPU2_LIMIT";
	} else {
		if($CPU2_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$CPU2_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$CPU2_PNG",
		"--title=Active processes  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Processes/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		"DEF:nproc=$CPU_RRD:cpu_nproc:AVERAGE",
		"DEF:npslp=$CPU_RRD:cpu_npslp:AVERAGE",
		"DEF:nprun=$CPU_RRD:cpu_nprun:AVERAGE",
		"AREA:npslp#44AAEE:Sleeping",
		"AREA:nprun#EE4444:Running",
			"LINE1:nprun#EE0000",
			"LINE1:npslp#00EEEE",
			"LINE1:nproc#EEEE00:Processes",
		"COMMENT: \\n",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$CPU2_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$CPU2Z_PNG",
			"--title=Active processes  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Processes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			"DEF:nproc=$CPU_RRD:cpu_nproc:AVERAGE",
			"DEF:npslp=$CPU_RRD:cpu_npslp:AVERAGE",
			"DEF:nprun=$CPU_RRD:cpu_nprun:AVERAGE",
			"AREA:npslp#44AAEE:Sleeping",
			"AREA:nprun#EE4444:Running",
				"LINE1:nprun#EE0000",
				"LINE1:npslp#00EEEE",
				"LINE1:nproc#EEEE00:Processes");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$CPU2Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /cpu2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $CPU2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$CPU2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$CPU2_PNG>\n";
		}
	}
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		undef(@area_freebsd);
		undef(@line_freebsd);
		$osdep[0] = "COMMENT: \\n";
	} elsif($OSTYPE eq "FreeBSD") {
		$area_freebsd[0] = "AREA:m_mval1#EEEE44:Active";
		$area_freebsd[1] = "AREA:m_mval2#4444EE:Inactive";
		$line_freebsd[0] = "LINE1:m_mval2#0000EE";
		$line_freebsd[1] = "LINE1:m_mval1#EEEE00";
		undef(@osdep);
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$CPU3_PNG",
		"--title=Memory allocation (${MEMORY}MB)  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Megabytes",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--upper-limit=$MEMORY",
		"--lower-limit=0",
		"--base=1024",
		"--rigid",
		@VERSION12,
		@VERSION12_23,
		@graph_colors,
		"DEF:mbuff=$CPU_RRD:cpu_mbuff:AVERAGE",
		"DEF:mcach=$CPU_RRD:cpu_mcach:AVERAGE",
		"DEF:mfree=$CPU_RRD:cpu_mfree:AVERAGE",
		"DEF:mval1=$CPU_RRD:cpu_mval1:AVERAGE",
		"DEF:mval2=$CPU_RRD:cpu_mval2:AVERAGE",
		"CDEF:m_mbuff=mbuff,1024,/",
		"CDEF:m_mcach=mcach,1024,/",
		"CDEF:m_mused=$MEMORY,mfree,1024,/,-",
		"CDEF:m_mval1=mval1,1024,/",
		"CDEF:m_mval2=mval2,1024,/",
		"AREA:m_mused#EE4444:Used",
		"AREA:m_mcach#44EE44:Cached",
		"AREA:m_mbuff#CCCCCC:Buffers",
		@area_freebsd,
			@line_freebsd,
			"LINE1:m_mbuff#888888",
			"LINE1:m_mcach#00EE00",
			"LINE1:m_mused#EE0000",
		@osdep,
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$CPU3_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$CPU3Z_PNG",
			"--title=Memory allocation (${MEMORY}MB)  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Megabytes",
			"--width=$zwidth",
			"--height=$zheight",
			"--upper-limit=$MEMORY",
			"--lower-limit=0",
			"--base=1024",
			"--rigid",
			@VERSION12,
			@VERSION12_23,
			@graph_colors,
			"DEF:mbuff=$CPU_RRD:cpu_mbuff:AVERAGE",
			"DEF:mcach=$CPU_RRD:cpu_mcach:AVERAGE",
			"DEF:mfree=$CPU_RRD:cpu_mfree:AVERAGE",
			"DEF:mval1=$CPU_RRD:cpu_mval1:AVERAGE",
			"DEF:mval2=$CPU_RRD:cpu_mval2:AVERAGE",
			"CDEF:m_mbuff=mbuff,1024,/",
			"CDEF:m_mcach=mcach,1024,/",
			"CDEF:m_mused=$MEMORY,mfree,1024,/,-",
			"CDEF:m_mval1=mval1,1024,/",
			"CDEF:m_mval2=mval2,1024,/",
			"AREA:m_mused#EE4444:Used",
			"AREA:m_mcach#44EE44:Cached",
			"AREA:m_mbuff#CCCCCC:Buffers",
			@area_freebsd,
				@line_freebsd,
				"LINE1:m_mbuff#888888",
				"LINE1:m_mcach#00EE00",
				"LINE1:m_mused#EE0000",
			@osdep);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$CPU3Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /cpu3/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $CPU3Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$CPU3_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$CPU3_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub kern_stats {
	my @tmp;
	my @tmp2;
	my @area_freebsd;
	my @line_freebsd;
	my @osdep;
	my @CDEF;
	my $vlabel;
	my $err;

	unlink ("$BASE_WWW{$OSTYPE}$KERN1_PNG",
		"$BASE_WWW{$OSTYPE}$KERN2_PNG",
		"$BASE_WWW{$OSTYPE}$KERN3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$KERN1Z_PNG",
			"$BASE_WWW{$OSTYPE}$KERN2Z_PNG",
			"$BASE_WWW{$OSTYPE}$KERN3Z_PNG");
	}

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$KERN_RRD",
			"--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $KERN_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		print "       Kernel usage\n";
		print "Time   User   Nice    Sys   I/Ow  Ctxt.Sw\n";
		print "-----------------------------------------\n";
		my $line;
		my @row;
		my $time;
		my $n;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			my ($usr, $nic, $sys, $iow, $cs) = @$line;
			@row = ($usr, $nic, $sys, $iow, $cs);
			$time = $time - (1/ $ts);
			printf " %2d$tc  %4.1f%%  %4.1f%%  %4.1f%%  %4.1f%%   %6d \n", $time, @row;
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 2);
		$tmp2[0] = "COMMENT: \\n";
		$tmp2[1] = "GPRINT:usr:LAST: user        Current\\: %4.1lf%%";
		$tmp2[2] = "GPRINT:usr:AVERAGE:    Average\\: %4.1lf%%";
		$tmp2[3] = "GPRINT:usr:MIN:    Min\\: %4.1lf%%";
		$tmp2[4] = "GPRINT:usr:MAX:    Max\\: %4.1lf%%\\n";
		$tmp2[5] = "GPRINT:nic:LAST: nice        Current\\: %4.1lf%%";
		$tmp2[6] = "GPRINT:nic:AVERAGE:    Average\\: %4.1lf%%";
		$tmp2[7] = "GPRINT:nic:MIN:    Min\\: %4.1lf%%";
		$tmp2[8] = "GPRINT:nic:MAX:    Max\\: %4.1lf%%\\n";
		$tmp2[9] = "GPRINT:sys:LAST: system      Current\\: %4.1lf%%";
		$tmp2[10] = "GPRINT:sys:AVERAGE:    Average\\: %4.1lf%%";
		$tmp2[11] = "GPRINT:sys:MIN:    Min\\: %4.1lf%%";
		$tmp2[12] = "GPRINT:sys:MAX:    Max\\: %4.1lf%%\\n";
		$tmp2[13] = "GPRINT:iow:LAST: i/o wait    Current\\: %4.1lf%%";
		$tmp2[14] = "GPRINT:iow:AVERAGE:    Average\\: %4.1lf%%";
		$tmp2[15] = "GPRINT:iow:MIN:    Min\\: %4.1lf%%";
		$tmp2[16] = "GPRINT:iow:MAX:    Max\\: %4.1lf%%\\n";
	}
	if($KERN_GRAPH_MODE eq "R") {
		$vlabel = "Real Percent (%)";
		$CDEF[0] = "AREA:usr#4444EE:user";
		$CDEF[1] = "AREA:nic#EEEE44:nice";
		$CDEF[2] = "AREA:sys#44EEEE:system";
		$CDEF[3] = "AREA:iow#EE44EE:i/o wait";
		$CDEF[4] = "LINE1:iow#EE00EE";
		$CDEF[5] = "LINE1:sys#00EEEE";
		$CDEF[6] = "LINE1:nic#EEEE00";
		$CDEF[7] = "LINE1:usr#0000EE";
	} else {
		$vlabel = "Stacked Percent (%)";
		$CDEF[0] = "CDEF:s_nic=usr,nic,+";
		$CDEF[1] = "CDEF:s_sys=s_nic,sys,+";
		$CDEF[2] = "CDEF:s_iow=s_sys,iow,+";
		$CDEF[3] = "AREA:s_iow#EE44EE:i/o wait";
		$CDEF[4] = "AREA:s_sys#44EEEE:system";
		$CDEF[5] = "AREA:s_nic#EEEE44:nice";
		$CDEF[6] = "AREA:usr#4444EE:user";
		$CDEF[7] = "LINE1:s_iow#EE00EE";
		$CDEF[8] = "LINE1:s_sys#00EEEE";
		$CDEF[9] = "LINE1:s_nic#EEEE00";
		$CDEF[10] = "LINE1:usr#0000EE";
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$KERN1_PNG",
		"--title=Kernel usage  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=$vlabel",
		"--width=$width",
		"--height=$height",
		"--upper-limit=100",
		"--lower-limit=0",
		"--rigid",
		@VERSION12,
		@tmp,
		@graph_colors,
		"DEF:usr=$KERN_RRD:kern_usr:AVERAGE",
		"DEF:nic=$KERN_RRD:kern_nic:AVERAGE",
		"DEF:sys=$KERN_RRD:kern_sys:AVERAGE",
		"DEF:iow=$KERN_RRD:kern_iow:AVERAGE",
		@CDEF,
		"COMMENT: \\n",
		@tmp2,
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$KERN1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$KERN1Z_PNG",
			"--title=Kernel usage  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=$vlabel",
			"--width=$zwidth",
			"--height=$zheight",
			"--upper-limit=100",
			"--lower-limit=0",
			"--rigid",
			@VERSION12,
			@tmp,
			@graph_colors,
			"DEF:usr=$KERN_RRD:kern_usr:AVERAGE",
			"DEF:nic=$KERN_RRD:kern_nic:AVERAGE",
			"DEF:sys=$KERN_RRD:kern_sys:AVERAGE",
			"DEF:iow=$KERN_RRD:kern_iow:AVERAGE",
			@CDEF);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$KERN1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /kern1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $KERN1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$KERN1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$KERN1_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td valign='top' bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	RRDs::graph("$BASE_WWW{$OSTYPE}$KERN2_PNG",
		"--title=Context switches  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=CS/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		"DEF:cs=$KERN_RRD:kern_cs:AVERAGE",
		"AREA:cs#44AAEE:Context switches",
			"LINE1:cs#00EEEE",
		"COMMENT: \\n",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$KERN2_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$KERN2Z_PNG",
			"--title=Context switches  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=CS/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			"DEF:cs=$KERN_RRD:kern_cs:AVERAGE",
			"AREA:cs#44AAEE:Context switches",
				"LINE1:cs#00EEEE");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$KERN2Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /kern2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $KERN2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$KERN2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$KERN2_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub proc_stats {
	my @tmp;
	my @tmp2;
	my @tmp3;
	my @tmp4;
	my @tmp3z;
	my @tmp4z;
	my @lDEF;
	my @rDEF;
	my $lno;
	my $rno = 0;
	my @area_freebsd;
	my @line_freebsd;
	my @osdep;
	my @lCDEF;
	my @rCDEF;
	my $vlabel;
	my $ncpu;
	my $maxcpu = 8;
	my $n;
	my $err;

	my $title = $_[0];
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$ncpu = `grep -w processor /proc/cpuinfo | tail -1 | awk '{ print \$3 }'`;
		chomp($ncpu);
		$ncpu++;
	} elsif($OSTYPE eq "FreeBSD") {
		$ncpu = `/sbin/sysctl -n hw.ncpu`;
		chomp($ncpu);
	}

	# Make sure $ncpu won't be higher than the maximum CPU supported.
	$ncpu = $ncpu > $maxcpu ? $maxcpu : $ncpu;

	if($IFACE_MODE eq "text") {
		if($title) {
			image_header($title, 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$PROC_RRD", "--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $PROC_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		for($n = 0; $n < $ncpu; $n++) {
			print "       Processor $n    ";
		}
		print "\nTime";
		for($n = 0; $n < $ncpu; $n++) {
			print "   User Nice  Sys I/Ow";
		}
		print " \n----";
		for($n = 0; $n < $ncpu; $n++) {
			print "----------------------";
		}
		print " \n";
		my $line;
		my @row;
		my $time;
		my $n2;
		my $from;
		my $to;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			$time = $time - (1 / $ts);
			printf " %2d$tc ", $time;
			for($n2 = 0; $n2 < $ncpu; $n2++) {
				$from = $n2 * 4;
				$to = $from + 4;
				my ($usr, $nic, $sys, $iow,) = @$line[$from..$to];
				@row = ($usr, $nic, $sys, $iow);
				printf "  %3d%% %3d%% %3d%% %3d%% ", @row;
			}
			print "\n";
		}
		print "</pre>";
		print "\n";
		if($title) {
			image_footer();
			print "  <br>\n";
		}
		return;
	}

	if($ncpu > 1) {
		unlink ("$BASE_WWW{$OSTYPE}$PROC00_PNG",
			"$BASE_WWW{$OSTYPE}$PROC01_PNG",
			"$BASE_WWW{$OSTYPE}$PROC02_PNG",
			"$BASE_WWW{$OSTYPE}$PROC03_PNG",
			"$BASE_WWW{$OSTYPE}$PROC04_PNG",
			"$BASE_WWW{$OSTYPE}$PROC05_PNG",
			"$BASE_WWW{$OSTYPE}$PROC06_PNG",
			"$BASE_WWW{$OSTYPE}$PROC07_PNG");
		if($ENABLE_ZOOM eq "Y") {
			unlink ("$BASE_WWW{$OSTYPE}$PROC00Z_PNG",
				"$BASE_WWW{$OSTYPE}$PROC01Z_PNG",
				"$BASE_WWW{$OSTYPE}$PROC02Z_PNG",
				"$BASE_WWW{$OSTYPE}$PROC03Z_PNG",
				"$BASE_WWW{$OSTYPE}$PROC04Z_PNG",
				"$BASE_WWW{$OSTYPE}$PROC05Z_PNG",
				"$BASE_WWW{$OSTYPE}$PROC06Z_PNG",
				"$BASE_WWW{$OSTYPE}$PROC07Z_PNG");
		}
		$tmp[0] = "COMMENT: \\n";
		$tmp[1] = "GPRINT:lusr:LAST: user       Cur\\: %4.1lf%%";
		$tmp[2] = "GPRINT:lusr:AVERAGE:  Avg\\: %4.1lf%%";
		$tmp[3] = "GPRINT:lusr:MIN:  Min\\: %4.1lf%%";
		$tmp[4] = "GPRINT:lusr:MAX:  Max\\: %4.1lf%%\\n";
		$tmp[5] = "GPRINT:lnic:LAST: nice       Cur\\: %4.1lf%%";
		$tmp[6] = "GPRINT:lnic:AVERAGE:  Avg\\: %4.1lf%%";
		$tmp[7] = "GPRINT:lnic:MIN:  Min\\: %4.1lf%%";
		$tmp[8] = "GPRINT:lnic:MAX:  Max\\: %4.1lf%%\\n";
		$tmp[9] = "GPRINT:lsys:LAST: system     Cur\\: %4.1lf%%";
		$tmp[10] = "GPRINT:lsys:AVERAGE:  Avg\\: %4.1lf%%";
		$tmp[11] = "GPRINT:lsys:MIN:  Min\\: %4.1lf%%";
		$tmp[12] = "GPRINT:lsys:MAX:  Max\\: %4.1lf%%\\n";
		$tmp[13] = "GPRINT:liow:LAST: i/o wait   Cur\\: %4.1lf%%";
		$tmp[14] = "GPRINT:liow:AVERAGE:  Avg\\: %4.1lf%%";
		$tmp[15] = "GPRINT:liow:MIN:  Min\\: %4.1lf%%";
		$tmp[16] = "GPRINT:liow:MAX:  Max\\: %4.1lf%%\\n";
		$tmp2[0] = "COMMENT: \\n";
		$tmp2[1] = "GPRINT:rusr:LAST: user       Cur\\: %4.1lf%%";
		$tmp2[2] = "GPRINT:rusr:AVERAGE:  Avg\\: %4.1lf%%";
		$tmp2[3] = "GPRINT:rusr:MIN:  Min\\: %4.1lf%%";
		$tmp2[4] = "GPRINT:rusr:MAX:  Max\\: %4.1lf%%\\n";
		$tmp2[5] = "GPRINT:rnic:LAST: nice       Cur\\: %4.1lf%%";
		$tmp2[6] = "GPRINT:rnic:AVERAGE:  Avg\\: %4.1lf%%";
		$tmp2[7] = "GPRINT:rnic:MIN:  Min\\: %4.1lf%%";
		$tmp2[8] = "GPRINT:rnic:MAX:  Max\\: %4.1lf%%\\n";
		$tmp2[9] = "GPRINT:rsys:LAST: system     Cur\\: %4.1lf%%";
		$tmp2[10] = "GPRINT:rsys:AVERAGE:  Avg\\: %4.1lf%%";
		$tmp2[11] = "GPRINT:rsys:MIN:  Min\\: %4.1lf%%";
		$tmp2[12] = "GPRINT:rsys:MAX:  Max\\: %4.1lf%%\\n";
		$tmp2[13] = "GPRINT:riow:LAST: i/o wait   Cur\\: %4.1lf%%";
		$tmp2[14] = "GPRINT:riow:AVERAGE:  Avg\\: %4.1lf%%";
		$tmp2[15] = "GPRINT:riow:MIN:  Min\\: %4.1lf%%";
		$tmp2[16] = "GPRINT:riow:MAX:  Max\\: %4.1lf%%\\n";
		$tmp3[0] = "$BASE_WWW{$OSTYPE}$PROC00_PNG";
		$tmp3[1] = "$BASE_WWW{$OSTYPE}$PROC01_PNG";
		$tmp3[2] = "$BASE_WWW{$OSTYPE}$PROC02_PNG";
		$tmp3[3] = "$BASE_WWW{$OSTYPE}$PROC03_PNG";
		$tmp3[4] = "$BASE_WWW{$OSTYPE}$PROC04_PNG";
		$tmp3[5] = "$BASE_WWW{$OSTYPE}$PROC05_PNG";
		$tmp3[6] = "$BASE_WWW{$OSTYPE}$PROC06_PNG";
		$tmp3[7] = "$BASE_WWW{$OSTYPE}$PROC07_PNG";
		$tmp4[0] = "$BASE_URL$PROC00_PNG";
		$tmp4[1] = "$BASE_URL$PROC01_PNG";
		$tmp4[2] = "$BASE_URL$PROC02_PNG";
		$tmp4[3] = "$BASE_URL$PROC03_PNG";
		$tmp4[4] = "$BASE_URL$PROC04_PNG";
		$tmp4[5] = "$BASE_URL$PROC05_PNG";
		$tmp4[6] = "$BASE_URL$PROC06_PNG";
		$tmp4[7] = "$BASE_URL$PROC07_PNG";
		if($ENABLE_ZOOM eq "Y") {
			$tmp3z[0] = "$BASE_WWW{$OSTYPE}$PROC00Z_PNG";
			$tmp3z[1] = "$BASE_WWW{$OSTYPE}$PROC01Z_PNG";
			$tmp3z[2] = "$BASE_WWW{$OSTYPE}$PROC02Z_PNG";
			$tmp3z[3] = "$BASE_WWW{$OSTYPE}$PROC03Z_PNG";
			$tmp3z[4] = "$BASE_WWW{$OSTYPE}$PROC04Z_PNG";
			$tmp3z[5] = "$BASE_WWW{$OSTYPE}$PROC05Z_PNG";
			$tmp3z[6] = "$BASE_WWW{$OSTYPE}$PROC06Z_PNG";
			$tmp3z[7] = "$BASE_WWW{$OSTYPE}$PROC07Z_PNG";
			$tmp4z[0] = "$BASE_URL$PROC00Z_PNG";
			$tmp4z[1] = "$BASE_URL$PROC01Z_PNG";
			$tmp4z[2] = "$BASE_URL$PROC02Z_PNG";
			$tmp4z[3] = "$BASE_URL$PROC03Z_PNG";
			$tmp4z[4] = "$BASE_URL$PROC04Z_PNG";
			$tmp4z[5] = "$BASE_URL$PROC05Z_PNG";
			$tmp4z[6] = "$BASE_URL$PROC06Z_PNG";
			$tmp4z[7] = "$BASE_URL$PROC07Z_PNG";
		}
		if($KERN_GRAPH_MODE eq "R") {
			$vlabel = "Real Percent (%)";
			$lCDEF[0] = "AREA:lusr#4444EE:user";
			$lCDEF[1] = "AREA:lnic#EEEE44:nice";
			$lCDEF[2] = "AREA:lsys#44EEEE:system";
			$lCDEF[3] = "AREA:liow#EE44EE:i/o wait";
			$lCDEF[4] = "LINE1:liow#EE00EE";
			$lCDEF[5] = "LINE1:lsys#00EEEE";
			$lCDEF[6] = "LINE1:lnic#EEEE00";
			$lCDEF[7] = "LINE1:lusr#0000EE";
			$rCDEF[0] = "AREA:rusr#4444EE:user";
			$rCDEF[1] = "AREA:rnic#EEEE44:nice";
			$rCDEF[2] = "AREA:rsys#44EEEE:system";
			$rCDEF[3] = "AREA:riow#EE44EE:i/o wait";
			$rCDEF[4] = "LINE1:riow#EE00EE";
			$rCDEF[5] = "LINE1:rsys#00EEEE";
			$rCDEF[6] = "LINE1:rnic#EEEE00";
			$rCDEF[7] = "LINE1:rusr#0000EE";
		} else {
			$vlabel = "Stacked Percent (%)";
			$lCDEF[0] = "CDEF:s_lnic=lusr,lnic,+";
			$lCDEF[1] = "CDEF:s_lsys=s_lnic,lsys,+";
			$lCDEF[2] = "CDEF:s_liow=s_lsys,liow,+";
			$lCDEF[3] = "AREA:s_liow#EE44EE:i/o wait";
			$lCDEF[4] = "AREA:s_lsys#44EEEE:system";
			$lCDEF[5] = "AREA:s_lnic#EEEE44:nice";
			$lCDEF[6] = "AREA:lusr#4444EE:user";
			$lCDEF[7] = "LINE1:s_liow#EE00EE";
			$lCDEF[8] = "LINE1:s_lsys#00EEEE";
			$lCDEF[9] = "LINE1:s_lnic#EEEE00";
			$lCDEF[10] = "LINE1:lusr#0000EE";
			$rCDEF[0] = "CDEF:s_rnic=rusr,rnic,+";
			$rCDEF[1] = "CDEF:s_rsys=s_rnic,rsys,+";
			$rCDEF[2] = "CDEF:s_riow=s_rsys,riow,+";
			$rCDEF[3] = "AREA:s_riow#EE44EE:i/o wait";
			$rCDEF[4] = "AREA:s_rsys#44EEEE:system";
			$rCDEF[5] = "AREA:s_rnic#EEEE44:nice";
			$rCDEF[6] = "AREA:rusr#4444EE:user";
			$rCDEF[7] = "LINE1:s_riow#EE00EE";
			$rCDEF[8] = "LINE1:s_rsys#00EEEE";
			$rCDEF[9] = "LINE1:s_rnic#EEEE00";
			$rCDEF[10] = "LINE1:rusr#0000EE";
		}
	}

	for($n = 1; $n < $ncpu; $n++) {
		$rno = $n;
		$lno = $rno - 1;
		if($title) {
			if($lno eq "0") {
				image_header($title, 2);
			} else {
				print "  <tr>\n";
				print "  <td bgcolor=" . $title_back_color . ">\n";
			}
		}
		$lDEF[0] = "DEF:lusr=" . $PROC_RRD . ":p" . $lno . "_usr:AVERAGE";
		$lDEF[1] = "DEF:lnic=" . $PROC_RRD . ":p" . $lno . "_nic:AVERAGE";
		$lDEF[2] = "DEF:lsys=" . $PROC_RRD . ":p" . $lno . "_sys:AVERAGE";
		$lDEF[3] = "DEF:liow=" . $PROC_RRD . ":p" . $lno . "_iow:AVERAGE";
		RRDs::graph($tmp3[$lno],
			"--title=Processor $lno  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=$vlabel",
			"--width=$midwidth",
			"--height=$midheight",
			"--upper-limit=100",
			"--lower-limit=0",
			"--rigid",
			@VERSION12,
			@graph_colors,
			@lDEF,
			@lCDEF,
			"COMMENT: \\n",
			@tmp);
		$err = RRDs::error;
		die "ERROR: while graphing $tmp3[$lno]: $err\n" if $err;
		if($ENABLE_ZOOM eq "Y") {
			RRDs::graph($tmp3z[$lno],
				"--title=Processor $lno  (1$when)",
				"--start=-1$when",
				"--imgformat=PNG",
				"--vertical-label=$vlabel",
				"--width=$zwidth",
				"--height=$zheight",
				"--upper-limit=100",
				"--lower-limit=0",
				"--rigid",
				@VERSION12,
				@graph_colors,
				@lDEF,
				@lCDEF);
			$err = RRDs::error;
			die "ERROR: while graphing $tmp3z[$lno]: $err\n" if $err;
		}
		if($title || ($silent =~ /imagetag/ && $graph =~ /proc$lno/)) {
			if($ENABLE_ZOOM eq "Y") {
				print "  <a href=\"javascript:void(window.open('" . $tmp4z[$lno] . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$tmp4[$lno] border=0></a>\n";
			} else {
				print "  <img src=$tmp4[$lno]>\n";
			}
		}
		if($title) {
			print "  </td>\n";
			print "  <td bgcolor=" . $title_back_color . ">\n";
		}
		$rDEF[0] = "DEF:rusr=" . $PROC_RRD . ":p" . $rno . "_usr:AVERAGE";
		$rDEF[1] = "DEF:rnic=" . $PROC_RRD . ":p" . $rno . "_nic:AVERAGE";
		$rDEF[2] = "DEF:rsys=" . $PROC_RRD . ":p" . $rno . "_sys:AVERAGE";
		$rDEF[3] = "DEF:riow=" . $PROC_RRD . ":p" . $rno . "_iow:AVERAGE";
		RRDs::graph($tmp3[$rno],
			"--title=Processor $rno  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=$vlabel",
			"--width=$midwidth",
			"--height=$midheight",
			"--upper-limit=100",
			"--lower-limit=0",
			"--rigid",
			@VERSION12,
			@graph_colors,
			@rDEF,
			@rCDEF,
			"COMMENT: \\n",
			@tmp2);
		$err = RRDs::error;
		die "ERROR: while graphing $tmp3[$rno]: $err\n" if $err;
		if($ENABLE_ZOOM eq "Y") {
			RRDs::graph($tmp3z[$rno],
				"--title=Processor $rno  (1$when)",
				"--start=-1$when",
				"--imgformat=PNG",
				"--vertical-label=$vlabel",
				"--width=$zwidth",
				"--height=$zheight",
				"--upper-limit=100",
				"--lower-limit=0",
				"--rigid",
				@VERSION12,
				@graph_colors,
				@rDEF,
				@rCDEF);
			$err = RRDs::error;
			die "ERROR: while graphing $tmp3z[$rno]: $err\n" if $err;
		}
		if($title || ($silent =~ /imagetag/ && $graph =~ /proc$rno/)) {
			if($ENABLE_ZOOM eq "Y") {
				print "  <a href=\"javascript:void(window.open('" . $tmp4z[$rno] . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$tmp4[$rno] border=0></a>\n";
			} else {
				print "  <img src=$tmp4[$rno]>\n";
			}
		}
		if($title) {
			print "  </td>\n";
			print "  </tr>\n";
		}
		$n++;
	}
	if($title && $rno > 0) {
		image_footer();
		print "  <br>\n";
	}
}

sub lmtemp_stats {
	my $n;
	my $n1;
	my $n2;
	my $n3;
	my $d;
	my @DEF;
	my @LINE2;
	my @LINE3;
	my @GPRINT_ALL;
	my @COMMENT;
	my @tmp;
	my $err;
	my @ACOLOR =   ("#FFA500",
			"#44EEEE",
			"#CCCCCC",
			"#B4B444",
			"#4444EE",
			"#44EE44",
			"#EEEE44",
			"#444444",
			"#EE44EE",
			"#EE4444",
			"#448844",
			"#BB44EE",
			"#D3D701",
			"#E29136",
			"#DDAE8C",
			"#F29967",
			"#996952",
			"#EB6C75",
			"#B84F6B",
			"#963C74",
			"#A68BBC",
			"#597AB7",
			"#8CB4CE",
			"#63BEE0",
			"#3CB5B0",
			"#7EB97C",
			"#94C36B",
			"#884632");
	my @LCOLOR =   ("#DDA500",
			"#00EEEE",
			"#888888",
			"#B4B400",
			"#0000EE",
			"#00EE00",
			"#EEEE00",
			"#444444",
			"#EE00EE",
			"#EE0000",
			"#008800",
			"#BB00EE",
			"#C8D200",
			"#DB6612",
			"#CE8248",
			"#EB6A39",
			"#8F4C30",
			"#E20045",
			"#B50C51",
			"#7B0059",
			"#684894",
			"#125AA3",
			"#518FBA",
			"#00AADA",
			"#009790",
			"#359B52",
			"#56AB27",
			"#782F1E");

	unlink ("$BASE_WWW{$OSTYPE}$LMTEMP1_PNG",
		"$BASE_WWW{$OSTYPE}$LMTEMP2_PNG",
		"$BASE_WWW{$OSTYPE}$LMTEMP3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$LMTEMP1Z_PNG",
			"$BASE_WWW{$OSTYPE}$LMTEMP2Z_PNG",
			"$BASE_WWW{$OSTYPE}$LMTEMP3Z_PNG");
	}

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$LMTEMP_RRD",
			"--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $LMTEMP_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		print "Time";
		$n3 = 0;
		if($SENSORS_LIST{'MB'}) {
			print "     MB";
			$n3 += 7;
		}
		if($SENSORS_LIST{'CPU1'}) {
			print "   CPU1";
			$n3 += 7;
		}
		if($SENSORS_LIST{'CPU2'}) {
			print "   CPU2";
			$n3 += 7;
		}
		if($SENSORS_LIST{'CPU3'}) {
			print "   CPU3";
			$n3 += 7;
		}
		if($SENSORS_LIST{'CPU4'}) {
			print "   CPU4";
			$n3 += 7;
		}
		if($SENSORS_LIST{'FAN1'}) {
			print "   FAN1";
			$n3 += 7;
		}
		if($SENSORS_LIST{'FAN2'}) {
			print "   FAN2";
			$n3 += 7;
		}
		if($SENSORS_LIST{'FAN3'}) {
			print "   FAN3";
			$n3 += 7;
		}
		for($n = 0; $n < scalar(@HDDTEMP_LIST); $n++) {
			print "   $HDDTEMP_LIST[$n]";
		}
		print " \n----";
		for($n = 0; $n < scalar(@HDDTEMP_LIST); $n++) {
			print "---";
			for($n2 = 0; $n2 < $n3; $n2++) {
				print "-";
			}
			for($n2 = 0; $n2 < length($HDDTEMP_LIST[$n]); $n2++) {
				print "-";
			}
		}
		print " \n";
		my $line;
		my @row_c;
		my @row_f;
		my @row_h;
		my $time;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			$time = $time - (1 / $ts);
			printf " %2d$tc", $time;
			if($SENSORS_LIST{'MB'}) {
				printf "    %3.1f", @$line[0];
			}
			if($SENSORS_LIST{'CPU1'}) {
				printf "    %3.1f", @$line[1];
			}
			if($SENSORS_LIST{'CPU2'}) {
				printf "    %3.1f", @$line[2];
			}
			if($SENSORS_LIST{'CPU3'}) {
				printf "    %3.1f", @$line[3];
			}
			if($SENSORS_LIST{'CPU4'}) {
				printf "    %3.1f", @$line[4];
			}
			if($SENSORS_LIST{'FAN1'}) {
				printf "    %3.1f", @$line[5];
			}
			if($SENSORS_LIST{'FAN2'}) {
				printf "    %3.1f", @$line[6];
			}
			if($SENSORS_LIST{'FAN3'}) {
				printf "    %3.1f", @$line[7];
			}
			for($n2 = 0; $n2 < scalar(@HDDTEMP_LIST); $n2++) {
				$n3 = length($HDDTEMP_LIST[$n2]);
				printf "   %$n3.1f", @$line[8 + $n2];
			}
			print " \n";
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
			print "  <br>\n";
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 2);
		$tmp[0] = "COMMENT: \\n",
		$tmp[1] = "COMMENT: \\n",
	}
	for($n = $n2 = $n3 = $d = 0, $n1 = 1; $n1 < 10; $n++, $n1++, $n2++, $n3 = $n3 + 4) {
		$DEF[$n2] = "DEF:hd" . $n1 . "=$LMTEMP_RRD:hd" . $n1 . ":AVERAGE";

		{
			my $tmp = $HDDTEMP_LIST[$n];
			if(defined($HDDTEMP_LIST[$n])) {
				$tmp =~ s/\s+$//;	# remove trailing whitespaces
				$LINE3[$n] = "LINE3:hd" . $n1 . $LCOLOR[$n] . ":" . $tmp;
			} else {
				if($RRDs::VERSION > 1.2) {
					$LINE3[$n] = "LINE0:hd" . $n1 . $LCOLOR[$n] . ":";
				} else {
					$LINE3[$n] = "LINE1:hd" . $n1 . $LCOLOR[$n] . ":";
				}
			}
		}

		if(defined($HDDTEMP_LIST[$n])) {
			$d++;
			if($_[0]) {
				my $mntpad = sprintf("%-18s", $HDDTEMP_LIST[$n]);
				$GPRINT_ALL[$n3] = "GPRINT:hd" . $n1 . ":LAST:" . $mntpad . "   Current\\: %2.0lf";
				$GPRINT_ALL[$n3 + 1] = "GPRINT:hd" . $n1 . ":AVERAGE:   Average\\: %2.0lf";
				$GPRINT_ALL[$n3 + 2] = "GPRINT:hd" . $n1 . ":MIN:   Min\\: %2.0lf";
				$GPRINT_ALL[$n3 + 3] = "GPRINT:hd" . $n1 . ":MAX:   Max\\: %2.0lf\\n";
			}
		}
	}
	if($_[0]) {
		for($n2 = 0, $n = $d; $n < 10; $n++, $n2++) {
			$COMMENT[$n2]="COMMENT: \\n";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$LMTEMP1_PNG",
		"--title=Disk drives temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=in Celsius",
		"--width=$width",
		"--height=$height",
		"--lower-limit=0",
		@VERSION12,
		@graph_colors,
		@DEF,
		@LINE3,
		@tmp,
		@GPRINT_ALL,
		@COMMENT);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$LMTEMP1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$LMTEMP1Z_PNG",
			"--title=Disk drives temperatures  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=in Celsius",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@graph_colors,
			@DEF,
			@LINE3);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$LMTEMP1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /lmtemp1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $LMTEMP1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$LMTEMP1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$LMTEMP1_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	@DEF = @LINE2 = @COMMENT = ();
	$DEF[0] = "DEF:mb=$LMTEMP_RRD:mb:AVERAGE";
	$DEF[1] = "DEF:cpu1=$LMTEMP_RRD:cpu1:AVERAGE";
	$DEF[2] = "DEF:cpu2=$LMTEMP_RRD:cpu2:AVERAGE";
	$DEF[3] = "DEF:cpu3=$LMTEMP_RRD:cpu3:AVERAGE";
	$DEF[4] = "DEF:cpu4=$LMTEMP_RRD:cpu4:AVERAGE";
	$LINE2[0] = "LINE1:mb#FFA500:MB";
	$LINE2[1] = "LINE1:cpu1#4444EE:CPU1";
	$LINE2[2] = "LINE1:cpu2#44EE44:CPU2";
	$LINE2[3] = "LINE1:cpu3#44EEEE:CPU3";
	$LINE2[4] = "LINE1:cpu4#448844:CPU4";
	if($SENSORS_LIST{'MB'}) {
		substr($LINE2[0], 0, 5, "LINE2");
	}
	if($SENSORS_LIST{'CPU1'}) {
		substr($LINE2[1], 0, 5, "LINE2");
	}
	if($SENSORS_LIST{'CPU2'}) {
		substr($LINE2[2], 0, 5, "LINE2");
	}
	if($SENSORS_LIST{'CPU3'}) {
		substr($LINE2[3], 0, 5, "LINE2");
	}
	if($SENSORS_LIST{'CPU4'}) {
		substr($LINE2[4], 0, 5, "LINE2");
	}
	$COMMENT[0] = "COMMENT: \\n";
	$COMMENT[1] = "COMMENT: \\n";
	$COMMENT[2] = "GPRINT:mb:LAST:MB\\: %2.0lf\\t";
	$COMMENT[3] = "GPRINT:cpu1:LAST:CPU1\\: %2.0lf\\t";
	$COMMENT[4] = "GPRINT:cpu3:LAST:CPU3\\: %2.0lf\\t\\r";
	$COMMENT[5] = "GPRINT:cpu2:LAST:\\t\\tCPU2\\: %2.0lf\\t";
	$COMMENT[6] = "GPRINT:cpu4:LAST:CPU4\\: %2.0lf\\t\\r";
	my $ampersand = "&";
#	if($RRDs::VERSION >= 1.3) {
#		$ampersand = "&amp;";
#	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$LMTEMP2_PNG",
		"--title=MB $ampersand CPU temperatures (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=in Celsius",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@graph_colors,
		@DEF,
		@LINE2,
		@COMMENT);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$LMTEMP2_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$LMTEMP2Z_PNG",
			"--title=MB & CPU temperatures (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=in Celsius",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@graph_colors,
			@DEF,
			@LINE2);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$LMTEMP2Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /lmtemp2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $LMTEMP2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$LMTEMP2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$LMTEMP2_PNG>\n";
		}
	}
	@DEF = @LINE2 = @COMMENT = ();
	$DEF[0] = "DEF:fan1=$LMTEMP_RRD:fan1:AVERAGE";
	$DEF[1] = "DEF:fan2=$LMTEMP_RRD:fan2:AVERAGE";
	$DEF[2] = "DEF:fan3=$LMTEMP_RRD:fan3:AVERAGE";
	$LINE2[0] = "LINE1:fan1#FFA500:FAN1";
	$LINE2[1] = "LINE1:fan2#4444EE:FAN2";
	$LINE2[2] = "LINE1:fan3#44EE44:FAN3";
	if($SENSORS_LIST{'FAN1'}) {
		substr($LINE2[0], 0, 5, "LINE2");
	}
	if($SENSORS_LIST{'FAN2'}) {
		substr($LINE2[1], 0, 5, "LINE2");
	}
	if($SENSORS_LIST{'FAN3'}) {
		substr($LINE2[2], 0, 5, "LINE2");
	}
	$COMMENT[0] = "COMMENT: \\n";
	$COMMENT[1] = "COMMENT: \\n";
	$COMMENT[2] = "GPRINT:fan1:LAST:FAN1\\: %4.0lf    ";
	$COMMENT[3] = "GPRINT:fan2:LAST:FAN2\\: %4.0lf    ";
	$COMMENT[4] = "GPRINT:fan3:LAST:FAN3\\: %4.0lf\\n";
	RRDs::graph("$BASE_WWW{$OSTYPE}$LMTEMP3_PNG",
		"--title=FAN speeds",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=RPM",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@graph_colors,
		@DEF,
		@LINE2,
		@COMMENT);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$LMTEMP3_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$LMTEMP3Z_PNG",
			"--title=FAN speeds",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=RPM",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@graph_colors,
			@DEF,
			@LINE2);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$LMTEMP3Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /lmtemp3/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $LMTEMP3Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$LMTEMP3_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$LMTEMP3_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
		print "  <br>\n";
	}
}

sub temp_HP {
	my @tmp;
	my @def;
	my @line;
	my $n1 = 0;
	my $n2 = 0;
	my $n3 = 0;
	my $err;

	if($_[0]) {
		image_header($_[0], 2);
		$tmp[$n1++] = "COMMENT: \\n";
		$tmp[$n1++] = "COMMENT: \\n";
		$tmp[$n1++] = "GPRINT:tcpu1:LAST: CPU 1               Current\\: %2.0lf";
		$tmp[$n1++] = "GPRINT:tcpu1:AVERAGE:   Average\\: %2.0lf";
		$tmp[$n1++] = "GPRINT:tcpu1:MIN:   Min\\: %2.0lf";
		$tmp[$n1++] = "GPRINT:tcpu1:MAX:   Max\\: %2.0lf\\n";
		$def[$n2++] = "DEF:tcpu1=$HPTEMP_RRD:cpu1:AVERAGE";
		$line[$n3++] = "LINE3:tcpu1#0000EE:CPU 1";
		if($MACHINE eq "ML330" || $MACHINE eq "ML350") {
			$tmp[$n1++] = "GPRINT:tcpu2:LAST: CPU 2               Current\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu2:AVERAGE:   Average\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu2:MIN:   Min\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu2:MAX:   Max\\: %2.0lf\\n";
			$tmp[$n1++] = "COMMENT: \\n";
			$def[$n2++] = "DEF:tcpu2=$HPTEMP_RRD:cpu2:AVERAGE";
			$line[$n3++] = "LINE3:tcpu2#00EEEE:CPU 2";
		}
		if($MACHINE eq "ML570") {
			$tmp[$n1++] = "GPRINT:tcpu2:LAST: CPU 2               Current\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu2:AVERAGE:   Average\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu2:MIN:   Min\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu2:MAX:   Max\\: %2.0lf\\n";
			$tmp[$n1++] = "GPRINT:tcpu3:LAST: CPU 3               Current\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu3:AVERAGE:   Average\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu3:MIN:   Min\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu3:MAX:   Max\\: %2.0lf\\n";
			$tmp[$n1++] = "GPRINT:tcpu4:LAST: CPU 4               Current\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu4:AVERAGE:   Average\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu4:MIN:   Min\\: %2.0lf";
			$tmp[$n1++] = "GPRINT:tcpu4:MAX:   Max\\: %2.0lf\\n";
			$tmp[$n1++] = "COMMENT: \\n";
			$tmp[$n1++] = "COMMENT: \\n";
			$tmp[$n1++] = "COMMENT: \\n";
			$def[$n2++] = "DEF:tcpu2=$HPTEMP_RRD:cpu2:AVERAGE";
			$def[$n2++] = "DEF:tcpu3=$HPTEMP_RRD:cpu3:AVERAGE";
			$def[$n2++] = "DEF:tcpu4=$HPTEMP_RRD:cpu4:AVERAGE";
			$line[$n3++] = "LINE3:tcpu2#00EEEE:CPU 2";
			$line[$n3++] = "LINE3:tcpu3#00EE00:CPU 3";
			$line[$n3++] = "LINE3:tcpu4#EEEE00:CPU 4";
		}
		$tmp[$n1++] = "COMMENT: \\n";
	}
	unlink ("$BASE_WWW{$OSTYPE}$HPTEMP1_PNG",
		"$BASE_WWW{$OSTYPE}$HPTEMP2_PNG",
		"$BASE_WWW{$OSTYPE}$HPTEMP3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$HPTEMP1Z_PNG",
			"$BASE_WWW{$OSTYPE}$HPTEMP2Z_PNG",
			"$BASE_WWW{$OSTYPE}$HPTEMP3Z_PNG");
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$HPTEMP1_PNG",
		"--title=CPU temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=in Celsius",
		"--width=$width",
		"--height=$height",
		"--lower-limit=0",
		@VERSION12,
		@graph_colors,
		@def,
		@line,
		@tmp,
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$HPTEMP1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$HPTEMP1Z_PNG",
			"--title=CPU temperatures  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=in Celsius",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@graph_colors,
			@def,
			@line);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$HPTEMP1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /hptemp1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $HPTEMP1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$HPTEMP1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$HPTEMP1_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td valign='top' bgcolor=" . $title_back_color . ">\n";
		undef(@def);
		undef(@line);
		undef(@tmp);
		if($MACHINE eq "ML310" || $MACHINE eq "ML330" || $MACHINE eq "ML350") {
			$def[0] = "DEF:tsb=$HPTEMP_RRD:sb:AVERAGE";
			$line[0] = "LINE2:tsb#00EEEE";
			$tmp[0] = "GPRINT:tsb:LAST:SB       Cur\\:%2.0lf";
			$tmp[1] = "GPRINT:tsb:AVERAGE: Avg\\:%2.0lf";
			$tmp[2] = "GPRINT:tsb:MIN: Min\\:%2.0lf";
			$tmp[3] = "GPRINT:tsb:MAX: Max\\:%2.0lf\\n";
		}
		if($MACHINE eq "ML570") {
			$def[0] = "DEF:tsb1=$HPTEMP_RRD:sb1:AVERAGE";
			$def[1] = "DEF:tsb2=$HPTEMP_RRD:sb2:AVERAGE";
			$line[0] = "LINE2:tsb1#0000EE:System board 1";
			$line[1] = "LINE2:tsb2#00EEEE:System board 2";
			$tmp[0] = "GPRINT:tsb1:LAST:SB 1     Cur\\:%2.0lf";
			$tmp[1] = "GPRINT:tsb1:AVERAGE: Avg\\:%2.0lf";
			$tmp[2] = "GPRINT:tsb1:MIN: Min\\:%2.0lf";
			$tmp[3] = "GPRINT:tsb1:MAX: Max\\:%2.0lf\\n";
			$tmp[4] = "GPRINT:tsb2:LAST:SB 2     Cur\\:%2.0lf";
			$tmp[5] = "GPRINT:tsb2:AVERAGE: Avg\\:%2.0lf";
			$tmp[6] = "GPRINT:tsb2:MIN: Min\\:%2.0lf";
			$tmp[7] = "GPRINT:tsb2:MAX: Max\\:%2.0lf\\n";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$HPTEMP2_PNG",
		"--title=System board temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=in Celsius",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@graph_colors,
		@def,
		@line,
		"COMMENT: \\n",
		"COMMENT: \\n",
		@tmp);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$HPTEMP2_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$HPTEMP2Z_PNG",
			"--title=System board temperatures  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=in Celsius",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@graph_colors,
			@def,
			@line);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$HPTEMP2Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /hptemp2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $HPTEMP2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$HPTEMP2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$HPTEMP2_PNG>\n";
		}
	}
	if($MACHINE eq "ML570") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$HPTEMP3_PNG",
			"--title=SCSI backplane temperatures  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=in Celsius",
			"--width=$miniwidth",
			"--height=$miniheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@graph_colors,
			"DEF:tscsi1=$HPTEMP_RRD:scsi1:AVERAGE",
			"DEF:tscsi2=$HPTEMP_RRD:scsi2:AVERAGE",
			"LINE2:tscsi1#0000EE:SCSI backplane 1",
			"LINE2:tscsi2#00EEEE:SCSI backplane 2",
			"COMMENT: \\n",
			"COMMENT: \\n",
			"GPRINT:tscsi1:LAST:SCSI B1  Cur\\:%2.0lf",
			"GPRINT:tscsi1:AVERAGE: Avg\\:%2.0lf",
			"GPRINT:tscsi1:MIN: Min\\:%2.0lf",
			"GPRINT:tscsi1:MAX: Max\\:%2.0lf\\n",
			"GPRINT:tscsi2:LAST:SCSI B2  Cur\\:%2.0lf",
			"GPRINT:tscsi2:AVERAGE: Avg\\:%2.0lf",
			"GPRINT:tscsi2:MIN: Min\\:%2.0lf",
			"GPRINT:tscsi2:MAX: Max\\:%2.0lf\\n");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$HPTEMP3_PNG: $err\n" if $err;
		if($ENABLE_ZOOM eq "Y") {
			RRDs::graph("$BASE_WWW{$OSTYPE}$HPTEMP3Z_PNG",
				"--title=SCSI backplane temperatures  (1$when)",
				"--start=-1$when",
				"--imgformat=PNG",
				"--vertical-label=in Celsius",
				"--width=$zwidth",
				"--height=$zheight",
				"--lower-limit=0",
				@VERSION12,
				@VERSION12_23,
				@graph_colors,
				"DEF:tscsi1=$HPTEMP_RRD:scsi1:AVERAGE",
				"DEF:tscsi2=$HPTEMP_RRD:scsi2:AVERAGE",
				"LINE2:tscsi1#0000EE:SCSI backplane 1",
				"LINE2:tscsi2#00EEEE:SCSI backplane 2");
			$err = RRDs::error;
			die "ERROR: while graphing $BASE_WWW{$OSTYPE}$HPTEMP3Z_PNG: $err\n" if $err;
		}
		if($_[0] || ($silent =~ /imagetag/ && $graph =~ /hptemp3/)) {
			if($ENABLE_ZOOM eq "Y") {
				print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $HPTEMP3Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$HPTEMP3_PNG border=0></a>\n";
			} else {
				print "  <img src=$BASE_URL$HPTEMP3_PNG>\n";
			}
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub disk_stats {
	my $n;
	my $n1;
	my $n2;
	my $n3;
	my @DEF_AVG;
	my @DEF_LAS;
	my @DEF_MIN;
	my @DEF_MAX;
	my @CDEF_AVG;
	my @CDEF_LAS;
	my @CDEF_MIN;
	my @CDEF_MAX;
	my @LINE2;
	my @AREA;
	my @GPRINT_ALL;
	my @COMMENT;
	my @tmp;
	my $title;
	my $vertical;
	my @osdep;
	my $err;

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$DISK_RRD", "--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $DISK_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		print "Time       /   Swap";
		for($n = 0; $n < scalar(@MNT_LIST); $n++) {
			print "   $MNT_LIST[$n]";
		}
		print "   I/O Reads  I/O Writes  Sect.Reads  Sect.Writes";
		print " \n-------------------";
		for($n = 0; $n < scalar(@MNT_LIST); $n++) {
			print "---";
			for($n2 = 0; $n2 < length($MNT_LIST[$n]); $n2++) {
				print "-";
			}
		}
		print "------------------------------------------------- \n";
		my $line;
		my @row;
		my $time;
		my $from;
		my $to;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			my (undef, $root_u, $root_f, undef, $swap_u, $swap_f) = @$line;
			$root_u = ($root_u * 100) / ($root_u + $root_f) unless $root_u == 0 && $root_f == 0;
			$swap_u = ($swap_u * 100) / ($swap_u + $swap_f) unless $root_u == 0 && $root_f == 0;
			$time = $time - (1 / $ts);
			printf " %2d$tc   %4.1f%%  %4.1f%%", $time, $root_u, $swap_u;
			for($n2 = 0; $n2 < scalar(@MNT_LIST); $n2++) {
				$from = 6 + ($n2 * 3);
				$to = $from + 3;
				my (undef, $used, $free) = @$line[$from..$to];
				$used = ($used * 100) / ($used + $free) unless $used == 0 && $free == 0;
				$n3 = length($MNT_LIST[$n2]) - 1;
				printf "   %$n3.1f%%", $used;
			}
			my ($ior, $iow, $scr, $scw) = @$line[27..30];
			printf "  %10d  %10d  %10d   %10d", $ior, $iow, $scr, $scw;
			print " \n";
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 2);
		$tmp[0] = "COMMENT: \\n",
		$tmp[1] = "COMMENT: \\n",
		$tmp[2] = "GPRINT:root_pla:LAST:/                               Cur\\: %4.1lf%%",
		$tmp[3] = "GPRINT:root_pav:AVERAGE:  Avg\\: %4.1lf%%",
		$tmp[4] = "GPRINT:root_pmi:MIN:  Min\\: %4.1lf%%",
		$tmp[5] = "GPRINT:root_pma:MAX:  Max\\: %4.1lf%%\\n",
		$tmp[6] = "GPRINT:swap_pla:LAST:swap                            Cur\\: %4.1lf%%",
		$tmp[7] = "GPRINT:swap_pav:AVERAGE:  Avg\\: %4.1lf%%",
		$tmp[8] = "GPRINT:swap_pmi:MIN:  Min\\: %4.1lf%%",
		$tmp[9] = "GPRINT:swap_pma:MAX:  Max\\: %4.1lf%%\\n",
	}
	unlink ("$BASE_WWW{$OSTYPE}$DISK1_PNG",
		"$BASE_WWW{$OSTYPE}$DISK2_PNG",
		"$BASE_WWW{$OSTYPE}$DISK3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$DISK1Z_PNG",
			"$BASE_WWW{$OSTYPE}$DISK2Z_PNG",
			"$BASE_WWW{$OSTYPE}$DISK3Z_PNG");
	}
	for($n = $n2 = $n3 = 0, $n1 = 1; $n < scalar(@MNT_LIST) && $n1 < 8; $n++, $n1++, $n2 = $n2 + 2, $n3 = $n3 + 4) {
		$DEF_AVG[$n2] = "DEF:mnt" . $n1 . "_used_av=$DISK_RRD:mnt" . $n1 . "_used:AVERAGE";
		$DEF_AVG[$n2 + 1] = "DEF:mnt" . $n1 . "_free_av=$DISK_RRD:mnt" . $n1 . "_free:AVERAGE";
		$DEF_LAS[$n2] = "DEF:mnt" . $n1 . "_used_la=$DISK_RRD:mnt" . $n1 . "_used:LAST";
		$DEF_LAS[$n2 + 1] = "DEF:mnt" . $n1 . "_free_la=$DISK_RRD:mnt" . $n1 . "_free:LAST";
		$DEF_MIN[$n2] = "DEF:mnt" . $n1 . "_used_mi=$DISK_RRD:mnt" . $n1 . "_used:MIN";
		$DEF_MIN[$n2 + 1] = "DEF:mnt" . $n1 . "_free_mi=$DISK_RRD:mnt" . $n1 . "_free:MIN";
		$DEF_MAX[$n2] = "DEF:mnt" . $n1 . "_used_ma=$DISK_RRD:mnt" . $n1 . "_used:MAX";
		$DEF_MAX[$n2 + 1] = "DEF:mnt" . $n1 . "_free_ma=$DISK_RRD:mnt" . $n1 . "_free:MAX";

		$CDEF_AVG[$n] = "CDEF:mnt" . $n1 . "_pav=mnt" . $n1 . "_used_av,100,*,mnt" . $n1 . "_used_av,mnt" . $n1 . "_free_av,+,/";
		$CDEF_LAS[$n] = "CDEF:mnt" . $n1 . "_pla=mnt" . $n1 . "_used_la,100,*,mnt" . $n1 . "_used_la,mnt" . $n1 . "_free_la,+,/";
		$CDEF_MIN[$n] = "CDEF:mnt" . $n1 . "_pmi=mnt" . $n1 . "_used_mi,100,*,mnt" . $n1 . "_used_mi,mnt" . $n1 . "_free_mi,+,/";
		$CDEF_MAX[$n] = "CDEF:mnt" . $n1 . "_pma=mnt" . $n1 . "_used_ma,100,*,mnt" . $n1 . "_used_ma,mnt" . $n1 . "_free_ma,+,/";

		{
			my $tmp = $MNT_LIST[$n];
			$tmp =~ s/\s+$//;	# remove trailing whitespaces
		$LINE2[$n] = "LINE2:mnt" . $n1 . "_pav" . $MNT_LCOL[$n] . ":" . $tmp;
		}

		if($_[0]) {
			my $mntpad = sprintf("%-18s", $MNT_LIST[$n]);
			$GPRINT_ALL[$n3] = "GPRINT:mnt" . $n1 . "_pla:LAST:" . $mntpad . "              Cur\\: %4.1lf%%";
			$GPRINT_ALL[$n3 + 1] = "GPRINT:mnt" . $n1 . "_pav:AVERAGE:  Avg\\: %4.1lf%%";
			$GPRINT_ALL[$n3 + 2] = "GPRINT:mnt" . $n1 . "_pmi:MIN:  Min\\: %4.1lf%%";
			$GPRINT_ALL[$n3 + 3] = "GPRINT:mnt" . $n1 . "_pma:MAX:  Max\\: %4.1lf%%\\n";
		}
	}
	if($_[0]) {
		for($n2 = 0, $n = $n1; $n < 8; $n++, $n2++) {
			$COMMENT[$n2]="COMMENT: \\n";
		}
	}
	for($n2 = 0, $n = scalar(@MNT_LIST); $n > 0; $n--, $n2++) {
		$n1 = $n - 1;
		$AREA[$n2] = "AREA:mnt" . $n . "_pav" . $MNT_ACOL[$n1];
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$DISK1_PNG",
		"--title=Disk usage  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Percent (%)",
		"--width=$width",
		"--height=$height",
		"--upper-limit=100",
		"--lower-limit=0",
		"--rigid",
		@VERSION12,
		@graph_colors,
		"DEF:root_used_av=$DISK_RRD:root_used:AVERAGE",
		"DEF:root_free_av=$DISK_RRD:root_free:AVERAGE",
		"DEF:swap_used_av=$DISK_RRD:swap_used:AVERAGE",
		"DEF:swap_free_av=$DISK_RRD:swap_free:AVERAGE",
		@DEF_AVG,
		"DEF:root_used_la=$DISK_RRD:root_used:LAST",
		"DEF:root_free_la=$DISK_RRD:root_free:LAST",
		"DEF:swap_used_la=$DISK_RRD:swap_used:LAST",
		"DEF:swap_free_la=$DISK_RRD:swap_free:LAST",
		@DEF_LAS,
		"DEF:root_used_mi=$DISK_RRD:root_used:MIN",
		"DEF:root_free_mi=$DISK_RRD:root_free:MIN",
		"DEF:swap_used_mi=$DISK_RRD:swap_used:MIN",
		"DEF:swap_free_mi=$DISK_RRD:swap_free:MIN",
		@DEF_MIN,
		"DEF:root_used_ma=$DISK_RRD:root_used:MAX",
		"DEF:root_free_ma=$DISK_RRD:root_free:MAX",
		"DEF:swap_used_ma=$DISK_RRD:swap_used:MAX",
		"DEF:swap_free_ma=$DISK_RRD:swap_free:MAX",
		@DEF_MAX,
		"CDEF:root_pav=root_used_av,100,*,root_used_av,root_free_av,+,/",
		"CDEF:root_pla=root_used_la,100,*,root_used_la,root_free_la,+,/",
		"CDEF:root_pmi=root_used_mi,100,*,root_used_mi,root_free_mi,+,/",
		"CDEF:root_pma=root_used_ma,100,*,root_used_ma,root_free_ma,+,/",
		"CDEF:swap_pav=swap_used_av,100,*,swap_used_av,swap_free_av,+,/",
		"CDEF:swap_pla=swap_used_la,100,*,swap_used_la,swap_free_la,+,/",
		"CDEF:swap_pmi=swap_used_mi,100,*,swap_used_mi,swap_free_mi,+,/",
		"CDEF:swap_pma=swap_used_ma,100,*,swap_used_ma,swap_free_ma,+,/",
		@CDEF_AVG,
		@CDEF_LAS,
		@CDEF_MIN,
		@CDEF_MAX,
		@AREA,
		"AREA:root_pav#EE4444",
			"LINE2:root_pav#EE0000:/",
			"LINE2:swap_pav#CCCCCC:swap",
			@LINE2,
		@tmp,
		@GPRINT_ALL,
		@COMMENT);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$DISK1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$DISK1Z_PNG",
			"--title=Disk usage  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Percent (%)",
			"--width=$zwidth",
			"--height=$zheight",
			"--upper-limit=100",
			"--lower-limit=0",
			"--rigid",
			@VERSION12,
			@graph_colors,
			"DEF:root_used_av=$DISK_RRD:root_used:AVERAGE",
			"DEF:root_free_av=$DISK_RRD:root_free:AVERAGE",
			"DEF:swap_used_av=$DISK_RRD:swap_used:AVERAGE",
			"DEF:swap_free_av=$DISK_RRD:swap_free:AVERAGE",
			@DEF_AVG,
			"DEF:root_used_la=$DISK_RRD:root_used:LAST",
			"DEF:root_free_la=$DISK_RRD:root_free:LAST",
			"DEF:swap_used_la=$DISK_RRD:swap_used:LAST",
			"DEF:swap_free_la=$DISK_RRD:swap_free:LAST",
			@DEF_LAS,
			"DEF:root_used_mi=$DISK_RRD:root_used:MIN",
			"DEF:root_free_mi=$DISK_RRD:root_free:MIN",
			"DEF:swap_used_mi=$DISK_RRD:swap_used:MIN",
			"DEF:swap_free_mi=$DISK_RRD:swap_free:MIN",
			@DEF_MIN,
			"DEF:root_used_ma=$DISK_RRD:root_used:MAX",
			"DEF:root_free_ma=$DISK_RRD:root_free:MAX",
			"DEF:swap_used_ma=$DISK_RRD:swap_used:MAX",
			"DEF:swap_free_ma=$DISK_RRD:swap_free:MAX",
			@DEF_MAX,
			"CDEF:root_pav=root_used_av,100,*,root_used_av,root_free_av,+,/",
			"CDEF:root_pla=root_used_la,100,*,root_used_la,root_free_la,+,/",
			"CDEF:root_pmi=root_used_mi,100,*,root_used_mi,root_free_mi,+,/",
			"CDEF:root_pma=root_used_ma,100,*,root_used_ma,root_free_ma,+,/",
			"CDEF:swap_pav=swap_used_av,100,*,swap_used_av,swap_free_av,+,/",
			"CDEF:swap_pla=swap_used_la,100,*,swap_used_la,swap_free_la,+,/",
			"CDEF:swap_pmi=swap_used_mi,100,*,swap_used_mi,swap_free_mi,+,/",
			"CDEF:swap_pma=swap_used_ma,100,*,swap_used_ma,swap_free_ma,+,/",
			@CDEF_AVG,
			@CDEF_LAS,
			@CDEF_MIN,
			@CDEF_MAX,
			@AREA,
			"AREA:root_pav#EE4444",
				"LINE2:root_pav#EE0000:/",
				"LINE2:swap_pav#CCCCCC:swap",
				@LINE2);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$DISK1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /disk1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $DISK1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$DISK1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$DISK1_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	if($DISK2_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$DISK2_LIMIT";
	} else {
		if($DISK2_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$DISK2_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$DISK2_PNG",
		"--title=I/O activity  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=I/O /sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		"DEF:r_cnt=$DISK_RRD:read_cnt:AVERAGE",
		"DEF:w_cnt=$DISK_RRD:write_cnt:AVERAGE",
		"AREA:w_cnt#4444EE:Write counter",
		"AREA:r_cnt#44EE44:Read counter",
		"LINE1:w_cnt#0000EE",
		"LINE1:r_cnt#00EE00",
		"COMMENT: \\n",
		"COMMENT: \\n",
		"GPRINT:r_cnt:LAST:Reads    Current\\: %8.0lf",
		"GPRINT:w_cnt:LAST:Writes   Current\\: %8.0lf");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$DISK2_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$DISK2Z_PNG",
			"--title=I/O activity  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=I/O /sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			"DEF:r_cnt=$DISK_RRD:read_cnt:AVERAGE",
			"DEF:w_cnt=$DISK_RRD:write_cnt:AVERAGE",
			"AREA:w_cnt#4444EE:Write counter",
			"AREA:r_cnt#44EE44:Read counter",
			"LINE1:w_cnt#0000EE",
			"LINE1:r_cnt#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$DISK2Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /disk2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $DISK2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$DISK2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$DISK2_PNG>\n";
		}
	}
	undef(@tmp);
	if($DISK3_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$DISK3_LIMIT";
	} else {
		if($DISK3_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$DISK3_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$title = "Sectors activity" . "  (1" . $when . ")";
		$vertical = "Sectors r/w /sec";
		$osdep[0] = "DEF:r_sec=$DISK_RRD:read_sec:AVERAGE";
		$osdep[1] = "DEF:w_sec=$DISK_RRD:write_sec:AVERAGE";
		$osdep[2] = "AREA:w_sec#4444EE:Sectors written";
		$osdep[3] = "AREA:r_sec#44EE44:Sectors read";
		$osdep[4] = "LINE1:w_sec#0000EE";
		$osdep[5] = "LINE1:r_sec#00EE00";
		$COMMENT[0] = "COMMENT: \\n";
		$COMMENT[1] = "COMMENT: \\n";
		$COMMENT[2] = "GPRINT:r_sec:LAST:Read    Current\\: %8.0lf";
		$COMMENT[3] = "GPRINT:w_sec:LAST:Written Current\\: %8.0lf";
	} elsif($OSTYPE eq "FreeBSD") {
		$title = "Data activity" . "  (1" . $when . ")";
		$vertical = "KB/sec";
		$osdep[0] = "DEF:r_sec=$DISK_RRD:read_sec:AVERAGE";
		$osdep[1] = "DEF:w_sec=$DISK_RRD:write_sec:AVERAGE";
		$osdep[2] = "AREA:w_sec#4444EE:KB Written";
		$osdep[3] = "AREA:r_sec#44EE44:KB Read";
		$osdep[4] = "LINE1:w_sec#0000EE";
		$osdep[5] = "LINE1:r_sec#00EE00";
		$COMMENT[0] = "COMMENT: \\n";
		$COMMENT[1] = "COMMENT: \\n";
		$COMMENT[2] = "GPRINT:r_sec:LAST:KB Read     Current\\: %8.0lf\\n";
		$COMMENT[3] = "GPRINT:w_sec:LAST:KB Written  Current\\: %8.0lf\\n";
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$DISK3_PNG",
		"--title=$title",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=$vertical",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@osdep,
		@COMMENT
		);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$DISK3_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$DISK3Z_PNG",
			"--title=$title",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=$vertical",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@osdep);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$DISK3Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /disk3/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $DISK3Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$DISK3_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$DISK3_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub net_stats {
	my $n;
	my @tmp;
	my @tmp2;
	my $netname;
	my $err;

	for($n = 0; $n < scalar(@NET_LIST); $n++) {
	unlink ("$BASE_WWW{$OSTYPE}$NET1_PNG[$n]",
		"$BASE_WWW{$OSTYPE}$NET2_PNG[$n]",
		"$BASE_WWW{$OSTYPE}$NET3_PNG[$n]");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$NET1Z_PNG[$n]",
			"$BASE_WWW{$OSTYPE}$NET2Z_PNG[$n]",
			"$BASE_WWW{$OSTYPE}$NET3Z_PNG[$n]");
	}
	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$NET_RRD", "--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $NET_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		print "       ";
		for($n = 0; $n < scalar(@NET_LIST); $n++) {
			 print "$NET_LIST[$n] ($NET_TYPE[$n])                         ";
		}
		print "\nTime";
		for($n = 0; $n < scalar(@NET_LIST); $n++) {
			print "   KB/s_I  KB/s_O  Pk/s_I  Pk/s_O  Er/s_I  Er/s_O";
		}
		print " \n----";
		for($n = 0; $n < scalar(@NET_LIST); $n++) {
			print "-------------------------------------------------";
		}
		print " \n";
		my $line;
		my @row;
		my $time;
		my $n2;
		my $from;
		my $to;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			$time = $time - (1 / $ts);
			printf " %2d$tc", $time;
			for($n2 = 0; $n2 < scalar(@NET_LIST); $n2++) {
				$from = $n2 * 6;
				$to = $from + 6;
				my ($ki, $ko, $pi, $po, $ei, $eo) = @$line[$from..$to];
				$ki /= 1024;
				$ko /= 1024;
				$pi /= 1024;
				$po /= 1024;
				$ei /= 1024;
				$eo /= 1024;
				@row = ($ki, $ko, $pi, $po, $ei, $eo);
				printf "   %6d  %6d  %6d  %6d  %6d  %6d", @row;
			}
			print " \n";
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
			print "  <br>\n";
		}
		return;
	}

	if($_[0]) {
		my $title=$NET_LIST[$n] . " " . $_[0];
		image_header($title, 2);
		$tmp[0] = "COMMENT: \\n",
		$tmp[1] = "COMMENT: \\n",
		$tmp[2] = "GPRINT:K_out:LAST:KB/s Output      Current\\: %5.0lf",
		$tmp[3] = "GPRINT:K_out:AVERAGE:    Average\\: %5.0lf",
		$tmp[4] = "GPRINT:K_out:MIN:    Min\\: %5.0lf",
		$tmp[5] = "GPRINT:K_out:MAX:    Max\\: %5.0lf\\n",
		$tmp[6] = "GPRINT:K_in:LAST:KB/s Input       Current\\: %5.0lf",
		$tmp[7] = "GPRINT:K_in:AVERAGE:    Average\\: %5.0lf",
		$tmp[8] = "GPRINT:K_in:MIN:    Min\\: %5.0lf",
		$tmp[9] = "GPRINT:K_in:MAX:    Max\\: %5.0lf\\n",
	}
	my @DEF;
	if($NET_RIGID[$n] eq 1) {
		$tmp2[0] = "--upper-limit=$NET_LIMIT[$n]";
	} else {
		if($NET_RIGID[$n] eq 2) {
			$tmp2[0] = "--upper-limit=$NET_LIMIT[$n]";
			$tmp2[1] = "--rigid";
		}
	}
	$DEF[0] = "DEF:B_in=$NET_RRD:net" . $n . "_bytes_in:AVERAGE";
	$DEF[1] = "DEF:B_out=$NET_RRD:net" . $n . "_bytes_out:AVERAGE";
	RRDs::graph("$BASE_WWW{$OSTYPE}$NET1_PNG[$n]",
		"--title=$NET_LIST[$n] $NET_TYPE[$n] traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$width",
		"--height=$height",
		"--lower-limit=0",
		@VERSION12,
		@tmp2,
		@graph_colors,
		@DEF,
		"CDEF:K_in=B_in,1024,/",
		"CDEF:K_out=B_out,1024,/",
		"AREA:B_out#4444EE:Output",
		"AREA:B_in#44EE44:Input",
			"LINE1:B_out#0000EE",
			"LINE1:B_in#00EE00",
		@tmp,
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NET1_PNG[$n]: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$NET1Z_PNG[$n]",
			"--title=$NET_LIST[$n] $NET_TYPE[$n] traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@tmp2,
			@graph_colors,
			@DEF,
			"CDEF:K_in=B_in,1024,/",
			"CDEF:K_out=B_out,1024,/",
			"AREA:B_out#4444EE:Output",
			"AREA:B_in#44EE44:Input",
				"LINE1:B_out#0000EE",
				"LINE1:B_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NET1Z_PNG[$n]: $err\n" if $err;
	}
	$netname="net" . $n . "1";
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /$netname/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $NET1Z_PNG[$n] . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$NET1_PNG[$n] border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$NET1_PNG[$n]>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	$DEF[0] = "DEF:p_in=$NET_RRD:net" . $n . "_packs_in:AVERAGE";
	$DEF[1] = "DEF:p_out=$NET_RRD:net" . $n . "_packs_out:AVERAGE";
	RRDs::graph("$BASE_WWW{$OSTYPE}$NET2_PNG[$n]",
		"--title=$NET_LIST[$n] packet traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Packets/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@graph_colors,
		@DEF,
		"AREA:p_out#4444EE:Output",
		"AREA:p_in#44EE44:Input",
			"LINE1:p_out#0000EE",
			"LINE1:p_in#00EE00");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NET2_PNG[$n]: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$NET2Z_PNG[$n]",
			"--title=$NET_LIST[$n] packet traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Packets/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@graph_colors,
			@DEF,
			"AREA:p_out#4444EE:Output",
			"AREA:p_in#44EE44:Input",
				"LINE1:p_out#0000EE",
				"LINE1:p_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NET2Z_PNG[$n]: $err\n" if $err;
	}
	$netname="net" . $n . "2";
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /$netname/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $NET2Z_PNG[$n] . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$NET2_PNG[$n] border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$NET2_PNG[$n]>\n";
		}
	}
	$DEF[0] = "DEF:e_in=$NET_RRD:net" . $n . "_error_in:AVERAGE";
	$DEF[1] = "DEF:e_out=$NET_RRD:net" . $n . "_error_out:AVERAGE";
	RRDs::graph("$BASE_WWW{$OSTYPE}$NET3_PNG[$n]",
		"--title=$NET_LIST[$n] traffic error  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Errors",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@graph_colors,
		@DEF,
		"AREA:e_out#4444EE:Output",
		"AREA:e_in#44EE44:Input",
			"LINE1:e_out#0000EE",
			"LINE1:e_in#00EE00");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NET3_PNG[$n]: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$NET3Z_PNG[$n]",
			"--title=$NET_LIST[$n] traffic error  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Errors",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@graph_colors,
			@DEF,
			"AREA:e_out#4444EE:Output",
			"AREA:e_in#44EE44:Input",
				"LINE1:e_out#0000EE",
				"LINE1:e_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NET3Z_PNG[$n]: $err\n" if $err;
	}
	$netname="net" . $n . "3";
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /$netname/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $NET3Z_PNG[$n] . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$NET3_PNG[$n] border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$NET3_PNG[$n]>\n";
		}
	}
	if($_[0]) {
		image_footer();
		print "  <br>\n";
	}
	}
}

sub servu_stats {
	my @tmp;
	my @tmp2;
	my $n;
	my $err;

	unlink ("$BASE_WWW{$OSTYPE}$SERVU1_PNG",
		"$BASE_WWW{$OSTYPE}$SERVU2_PNG",
		"$BASE_WWW{$OSTYPE}$SERVU3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$SERVU1Z_PNG",
			"$BASE_WWW{$OSTYPE}$SERVU2Z_PNG",
			"$BASE_WWW{$OSTYPE}$SERVU3Z_PNG");
	}

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$SERVU_RRD", "--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $SERVU_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		print "Values expressed as incremental hits.\n";
		print "Time   SMTP     SSH     FTP  Telnet   Samba VirMail     Fax    POP3     WWW \n";
		print "--------------------------------------------------------------------------- \n";
		my $line;
		my @row;
		my $time;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			my ($pop3, $smtp, $ssh, $ftp, $telnet, $www, $smb, $virusmail, $fax) = @$line;
			@row = ($smtp, $ssh, $ftp, $telnet, $smb, $virusmail, $fax, $pop3, $www);
			$time = $time - (1 / $ts);
			printf " %2d$tc %6d  %6d  %6d  %6d  %6d  %6d  %6d  %6d  %6d \n", $time, @row;
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 2);
		$tmp[0] = "COMMENT: \\n",
		$tmp[1] = "COMMENT: \\n",
		$tmp[2] = "GPRINT:smtp:LAST:SMTP           Current\\: %5.0lf",
		$tmp[3] = "GPRINT:smtp:AVERAGE:    Average\\: %5.0lf",
		$tmp[4] = "GPRINT:smtp:MIN:    Min\\: %5.0lf",
		$tmp[5] = "GPRINT:smtp:MAX:    Max\\: %5.0lf\\n",
		$tmp[6] = "GPRINT:ssh:LAST:SSH            Current\\: %5.0lf",
		$tmp[7] = "GPRINT:ssh:AVERAGE:    Average\\: %5.0lf",
		$tmp[8] = "GPRINT:ssh:MIN:    Min\\: %5.0lf",
		$tmp[9] = "GPRINT:ssh:MAX:    Max\\: %5.0lf\\n",
		$tmp[10] = "GPRINT:ftp:LAST:FTP            Current\\: %5.0lf",
		$tmp[11] = "GPRINT:ftp:AVERAGE:    Average\\: %5.0lf",
		$tmp[12] = "GPRINT:ftp:MIN:    Min\\: %5.0lf",
		$tmp[13] = "GPRINT:ftp:MAX:    Max\\: %5.0lf\\n",
		$tmp[14] = "GPRINT:telnet:LAST:Telnet         Current\\: %5.0lf",
		$tmp[15] = "GPRINT:telnet:AVERAGE:    Average\\: %5.0lf",
		$tmp[16] = "GPRINT:telnet:MIN:    Min\\: %5.0lf",
		$tmp[17] = "GPRINT:telnet:MAX:    Max\\: %5.0lf\\n",
		$tmp[18] = "GPRINT:smb:LAST:Samba          Current\\: %5.0lf",
		$tmp[19] = "GPRINT:smb:AVERAGE:    Average\\: %5.0lf",
		$tmp[20] = "GPRINT:smb:MIN:    Min\\: %5.0lf",
		$tmp[21] = "GPRINT:smb:MAX:    Max\\: %5.0lf\\n",
		$tmp[22] = "GPRINT:virusmail:LAST:VirusMail      Current\\: %5.0lf",
		$tmp[23] = "GPRINT:virusmail:AVERAGE:    Average\\: %5.0lf",
		$tmp[24] = "GPRINT:virusmail:MIN:    Min\\: %5.0lf",
		$tmp[25] = "GPRINT:virusmail:MAX:    Max\\: %5.0lf\\n",
		$tmp[26] = "GPRINT:fax:LAST:Fax            Current\\: %5.0lf",
		$tmp[27] = "GPRINT:fax:AVERAGE:    Average\\: %5.0lf",
		$tmp[28] = "GPRINT:fax:MIN:    Min\\: %5.0lf",
		$tmp[29] = "GPRINT:fax:MAX:    Max\\: %5.0lf\\n"
	}
	if($SERVU1_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$SERVU1_LIMIT";
	} else {
		if($SERVU1_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$SERVU1_LIMIT";
			$tmp2[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$SERVU1_PNG",
		"--title=Network services demand  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Incremental hits",
		"--width=$width",
		"--height=$height",
		"--lower-limit=0",
		@VERSION12,
		@tmp2,
		@graph_colors,
		"DEF:smtp=$SERVU_RRD:smtp:AVERAGE",
		"DEF:ssh=$SERVU_RRD:ssh:AVERAGE",
		"DEF:ftp=$SERVU_RRD:ftp:AVERAGE",
		"DEF:telnet=$SERVU_RRD:telnet:AVERAGE",
		"DEF:smb=$SERVU_RRD:smb:AVERAGE",
		"DEF:virusmail=$SERVU_RRD:virusmail:AVERAGE",
		"DEF:fax=$SERVU_RRD:fax:AVERAGE",
		"AREA:smtp#44EEEE:SMTP",
		"AREA:ssh#4444EE:SSH",
		"AREA:ftp#44EE44:FTP",
		"AREA:telnet#EE44EE:Telnet",
		"AREA:smb#EEEE44:Samba",
		"AREA:virusmail#EE4444:VirusMail",
		"AREA:fax#FFA500:Fax",
			"LINE1:smtp#00EEEE",
			"LINE1:ssh#0000EE",
			"LINE1:ftp#00EE00",
			"LINE1:telnet#EE00EE",
			"LINE1:smb#EEEE00",
			"LINE1:virusmail#EE0000",
			"LINE1:fax#DDA500",
		@tmp);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$SERVU1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$SERVU1Z_PNG",
			"--title=Network services demand  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Incremental hits",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@tmp2,
			@graph_colors,
			"DEF:smtp=$SERVU_RRD:smtp:AVERAGE",
			"DEF:ssh=$SERVU_RRD:ssh:AVERAGE",
			"DEF:ftp=$SERVU_RRD:ftp:AVERAGE",
			"DEF:telnet=$SERVU_RRD:telnet:AVERAGE",
			"DEF:smb=$SERVU_RRD:smb:AVERAGE",
			"DEF:virusmail=$SERVU_RRD:virusmail:AVERAGE",
			"DEF:fax=$SERVU_RRD:fax:AVERAGE",
			"AREA:smtp#44EEEE:SMTP",
			"AREA:ssh#4444EE:SSH",
			"AREA:ftp#44EE44:FTP",
			"AREA:telnet#EE44EE:Telnet",
			"AREA:smb#EEEE44:Samba",
			"AREA:virusmail#EE4444:VirusMail",
			"AREA:fax#FFA500:Fax",
				"LINE1:smtp#00EEEE",
				"LINE1:ssh#0000EE",
				"LINE1:ftp#00EE00",
				"LINE1:telnet#EE00EE",
				"LINE1:smb#EEEE00",
				"LINE1:virusmail#EE0000",
				"LINE1:fax#DDA500");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$SERVU1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /servu1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $SERVU1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$SERVU1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$SERVU1_PNG>\n";
		}
	}
	if($_[0]) {
		print"  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp2);
	if($SERVU2_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$SERVU2_LIMIT";
	} else {
		if($SERVU2_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$SERVU2_LIMIT";
			$tmp2[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$SERVU2_PNG",
		"--title=POP3 service demand  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Incremental hits",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp2,
		@graph_colors,
		"DEF:pop3=$SERVU_RRD:pop3:AVERAGE",
		"AREA:pop3#4444EE:POP3",
			"LINE1:pop3#0000EE",
		"COMMENT: \\n",
		"COMMENT: \\n",
		"GPRINT:pop3:LAST:POP3    Current\\: %5.0lf");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$SERVU2_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$SERVU2Z_PNG",
			"--title=POP3 service demand  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Incremental hits",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp2,
			@graph_colors,
			"DEF:pop3=$SERVU_RRD:pop3:AVERAGE",
			"AREA:pop3#4444EE:POP3",
				"LINE1:pop3#0000EE");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$SERVU2Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /servu2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $SERVU2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$SERVU2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$SERVU2_PNG>\n";
		}
	}
	undef(@tmp2);
	if($SERVU3_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$SERVU3_LIMIT";
	} else {
		if($SERVU3_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$SERVU3_LIMIT";
			$tmp2[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$SERVU3_PNG",
		"--title=WWW service demand  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Incremental hits",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp2,
		@graph_colors,
		"DEF:www=$SERVU_RRD:www:AVERAGE",
		"AREA:www#44EE44:WWW",
			"LINE1:www#00EE00",
		"COMMENT: \\n",
		"COMMENT: \\n",
		"GPRINT:www:LAST:WWW     Current\\: %5.0lf");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$SERVU3_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$SERVU3Z_PNG",
			"--title=WWW service demand  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Incremental hits",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp2,
			@graph_colors,
			"DEF:www=$SERVU_RRD:www:AVERAGE",
			"AREA:www#44EE44:WWW",
				"LINE1:www#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$SERVU3Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /servu3/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $SERVU3Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$SERVU3_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$SERVU3_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub mail_stats {
	my @tmp;
	my @tmp2;
	my @osdep;
	my $err;

	unlink ("$BASE_WWW{$OSTYPE}$MAIL1_PNG",
		"$BASE_WWW{$OSTYPE}$MAIL2_PNG",
		"$BASE_WWW{$OSTYPE}$MAIL3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$MAIL1Z_PNG",
			"$BASE_WWW{$OSTYPE}$MAIL2Z_PNG",
			"$BASE_WWW{$OSTYPE}$MAIL3Z_PNG");
	}

	if($_[0]) {
		image_header($_[0], 2);
		$tmp2[0] = "COMMENT: \\n";
		$tmp2[1] = "GPRINT:in_conn:LAST: In Connections     Current\\: %3.2lf";
		$tmp2[2] = "GPRINT:in_conn:AVERAGE:    Average\\: %3.2lf";
		$tmp2[3] = "GPRINT:in_conn:MIN:    Min\\: %3.2lf";
		$tmp2[4] = "GPRINT:in_conn:MAX:    Max\\: %3.2lf\\n";
		$tmp2[5] = "GPRINT:recvd:LAST: Received           Current\\: %3.2lf";
		$tmp2[6] = "GPRINT:recvd:AVERAGE:    Average\\: %3.2lf";
		$tmp2[7] = "GPRINT:recvd:MIN:    Min\\: %3.2lf";
		$tmp2[8] = "GPRINT:recvd:MAX:    Max\\: %3.2lf\\n";
		$tmp2[9] = "GPRINT:rejected:LAST: Rejected           Current\\: %3.2lf";
		$tmp2[10] = "GPRINT:rejected:AVERAGE:    Average\\: %3.2lf";
		$tmp2[11] = "GPRINT:rejected:MIN:    Min\\: %3.2lf";
		$tmp2[12] = "GPRINT:rejected:MAX:    Max\\: %3.2lf\\n";
		$tmp2[13] = "GPRINT:spam:LAST: Spam               Current\\: %3.2lf";
		$tmp2[14] = "GPRINT:spam:AVERAGE:    Average\\: %3.2lf";
		$tmp2[15] = "GPRINT:spam:MIN:    Min\\: %3.2lf";
		$tmp2[16] = "GPRINT:spam:MAX:    Max\\: %3.2lf\\n";
		$tmp2[17] = "GPRINT:virus:LAST: Virus              Current\\: %3.2lf";
		$tmp2[18] = "GPRINT:virus:AVERAGE:    Average\\: %3.2lf";
		$tmp2[19] = "GPRINT:virus:MIN:    Min\\: %3.2lf";
		$tmp2[20] = "GPRINT:virus:MAX:    Max\\: %3.2lf\\n";
		$tmp2[21] = "GPRINT:delvd:LAST: Delivered          Current\\: %3.2lf";
		$tmp2[22] = "GPRINT:delvd:AVERAGE:    Average\\: %3.2lf";
		$tmp2[23] = "GPRINT:delvd:MIN:    Min\\: %3.2lf";
		$tmp2[24] = "GPRINT:delvd:MAX:    Max\\: %3.2lf\\n";
		$tmp2[25] = "GPRINT:out_conn:LAST: Out Connections    Current\\: %3.2lf";
		$tmp2[26] = "GPRINT:out_conn:AVERAGE:    Average\\: %3.2lf";
		$tmp2[27] = "GPRINT:out_conn:MIN:    Min\\: %3.2lf";
		$tmp2[28] = "GPRINT:out_conn:MAX:    Max\\: %3.2lf\\n";
	}
	if($MAIL1_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$MAIL1_LIMIT";
	} else {
		if($MAIL1_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$MAIL1_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$MAIL1_PNG",
		"--title=Mail  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Messages/sec",
		"--width=$width",
		"--height=$height",
		@VERSION12,
		@tmp,
		@graph_colors,
		"DEF:in_conn=$MAIL_RRD:mta_val01:AVERAGE",
		"DEF:recvd=$MAIL_RRD:mta_val03:AVERAGE",
		"DEF:rejected=$MAIL_RRD:mta_val07:AVERAGE",
		"DEF:spam=$MAIL_RRD:mta_val09:AVERAGE",
		"DEF:virus=$MAIL_RRD:mta_val10:AVERAGE",
		"DEF:delvd=$MAIL_RRD:mta_val04:AVERAGE",
		"DEF:out_conn=$MAIL_RRD:mta_val02:AVERAGE",
		"CDEF:n_delvd=delvd,-1,*",
		"CDEF:n_out_conn=out_conn,-1,*",
		"AREA:in_conn#44EE44:In Conn",
		"AREA:rejected#EE4444:Rejected",
		"AREA:recvd#448844:Received",
		"AREA:spam#EEEE44:Spam",
		"AREA:virus#EE44EE:Virus",
		"AREA:n_delvd#4444EE:Delivered",
		"AREA:n_out_conn#44EEEE:Out Conn",
			"LINE1:in_conn#00EE00",
			"LINE1:rejected#EE0000",
			"LINE1:recvd#1F881F",
			"LINE1:spam#EEEE00",
			"LINE1:virus#EE00EE",
			"LINE1:n_delvd#0000EE",
			"LINE1:n_out_conn#00EEEE",
		"COMMENT: \\n",
		@tmp2,
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $MAIL1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$MAIL1Z_PNG",
			"--title=Mail  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Messages/sec",
			"--width=$zwidth",
			"--height=$zheight",
			@VERSION12,
			@tmp,
			@graph_colors,
			"DEF:in_conn=$MAIL_RRD:mta_val01:AVERAGE",
			"DEF:recvd=$MAIL_RRD:mta_val03:AVERAGE",
			"DEF:rejected=$MAIL_RRD:mta_val07:AVERAGE",
			"DEF:spam=$MAIL_RRD:mta_val09:AVERAGE",
			"DEF:virus=$MAIL_RRD:mta_val10:AVERAGE",
			"DEF:delvd=$MAIL_RRD:mta_val04:AVERAGE",
			"DEF:out_conn=$MAIL_RRD:mta_val02:AVERAGE",
			"CDEF:n_delvd=delvd,-1,*",
			"CDEF:n_out_conn=out_conn,-1,*",
			"AREA:in_conn#44EE44:In Conn",
			"AREA:rejected#EE4444:Rejected",
			"AREA:recvd#448844:Received",
			"AREA:spam#EEEE44:Spam",
			"AREA:virus#EE44EE:Virus",
			"AREA:n_delvd#4444EE:Delivered",
			"AREA:n_out_conn#44EEEE:Out Conn",
				"LINE1:in_conn#00EE00",
				"LINE1:rejected#EE0000",
				"LINE1:recvd#1F881F",
				"LINE1:spam#EEEE00",
				"LINE1:virus#EE00EE",
				"LINE1:n_delvd#0000EE",
				"LINE1:n_out_conn#00EEEE");
		$err = RRDs::error;
		die "ERROR: while graphing $MAIL1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /mail1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $MAIL1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$MAIL1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$MAIL1_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	if($MAIL2_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$MAIL2_LIMIT";
	} else {
		if($MAIL2_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$MAIL2_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	if($SHOW_QUEUE eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$MAIL2_PNG",
			"--title=Mail queue  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Messages",
			"--width=$miniwidth",
			"--height=$miniheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			"DEF:queued=$MAIL_RRD:mta_val12:AVERAGE",
			"AREA:queued#EEEE44:Queued",
				"LINE1:queued#EEEE00",
			"COMMENT: \\n",
			"COMMENT: \\n",
			"GPRINT:queued:LAST:Queued              Current\\: %5.0lf",
			"COMMENT: \\n");
		$err = RRDs::error;
		die "ERROR: while graphing $MAIL2_PNG: $err\n" if $err;
		if($ENABLE_ZOOM eq "Y") {
			RRDs::graph("$BASE_WWW{$OSTYPE}$MAIL2Z_PNG",
				"--title=Mail queue  (1$when)",
				"--start=-1$when",
				"--imgformat=PNG",
				"--vertical-label=Messages",
				"--width=$zwidth",
				"--height=$zheight",
				"--lower-limit=0",
				@VERSION12,
				@VERSION12_23,
				@tmp,
				@graph_colors,
				"DEF:queued=$MAIL_RRD:mta_val12:AVERAGE",
				"AREA:queued#EEEE44:Queued",
					"LINE1:queued#EEEE00");
			$err = RRDs::error;
			die "ERROR: while graphing $MAIL2Z_PNG: $err\n" if $err;
		}
	} else {
		RRDs::graph("$BASE_WWW{$OSTYPE}$MAIL2_PNG",
			"--title=Mail traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$miniwidth",
			"--height=$miniheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			"DEF:in=$MAIL_RRD:mta_val05:AVERAGE",
			"DEF:out=$MAIL_RRD:mta_val06:AVERAGE",
			"CDEF:K_in=in,1024,/",
			"CDEF:K_out=out,1024,/",
			"AREA:out#4444EE:Delivered",
			"AREA:in#44EE44:Received",
				"LINE1:out#0000EE",
				"LINE1:in#00EE00",
			"COMMENT: \\n",
			"COMMENT: \\n",
			"GPRINT:K_out:LAST:KB/s Delivered      Current\\: %5.0lf",
			"GPRINT:K_in:LAST:KB/s Received       Current\\: %5.0lf",
			"COMMENT: \\n");
		$err = RRDs::error;
		die "ERROR: while graphing $MAIL2_PNG: $err\n" if $err;
		if($ENABLE_ZOOM eq "Y") {
			RRDs::graph("$BASE_WWW{$OSTYPE}$MAIL2Z_PNG",
				"--title=Mail traffic  (1$when)",
				"--start=-1$when",
				"--imgformat=PNG",
				"--vertical-label=bytes/sec",
				"--width=$zwidth",
				"--height=$zheight",
				"--lower-limit=0",
				@VERSION12,
				@VERSION12_23,
				@tmp,
				@graph_colors,
				"DEF:in=$MAIL_RRD:mta_val05:AVERAGE",
				"DEF:out=$MAIL_RRD:mta_val06:AVERAGE",
				"AREA:out#4444EE:Delivered",
				"AREA:in#44EE44:Received",
					"LINE1:out#0000EE",
					"LINE1:in#00EE00");
			$err = RRDs::error;
			die "ERROR: while graphing $MAIL2Z_PNG: $err\n" if $err;
		}
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /mail2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $MAIL2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$MAIL2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$MAIL2_PNG>\n";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$MAIL3_PNG",
		"--title=Greylisting  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Messages",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@graph_colors,
		"DEF:records=$MAIL_RRD:val07:AVERAGE",
		"DEF:greylisted=$MAIL_RRD:val08:AVERAGE",
		"DEF:whitelisted=$MAIL_RRD:val09:AVERAGE",
		"AREA:greylisted#4444EE:Greylisted",
		"AREA:whitelisted#44EEEE:Whitelisted",
			"LINE1:greylisted#0000EE",
			"LINE1:whitelisted#00EEEE",
			"LINE1:records#EE0000:Records",
		@osdep,
		"COMMENT: \\n",
		"COMMENT: \\n",
		"GPRINT:whitelisted:LAST:Whitelisted         Current\\: %5.0lf",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $MAIL3_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$MAIL3Z_PNG",
			"--title=Greylisting  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Messages",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@graph_colors,
			"DEF:records=$MAIL_RRD:val07:AVERAGE",
			"DEF:greylisted=$MAIL_RRD:val08:AVERAGE",
			"DEF:whitelisted=$MAIL_RRD:val09:AVERAGE",
			"AREA:greylisted#4444EE:Greylisted",
			"AREA:whitelisted#44EEEE:Whitelisted",
				"LINE1:greylisted#0000EE",
				"LINE1:whitelisted#00EEEE",
				"LINE2:records#EE0000:Records",
			@osdep);
		$err = RRDs::error;
		die "ERROR: while graphing $MAIL3Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /mail3/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $MAIL3Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$MAIL3_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$MAIL3_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub port1_stats {
	my @tmp;
	my @warning;
	my $err;
	my $n;

	unlink ("$BASE_WWW{$OSTYPE}$PORT01_PNG",
		"$BASE_WWW{$OSTYPE}$PORT02_PNG",
		"$BASE_WWW{$OSTYPE}$PORT03_PNG",
		"$BASE_WWW{$OSTYPE}$PORT04_PNG",
		"$BASE_WWW{$OSTYPE}$PORT05_PNG",
		"$BASE_WWW{$OSTYPE}$PORT06_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$PORT01Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT02Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT03Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT04Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT05Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT06Z_PNG");
	}

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$PORT_RRD", "--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $PORT_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		printf "       Port %4s %-7s  Port %4s %-7s  Port %4s %-7s  Port %4s %-7s  Port %4s %-7s  Port %4s %-7s\n", $PORT01, $PORT01_NAME, $PORT02, $PORT02_NAME, $PORT03, $PORT03_NAME, $PORT04, $PORT04_NAME, $PORT05, $PORT05_NAME, $PORT06, $PORT06_NAME;
		print "Time   KB/s_I  KB/s_O     KB/s_I  KB/s_O     KB/s_I  KB/s_O     KB/s_I  KB/s_O     KB/s_I  KB/s_O     KB/s_I  KB/s_O\n";
		print "--------------------------------------------------------------------------------------------------------------------\n";
		my $line;
		my @row;
		my $time;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			my ($ki1, $ko1, $ki2, $ko2, $ki3, $ko3, $ki4, $ko4, $ki5, $ko5, $ki6, $ko6) = @$line;
			$ki1 /= 1024;
			$ko1 /= 1024;
			$ki2 /= 1024;
			$ko2 /= 1024;
			$ki3 /= 1024;
			$ko3 /= 1024;
			$ki4 /= 1024;
			$ko4 /= 1024;
			$ki5 /= 1024;
			$ko5 /= 1024;
			$ki6 /= 1024;
			$ko6 /= 1024;
			@row = ($ki1, $ko1, $ki2, $ko2, $ki3, $ko3, $ki4, $ko4, $ki5, $ko5, $ki6, $ko6);
			$time = $time - (1 / $ts);
			printf " %2d$tc   %6d  %6d     %6d  %6d     %6d  %6d     %6d  %6d     %6d  %6d     %6d  %6d\n", $time, @row;
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 3);
	}
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT01 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT01 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT01) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT01_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT01_LIMIT";
	} else {
		if($PORT01_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT01_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT01_PNG",
		"--title=01 - $PORT01_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port01_b_in=$PORT_RRD:port01_bytes_in:AVERAGE",
		"DEF:port01_b_out=$PORT_RRD:port01_bytes_out:AVERAGE",
		"AREA:port01_b_out#4444EE:Output",
		"AREA:port01_b_in#44EE44:Input",
			"LINE1:port01_b_out#0000EE",
			"LINE1:port01_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT01_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT01Z_PNG",
			"--title=01 - $PORT01_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port01_b_in=$PORT_RRD:port01_bytes_in:AVERAGE",
			"DEF:port01_b_out=$PORT_RRD:port01_bytes_out:AVERAGE",
			"AREA:port01_b_out#4444EE:Output",
			"AREA:port01_b_in#44EE44:Input",
				"LINE1:port01_b_out#0000EE",
				"LINE1:port01_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT01Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port01/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT01Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT01_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT01_PNG>\n";
		}
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT02 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT02 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT02) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT02_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT02_LIMIT";
	} else {
		if($PORT02_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT02_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT02_PNG",
		"--title=02 - $PORT02_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port02_b_in=$PORT_RRD:port02_bytes_in:AVERAGE",
		"DEF:port02_b_out=$PORT_RRD:port02_bytes_out:AVERAGE",
		"AREA:port02_b_out#4444EE:Output",
		"AREA:port02_b_in#44EE44:Input",
			"LINE1:port02_b_out#0000EE",
			"LINE1:port02_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT02_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT02Z_PNG",
			"--title=02 - $PORT02_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port02_b_in=$PORT_RRD:port02_bytes_in:AVERAGE",
			"DEF:port02_b_out=$PORT_RRD:port02_bytes_out:AVERAGE",
			"AREA:port02_b_out#4444EE:Output",
			"AREA:port02_b_in#44EE44:Input",
				"LINE1:port02_b_out#0000EE",
				"LINE1:port02_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT02Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port02/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT02Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT02_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT02_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT03 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT03 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT03) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT03_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT03_LIMIT";
	} else {
		if($PORT03_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT03_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT03_PNG",
		"--title=03 - $PORT03_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port03_b_in=$PORT_RRD:port03_bytes_in:AVERAGE",
		"DEF:port03_b_out=$PORT_RRD:port03_bytes_out:AVERAGE",
		"AREA:port03_b_out#4444EE:Output",
		"AREA:port03_b_in#44EE44:Input",
			"LINE1:port03_b_out#0000EE",
			"LINE1:port03_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT03_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT03Z_PNG",
			"--title=03 - $PORT03_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port03_b_in=$PORT_RRD:port03_bytes_in:AVERAGE",
			"DEF:port03_b_out=$PORT_RRD:port03_bytes_out:AVERAGE",
			"AREA:port03_b_out#4444EE:Output",
			"AREA:port03_b_in#44EE44:Input",
				"LINE1:port03_b_out#0000EE",
				"LINE1:port03_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT03Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port03/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT03Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT03_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT03_PNG>\n";
		}
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT04 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT04 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT04) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT04_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT04_LIMIT";
	} else {
		if($PORT04_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT04_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT04_PNG",
		"--title=04 - $PORT04_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port04_b_in=$PORT_RRD:port04_bytes_in:AVERAGE",
		"DEF:port04_b_out=$PORT_RRD:port04_bytes_out:AVERAGE",
		"AREA:port04_b_out#4444EE:Output",
		"AREA:port04_b_in#44EE44:Input",
			"LINE1:port04_b_out#0000EE",
			"LINE1:port04_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT04_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT04Z_PNG",
			"--title=04 - $PORT04_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port04_b_in=$PORT_RRD:port04_bytes_in:AVERAGE",
			"DEF:port04_b_out=$PORT_RRD:port04_bytes_out:AVERAGE",
			"AREA:port04_b_out#4444EE:Output",
			"AREA:port04_b_in#44EE44:Input",
				"LINE1:port04_b_out#0000EE",
				"LINE1:port04_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT04Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port04/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT04Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT04_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT04_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT05 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT05 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT05) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT05_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT05_LIMIT";
	} else {
		if($PORT05_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT05_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT05_PNG",
		"--title=05 - $PORT05_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port05_b_in=$PORT_RRD:port05_bytes_in:AVERAGE",
		"DEF:port05_b_out=$PORT_RRD:port05_bytes_out:AVERAGE",
		"AREA:port05_b_out#4444EE:Output",
		"AREA:port05_b_in#44EE44:Input",
			"LINE1:port05_b_out#0000EE",
			"LINE1:port05_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT05_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT05Z_PNG",
			"--title=05 - $PORT05_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port05_b_in=$PORT_RRD:port05_bytes_in:AVERAGE",
			"DEF:port05_b_out=$PORT_RRD:port05_bytes_out:AVERAGE",
			"AREA:port05_b_out#4444EE:Output",
			"AREA:port05_b_in#44EE44:Input",
				"LINE1:port05_b_out#0000EE",
				"LINE1:port05_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT05Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port05/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT05Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT05_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT05_PNG>\n";
		}
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT06 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT06 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT06) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT06_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT06_LIMIT";
	} else {
		if($PORT06_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT06_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT06_PNG",
		"--title=06 - $PORT06_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port06_b_in=$PORT_RRD:port06_bytes_in:AVERAGE",
		"DEF:port06_b_out=$PORT_RRD:port06_bytes_out:AVERAGE",
		"AREA:port06_b_out#4444EE:Output",
		"AREA:port06_b_in#44EE44:Input",
			"LINE1:port06_b_out#0000EE",
			"LINE1:port06_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT06_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT06Z_PNG",
			"--title=06 - $PORT06_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port06_b_in=$PORT_RRD:port06_bytes_in:AVERAGE",
			"DEF:port06_b_out=$PORT_RRD:port06_bytes_out:AVERAGE",
			"AREA:port06_b_out#4444EE:Output",
			"AREA:port06_b_in#44EE44:Input",
				"LINE1:port06_b_out#0000EE",
				"LINE1:port06_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT06Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port06/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT06Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT06_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT06_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub port2_stats {
	my @tmp;
	my @warning;
	my $err;
	my $n;

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$PORT_RRD", "--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $PORT_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		printf "       Port %4s %-7s  Port %4s %-7s  Port %4s %-7s  Port %4s %-7s  Port %4s %-7s  Port %4s %-7s\n", $PORT07, $PORT07_NAME, $PORT08, $PORT08_NAME, $PORT09, $PORT09_NAME, $PORT10, $PORT10_NAME, $PORT11, $PORT11_NAME, $PORT12, $PORT12_NAME;
		print "Time   KB/s_I  KB/s_O     KB/s_I  KB/s_O     KB/s_I  KB/s_O     KB/s_I  KB/s_O     KB/s_I  KB/s_O     KB/s_I  KB/s_O\n";
		print "--------------------------------------------------------------------------------------------------------------------\n";
		my $line;
		my @row;
		my $time;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			my (undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, undef, $ki1, $ko1, $ki2, $ko2, $ki3, $ko3, $ki4, $ko4, $ki5, $ko5, $ki6, $ko6) = @$line;
			$ki1 /= 1024;
			$ko1 /= 1024;
			$ki2 /= 1024;
			$ko2 /= 1024;
			$ki3 /= 1024;
			$ko3 /= 1024;
			$ki4 /= 1024;
			$ko4 /= 1024;
			$ki5 /= 1024;
			$ko5 /= 1024;
			$ki6 /= 1024;
			$ko6 /= 1024;
			@row = ($ki1, $ko1, $ki2, $ko2, $ki3, $ko3, $ki4, $ko4, $ki5, $ko5, $ki6, $ko6);
			$time = $time - (1 / $ts);
			printf " %2d$tc   %6d  %6d     %6d  %6d     %6d  %6d     %6d  %6d     %6d  %6d     %6d  %6d\n", $time, @row;
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 3);
	}

	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT07 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT07 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT07) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	unlink ("$BASE_WWW{$OSTYPE}$PORT07_PNG",
		"$BASE_WWW{$OSTYPE}$PORT08_PNG",
		"$BASE_WWW{$OSTYPE}$PORT09_PNG",
		"$BASE_WWW{$OSTYPE}$PORT10_PNG",
		"$BASE_WWW{$OSTYPE}$PORT11_PNG",
		"$BASE_WWW{$OSTYPE}$PORT12_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$PORT07Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT08Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT09Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT10Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT11Z_PNG",
			"$BASE_WWW{$OSTYPE}$PORT12Z_PNG");
	}
	if($PORT07_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT07_LIMIT";
	} else {
		if($PORT07_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT07_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT07_PNG",
		"--title=07 - $PORT07_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port07_b_in=$PORT_RRD:port07_bytes_in:AVERAGE",
		"DEF:port07_b_out=$PORT_RRD:port07_bytes_out:AVERAGE",
		"AREA:port07_b_out#4444EE:Output",
		"AREA:port07_b_in#44EE44:Input",
			"LINE1:port07_b_out#0000EE",
			"LINE1:port07_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT07_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT07Z_PNG",
			"--title=07 - $PORT07_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port07_b_in=$PORT_RRD:port07_bytes_in:AVERAGE",
			"DEF:port07_b_out=$PORT_RRD:port07_bytes_out:AVERAGE",
			"AREA:port07_b_out#4444EE:Output",
			"AREA:port07_b_in#44EE44:Input",
				"LINE1:port07_b_out#0000EE",
				"LINE1:port07_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT07Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port07/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT07Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT07_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT07_PNG>\n";
		}
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT08 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT08 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT08) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT08_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT08_LIMIT";
	} else {
		if($PORT08_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT08_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT08_PNG",
		"--title=08 - $PORT08_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port08_b_in=$PORT_RRD:port08_bytes_in:AVERAGE",
		"DEF:port08_b_out=$PORT_RRD:port08_bytes_out:AVERAGE",
		"AREA:port08_b_out#4444EE:Output",
		"AREA:port08_b_in#44EE44:Input",
			"LINE1:port08_b_out#0000EE",
			"LINE1:port08_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT08_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT08Z_PNG",
			"--title=08 - $PORT08_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port08_b_in=$PORT_RRD:port08_bytes_in:AVERAGE",
			"DEF:port08_b_out=$PORT_RRD:port08_bytes_out:AVERAGE",
			"AREA:port08_b_out#4444EE:Output",
			"AREA:port08_b_in#44EE44:Input",
				"LINE1:port08_b_out#0000EE",
				"LINE1:port08_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT08Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port08/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT08Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT08_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT08_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT09 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT09 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT09) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT09_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT09_LIMIT";
	} else {
		if($PORT09_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT09_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT09_PNG",
		"--title=09 - $PORT09_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port09_b_in=$PORT_RRD:port09_bytes_in:AVERAGE",
		"DEF:port09_b_out=$PORT_RRD:port09_bytes_out:AVERAGE",
		"AREA:port09_b_out#4444EE:Output",
		"AREA:port09_b_in#44EE44:Input",
			"LINE1:port09_b_out#0000EE",
			"LINE1:port09_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT09_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT09Z_PNG",
			"--title=09 - $PORT09_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port09_b_in=$PORT_RRD:port09_bytes_in:AVERAGE",
			"DEF:port09_b_out=$PORT_RRD:port09_bytes_out:AVERAGE",
			"AREA:port09_b_out#4444EE:Output",
			"AREA:port09_b_in#44EE44:Input",
				"LINE1:port09_b_out#0000EE",
				"LINE1:port09_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT09Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port09/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT09Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT09_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT09_PNG>\n";
		}
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT10 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT10 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT10) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT10_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT10_LIMIT";
	} else {
		if($PORT10_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT10_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT10_PNG",
		"--title=10 - $PORT10_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port10_b_in=$PORT_RRD:port10_bytes_in:AVERAGE",
		"DEF:port10_b_out=$PORT_RRD:port10_bytes_out:AVERAGE",
		"AREA:port10_b_out#4444EE:Output",
		"AREA:port10_b_in#44EE44:Input",
			"LINE1:port10_b_out#0000EE",
			"LINE1:port10_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT10_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT10Z_PNG",
			"--title=10 - $PORT10_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port10_b_in=$PORT_RRD:port10_bytes_in:AVERAGE",
			"DEF:port10_b_out=$PORT_RRD:port10_bytes_out:AVERAGE",
			"AREA:port10_b_out#4444EE:Output",
			"AREA:port10_b_in#44EE44:Input",
				"LINE1:port10_b_out#0000EE",
				"LINE1:port10_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT10Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port10/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT10Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT10_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT10_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT11 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT11 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT11) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT11_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT11_LIMIT";
	} else {
		if($PORT11_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT11_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT11_PNG",
		"--title=11 - $PORT11_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port11_b_in=$PORT_RRD:port11_bytes_in:AVERAGE",
		"DEF:port11_b_out=$PORT_RRD:port11_bytes_out:AVERAGE",
		"AREA:port11_b_out#4444EE:Output",
		"AREA:port11_b_in#44EE44:Input",
			"LINE1:port11_b_out#0000EE",
			"LINE1:port11_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT11_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT11Z_PNG",
			"--title=11 - $PORT11_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port11_b_in=$PORT_RRD:port11_bytes_in:AVERAGE",
			"DEF:port11_b_out=$PORT_RRD:port11_bytes_out:AVERAGE",
			"AREA:port11_b_out#4444EE:Output",
			"AREA:port11_b_in#44EE44:Input",
				"LINE1:port11_b_out#0000EE",
				"LINE1:port11_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT11Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port11/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT11Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT11_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT11_PNG>\n";
		}
	}
	undef(@tmp);
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$PORT12 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$PORT12 " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $PORT12) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($PORT12_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT12_LIMIT";
	} else {
		if($PORT12_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT12_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$PORT12_PNG",
		"--title=12 - $PORT12_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@warning,
		"DEF:port12_b_in=$PORT_RRD:port12_bytes_in:AVERAGE",
		"DEF:port12_b_out=$PORT_RRD:port12_bytes_out:AVERAGE",
		"AREA:port12_b_out#4444EE:Output",
		"AREA:port12_b_in#44EE44:Input",
			"LINE1:port12_b_out#0000EE",
			"LINE1:port12_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT12_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PORT12Z_PNG",
			"--title=12 - $PORT12_NAME traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@warning,
			"DEF:port12_b_in=$PORT_RRD:port12_bytes_in:AVERAGE",
			"DEF:port12_b_out=$PORT_RRD:port12_bytes_out:AVERAGE",
			"AREA:port12_b_out#4444EE:Output",
			"AREA:port12_b_in#44EE44:Input",
				"LINE1:port12_b_out#0000EE",
				"LINE1:port12_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PORT12Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /port12/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PORT12Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PORT12_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$PORT12_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub user_stats {
	my @tmp;
	my $err;
	my $n;

	unlink ("$BASE_WWW{$OSTYPE}$USER1_PNG",
		"$BASE_WWW{$OSTYPE}$USER2_PNG",
		"$BASE_WWW{$OSTYPE}$USER3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$USER1Z_PNG",
			"$BASE_WWW{$OSTYPE}$USER2Z_PNG",
			"$BASE_WWW{$OSTYPE}$USER3Z_PNG");
	}

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$USER_RRD", "--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $USER_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		print "Time   Telnet/SSH     Samba  NetaTalk \n";
		print "------------------------------------- \n";
		my $line;
		my @row;
		my $time;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			my ($usr, $smb, $mac) = @$line;
			@row = ($usr, $smb, $mac);
			$time = $time - (1 / $ts);
			printf " %2d$tc       %6d    %6d    %6d \n", $time, @row;
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 2);
	}
	if($USER1_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$USER1_LIMIT";
	} else {
		if($USER1_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$USER1_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$USER1_PNG",
		"--title=Users on system  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Number of users",
		"--width=$width",
		"--height=$height",
		"--lower-limit=0",
		@VERSION12,
		@tmp,
		@graph_colors,
		"DEF:usr=$USER_RRD:user_usr:AVERAGE",
		"DEF:smb=$USER_RRD:user_smb:AVERAGE",
		"DEF:mac=$USER_RRD:user_mac:AVERAGE",
		"AREA:usr#44EE44:Telnet/SSH",
			"LINE1:usr#00EE00",
		"COMMENT: \\n",
		"COMMENT: \\n",
		"GPRINT:usr:LAST:Telnet/SSH     Current\\: %3.0lf",
		"GPRINT:usr:AVERAGE:    Average\\: %3.0lf",
		"GPRINT:usr:MIN:    Min\\: %3.0lf",
		"GPRINT:usr:MAX:    Max\\: %3.0lf\\n",
		"GPRINT:smb:LAST:Samba          Current\\: %3.0lf",
		"GPRINT:smb:AVERAGE:    Average\\: %3.0lf",
		"GPRINT:smb:MIN:    Min\\: %3.0lf",
		"GPRINT:smb:MAX:    Max\\: %3.0lf\\n",
		"GPRINT:mac:LAST:NetaTalk       Current\\: %3.0lf",
		"GPRINT:mac:AVERAGE:    Average\\: %3.0lf",
		"GPRINT:mac:MIN:    Min\\: %3.0lf",
		"GPRINT:mac:MAX:    Max\\: %3.0lf\\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$USER1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$USER1Z_PNG",
			"--title=Users on system  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Number of users",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@tmp,
			@graph_colors,
			"DEF:usr=$USER_RRD:user_usr:AVERAGE",
			"DEF:smb=$USER_RRD:user_smb:AVERAGE",
			"DEF:mac=$USER_RRD:user_mac:AVERAGE",
			"AREA:usr#44EE44:Telnet/SSH",
				"LINE1:usr#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$USER1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /user1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $USER1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$USER1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$USER1_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	if($USER2_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$USER2_LIMIT";
	} else {
		if($USER2_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$USER2_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$USER2_PNG",
		"--title=Users using Samba  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Number of users",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		"DEF:smb=$USER_RRD:user_smb:AVERAGE",
		"AREA:smb#EEEE44:Samba",
			"LINE1:smb#EEEE00");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$USER2_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$USER2Z_PNG",
			"--title=Users using Samba  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Number of users",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			"DEF:smb=$USER_RRD:user_smb:AVERAGE",
			"AREA:smb#EEEE44:Samba",
				"LINE1:smb#EEEE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$USER2Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /user2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $USER2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$USER2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$USER2_PNG>\n";
		}
	}
	undef(@tmp);
	if($USER3_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$USER3_LIMIT";
	} else {
		if($USER3_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$USER3_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$USER3_PNG",
		"--title=Users using NetaTalk  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Number of users",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		"DEF:mac=$USER_RRD:user_mac:AVERAGE",
		"AREA:mac#EE4444:NetaTalk",
			"LINE1:mac#EE0000");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$USER3_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$USER3Z_PNG",
			"--title=Users using NetaTalk  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Number of users",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			"DEF:mac=$USER_RRD:user_mac:AVERAGE",
			"AREA:mac#EE4444:NetaTalk",
				"LINE1:mac#EE0000");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$USER3Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /user3/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $USER3Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$USER3_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$USER3_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub nginx_stats {
	my @tmp;
	my @tmp2;
	my $err;
	my $n;

	unlink ("$BASE_WWW{$OSTYPE}$NGINX1_PNG",
		"$BASE_WWW{$OSTYPE}$NGINX2_PNG",
		"$BASE_WWW{$OSTYPE}$NGINX3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$NGINX1Z_PNG",
			"$BASE_WWW{$OSTYPE}$NGINX2Z_PNG",
			"$BASE_WWW{$OSTYPE}$NGINX3Z_PNG");
	}

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$NGINX_RRD", "--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $NGINX_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		print "       Connections                                  Port $NGINX_PORT\n";
		print "Time   Total  Reading  Writing  Waiting  Requests  KB/s_I  KB/s_O \n";
		print "------------------------------------------------------------------ \n";
		my $line;
		my @row;
		my $time;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			my ($req, $tot, $rea, $wri, $wai, $ki, $ko) = @$line;
			$ki /= 1024;
			$ko /= 1024;
			@row = ($tot, $rea, $wri, $wai, $req, $ki, $ko);
			$time = $time - (1 / $ts);
			printf " %2d$tc  %6d   %6d   %6d   %6d   %6d   %6d   %6d \n", $time, @row;
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 2);
		$tmp[0] = "COMMENT: \\n",
		$tmp[1] = "COMMENT: \\n",
		$tmp[2] = "GPRINT:total:LAST:Total           Current\\: %5.0lf",
		$tmp[3] = "GPRINT:total:AVERAGE:    Averag0\\: %5.0lf",
		$tmp[4] = "GPRINT:total:MIN:    Min\\: %5.0lf",
		$tmp[5] = "GPRINT:total:MAX:    Max\\: %5.0lf\\n",
		$tmp[6] = "GPRINT:reading:LAST:Reading         Current\\: %5.0lf",
		$tmp[7] = "GPRINT:reading:AVERAGE:    Average\\: %5.0lf",
		$tmp[8] = "GPRINT:reading:MIN:    Min\\: %5.0lf",
		$tmp[9] = "GPRINT:reading:MAX:    Max\\: %5.0lf\\n",
		$tmp[10] = "GPRINT:writing:LAST:Writing         Current\\: %5.0lf",
		$tmp[11] = "GPRINT:writing:AVERAGE:    Average\\: %5.0lf",
		$tmp[12] = "GPRINT:writing:MIN:    Min\\: %5.0lf",
		$tmp[13] = "GPRINT:writing:MAX:    Max\\: %5.0lf\\n",
		$tmp[14] = "GPRINT:waiting:LAST:Waiting         Current\\: %5.0lf",
		$tmp[15] = "GPRINT:waiting:AVERAGE:    Average\\: %5.0lf",
		$tmp[16] = "GPRINT:waiting:MIN:    Min\\: %5.0lf",
		$tmp[17] = "GPRINT:waiting:MAX:    Max\\: %5.0lf\\n",
		$tmp[18] = "COMMENT: \\n",
	}
	if($NGINX1_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$NGINX1_LIMIT";
	} else {
		if($NGINX1_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$NGINX1_LIMIT";
			$tmp2[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$NGINX1_PNG",
		"--title=Connections (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Connections/sec",
		"--width=$width",
		"--height=$height",
		"--lower-limit=0",
		@VERSION12,
		@tmp2,
		@graph_colors,
		"DEF:total=$NGINX_RRD:total:AVERAGE",
		"DEF:reading=$NGINX_RRD:reading:AVERAGE",
		"DEF:writing=$NGINX_RRD:writing:AVERAGE",
		"DEF:waiting=$NGINX_RRD:waiting:AVERAGE",
		"AREA:total#44EEEE:Total",
		"AREA:reading#44EE44:Reading",
		"AREA:writing#4444EE:Writing",
		"AREA:waiting#EE44EE:Waiting",
			"LINE1:total#00EEEE",
			"LINE1:reading#00EE00",
			"LINE1:writing#0000EE",
			"LINE1:waiting#EE00EE",
		@tmp);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NGINX1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$NGINX1Z_PNG",
			"--title=Connections (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Connections/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@tmp2,
			@graph_colors,
			"DEF:total=$NGINX_RRD:total:AVERAGE",
			"DEF:reading=$NGINX_RRD:reading:AVERAGE",
			"DEF:writing=$NGINX_RRD:writing:AVERAGE",
			"DEF:waiting=$NGINX_RRD:waiting:AVERAGE",
			"AREA:total#44EEEE:Total",
			"AREA:reading#44EE44:Reading",
			"AREA:writing#4444EE:Writing",
			"AREA:waiting#EE44EE:Waiting",
				"LINE1:total#00EEEE",
				"LINE1:reading#00EE00",
				"LINE1:writing#0000EE",
				"LINE1:waiting#EE00EE");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NGINX1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /nginx1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $NGINX1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$NGINX1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$NGINX1_PNG>\n";
		}
	}
	if($_[0]) {
		print"  </td>\n";
		print "  <td bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp2);
	if($NGINX2_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$NGINX2_LIMIT";
	} else {
		if($NGINX2_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$NGINX2_LIMIT";
			$tmp2[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$NGINX2_PNG",
		"--title=Requests (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Requests/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp2,
		@graph_colors,
		"DEF:requests=$NGINX_RRD:requests:AVERAGE",
		"AREA:requests#44EEEE:Requests",
			"LINE1:requests#00EEEE",
		"COMMENT: \\n",
		"COMMENT: \\n",
		"GPRINT:requests:LAST:Requests    Current\\: %5.0lf");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NGINX2_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$NGINX2Z_PNG",
			"--title=Requests (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Requests/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp2,
			@graph_colors,
			"DEF:requests=$NGINX_RRD:requests:AVERAGE",
			"AREA:requests#44EEEE:Requests",
				"LINE1:requests#00EEEE");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NGINX2Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /nginx2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $NGINX2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$NGINX2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$NGINX2_PNG>\n";
		}
	}
	undef(@tmp2);
	my @warning;
	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		$warning[0] = `netstat -ntl | grep ":$NGINX_PORT" | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*://'`;
	} elsif ($OSTYPE eq "FreeBSD") {
		$warning[0] = `netstat -anl -p tcp | grep LISTEN | grep "\.$NGINX_PORT " | awk -F " " '{ print \$4 }' | head -1 | sed 's/.*\\.//'`;
	}
	chomp($warning[0]);
	if ($warning[0] ne $NGINX_PORT) {
		$warning[0] = $warning_color;
	} else {
		undef(@warning);
	}
	if($NGINX3_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$NGINX3_LIMIT";
	} else {
		if($NGINX3_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$NGINX3_LIMIT";
			$tmp2[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$NGINX3_PNG",
		"--title=Port $NGINX_PORT traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp2,
		@graph_colors,
		@warning,
		"DEF:nginx_b_in=$NGINX_RRD:nginx_bytes_in:AVERAGE",
		"DEF:nginx_b_out=$NGINX_RRD:nginx_bytes_out:AVERAGE",
		"AREA:nginx_b_out#4444EE:Output",
		"AREA:nginx_b_in#44EE44:Input",
			"LINE1:nginx_b_out#0000EE",
			"LINE1:nginx_b_in#00EE00",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NGINX3_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$NGINX3Z_PNG",
			"--title=Port $NGINX_PORT traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp2,
			@graph_colors,
			@warning,
			"DEF:nginx_b_in=$NGINX_RRD:nginx_bytes_in:AVERAGE",
			"DEF:nginx_b_out=$NGINX_RRD:nginx_bytes_out:AVERAGE",
			"AREA:nginx_b_out#4444EE:Output",
			"AREA:nginx_b_in#44EE44:Input",
				"LINE1:nginx_b_out#0000EE",
				"LINE1:nginx_b_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$NGINX3Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /nginx3/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $NGINX3Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$NGINX3_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$NGINX3_PNG>\n";
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub int_stats {
	my @tmp;
	my @INT;
	my @NAME;
	my @DEF1;
	my @AREA1;
	my @LINE1;
	my @DEF2;
	my @AREA2;
	my @LINE2;
	my @DEF3;
	my @AREA3;
	my @LINE3;
	my $n;
	my $n1;
	my $n2;
	my $n3;
	my @ACOLOR1 =  ("#FFA500",
			"#44EEEE",
			"#CCCCCC",
			"#B4B444",
			"#4444EE",
			"#44EE44",
			"#EEEE44",
			"#444444",
			"#EE44EE",
			"#EE4444",
			"#448844",
			"#BB44EE",
			"#D3D701",
			"#E29136",
			"#DDAE8C",
			"#F29967",
			"#996952",
			"#EB6C75",
			"#B84F6B",
			"#963C74",
			"#A68BBC",
			"#597AB7",
			"#8CB4CE",
			"#63BEE0",
			"#3CB5B0",
			"#7EB97C",
			"#94C36B",
			"#884632");
	my @LCOLOR1 =  ("#DDA500",
			"#00EEEE",
			"#888888",
			"#B4B400",
			"#0000EE",
			"#00EE00",
			"#EEEE00",
			"#444444",
			"#EE00EE",
			"#EE0000",
			"#008800",
			"#BB00EE",
			"#C8D200",
			"#DB6612",
			"#CE8248",
			"#EB6A39",
			"#8F4C30",
			"#E20045",
			"#B50C51",
			"#7B0059",
			"#684894",
			"#125AA3",
			"#518FBA",
			"#00AADA",
			"#009790",
			"#359B52",
			"#56AB27",
			"#782F1E");

	my @ACOLOR2 =  ("#44EEEE",
			"#44EE44",
			"#EE4444");
	my @LCOLOR2 =  ("#00EEEE",
			"#00EE00",
			"#EE0000");

	my @ACOLOR3 =  ("#44EE44",
			"#4444EE",
			"#EE44EE");
	my @LCOLOR3 =  ("#00EE00",
			"#0000EE",
			"#EE00EE");
	my $err;

	if(($OSTYPE eq "Linux-RHFC") ||
	  ($OSTYPE eq "Linux-Arch") ||
	  ($OSTYPE eq "Linux-Debian") ||
	  ($OSTYPE eq "Linux-Gentoo") ||
	  ($OSTYPE eq "Linux-Slack") ||
	  ($OSTYPE eq "Linux-SuSE") ||
	  ($OSTYPE eq "Linux-Generic")) {
		open(INTERRUPTS, "/proc/interrupts");
		my $timer_pos = 0;
		my $i8042_pos = 0;
		my $good_pos = 0;
		my $num;
		my $name;
		while(<INTERRUPTS>) {
			if(/[0-9]:/) {
				# Assuming int 0 will be only for timer
				if(/\s+0:/) {
					$timer_pos = index($_, "timer", 0);
				}
				# Assuming int 1 will be only for i8042
				if(/\s+1:/) {
					$i8042_pos = index($_, "i8042", 0);
				}
				$timer_pos = $timer_pos == 0 ? 999 : $timer_pos;
				$i8042_pos = $i8042_pos == -1 ? 0 : $i8042_pos;
				$good_pos = $timer_pos > $i8042_pos ? $i8042_pos : $timer_pos;
				$good_pos = $good_pos ? $good_pos : $timer_pos;
				$num = unpack("A4", $_);
				undef($name);
				if(length($_) >= $good_pos) {
					$name = substr($_, $good_pos);
					$name = defined($name) ? $name : "";
				}
				chomp($num, $name);
				$name =~ s/^\s+//;
				$num =~ s/^\s+//;
				$num =~ s/:.*//;
				$n = $num;
				$num = $num > 255 ? $num % 256 : $num;
				$INT[$num] = defined($INT[$num]) ? $INT[$num] . "," : "";
				$NAME[$num] = defined($NAME[$num]) ? $NAME[$num] . ", " : "";
				$INT[$num] .= $n;
				$NAME[$num] .= $name;
			}
		}
		close(INTERRUPTS);
	} elsif ($OSTYPE eq "FreeBSD") {
		open(INTERRUPTS, "vmstat -i | sort |");
		my @allfields;
		my $num;
		my $name;
		while(<INTERRUPTS>) {
			if(/^\D{3}\d+/) {
				@allfields = split(' ', $_);
				$num = $allfields[0];
				$name = "";
				for($n = 1; $n <= $#allfields - 2; $n++) {
					$name .= $allfields[$n] . " ";
				}
				$num =~ s/^\D{3}//;
				$num =~ s/://;
				$name =~ s/\s+$//;

				# only the first timer (cpu0) is covered
				if($name eq "timer") {
					if($num != 0) {
						next;
					}
				}

				$n = $num;
				$num = $num > 255 ? $num % 256 : $num;
				$INT[$num] = defined($INT[$num]) ? $INT[$num] . "," : "";
				$NAME[$num] = defined($NAME[$num]) ? $NAME[$num] . ", " : "";
				$INT[$num] .= $n;
				$NAME[$num] .= $name;
			}
		}
		close(INTERRUPTS);

		chomp(@NAME);
# We need to strip possible blank spaces from the end of the strings
		for($n = 0; $n < 256; $n++) {
			if(defined($NAME[$n])) {
				$NAME[$n] =~ s/\s+$//;
			}
		}
	}

	if($IFACE_MODE eq "text") {
		if($_[0]) {
			image_header($_[0], 2);
		}
		my (undef, undef, undef, $data) = RRDs::fetch("$INT_RRD", "--start=-1$when",
			"AVERAGE",
			"-r $res");
		$err = RRDs::error;
		die "ERROR: while fetching $INT_RRD: $err\n" if $err;
		print "<pre style='font-size: 12px; color: $fore_color';>";
		print "Time   ";
		for($n = 0; $n < 256; $n++) {
			if(defined($INT[$n])) {
				printf " %8s", $INT[$n];
			}
		}
		print " \n";
		print "-------";
		for($n = 0; $n < 256; $n++) {
			if(defined($INT[$n])) {
				printf "---------";
			}
		}
		print " \n";
		my $line;
		my @row;
		my $time;
		my $i;
		for($n = 0, $time = $tb; $n < ($tb * $ts); $n++) {
			$line = @$data[$n];
			@row = @$line;
			$time = $time - (1 / $ts);
			printf " %2d$tc   ", $time;
			for($n2 = 0; $n2 < 256; $n2++) {
				if(defined($INT[$n2])) {
					printf " %8d", $row[$n2];
				}
			}
			print " \n";
		}
		print "</pre>";
		print "\n";
		if($_[0]) {
			image_footer();
		}
		return;
	}

	if($_[0]) {
		image_header($_[0], 2);
	}
	my $i;
	for($n = 0, $n1 = 0, $n2 = 0, $n3 = 0; $n < 256; $n++) {
		if(defined($NAME[$n])) {
# We need to escape colons to support RRDtool v1.2+
			if($RRDs::VERSION > 1.2) {
				$NAME[$n] =~ s/:/\\:/g;
			}
		}
		if(defined($INT[$n])) {
			if(index($INT[$n], ",", 0) < 0) {
				$i = $INT[$n];
			} else {
				($i) = split(',', $INT[$n]);
			}
			if($i < 3) {
				push(@DEF2, ("DEF:int" . $n . "=" . $INT_RRD . ":int_" . $n . ":AVERAGE"));
				push(@AREA2, ("AREA:int" . $n . $ACOLOR2[$n2] . ":(" . $INT[$n] . ")" . $NAME[$n]));
				push(@LINE2, ("LINE1:int" . $n . $LCOLOR2[$n2]));
				$n2++;
			} elsif($i < 6) {
				push(@DEF3, ("DEF:int" . $n . "=" . $INT_RRD . ":int_" . $n . ":AVERAGE"));
				push(@AREA3, ("AREA:int" . $n . $ACOLOR3[$n3] . ":(" . $INT[$n] . ")" . $NAME[$n]));
				push(@LINE3, ("LINE1:int" . $n . $LCOLOR3[$n3]));
				$n3++;
			} else {
				push(@DEF1, ("DEF:int" . $n . "=" . $INT_RRD . ":int_" . $n . ":AVERAGE"));
				push(@AREA1, ("AREA:int" . $n . $ACOLOR1[$n1] . ":(" . $INT[$n] . ")" . $NAME[$n]));
				push(@LINE1, ("LINE1:int" . $n . $LCOLOR1[$n1]));
				$n1++;
				if(!($n1 % 3)) {
					push(@AREA1, ("COMMENT: \\n"));
				}
			}
		}
	}
	push(@AREA1, ("COMMENT: \\n"));

	unlink ("$BASE_WWW{$OSTYPE}$INT1_PNG",
		"$BASE_WWW{$OSTYPE}$INT2_PNG",
		"$BASE_WWW{$OSTYPE}$INT3_PNG");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$INT1Z_PNG",
			"$BASE_WWW{$OSTYPE}$INT2Z_PNG",
			"$BASE_WWW{$OSTYPE}$INT3Z_PNG");
	}
	if($INT1_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$INT1_LIMIT";
	} else {
		if($INT1_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$INT1_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$INT1_PNG",
		"--title=Interrupt activity  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Ticks/sec",
		"--width=$width",
		"--height=$height",
		"--lower-limit=0",
		@VERSION12,
		@tmp,
		@graph_colors,
		@DEF1,
		"COMMENT: \\n",
		@AREA1,
		@LINE1);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$INT1_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$INT1Z_PNG",
			"--title=Interrupt activity  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Ticks/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@tmp,
			@graph_colors,
			@DEF1,
			"COMMENT: \\n",
			@AREA1,
			@LINE1);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$INT1Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /int1/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $INT1Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 150) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$INT1_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$INT1_PNG>\n";
		}
	}
	if($_[0]) {
		print "  </td>\n";
		print "  <td valign='top' bgcolor=" . $title_back_color . ">\n";
	}
	undef(@tmp);
	if($INT2_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$INT2_LIMIT";
	} else {
		if($INT2_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$INT2_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW{$OSTYPE}$INT2_PNG",
		"--title=Core activity  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Ticks/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--lower-limit=0",
		@VERSION12,
		@VERSION12_23,
		@tmp,
		@graph_colors,
		@DEF2,
		@AREA2,
		@LINE2);
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$INT2_PNG: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$INT2Z_PNG",
			"--title=Core activity  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Ticks/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@DEF2,
			@AREA2,
			@LINE2);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$INT2Z_PNG: $err\n" if $err;
	}
	if($_[0] || ($silent =~ /imagetag/ && $graph =~ /int2/)) {
		if($ENABLE_ZOOM eq "Y") {
			print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $INT2Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 150) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$INT2_PNG border=0></a>\n";
		} else {
			print "  <img src=$BASE_URL$INT2_PNG>\n";
		}
	}
	undef(@tmp);
	if($INT3_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$INT3_LIMIT";
	} else {
		if($INT3_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$INT3_LIMIT";
			$tmp[1] = "--rigid";
		}
	}
	if(@DEF3 && @AREA3 && @LINE3) {
		RRDs::graph("$BASE_WWW{$OSTYPE}$INT3_PNG",
			"--title=Low-devices activity  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=Ticks/sec",
			"--width=$miniwidth",
			"--height=$miniheight",
			"--lower-limit=0",
			@VERSION12,
			@VERSION12_23,
			@tmp,
			@graph_colors,
			@DEF3,
			@AREA3,
			@LINE3);
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$INT3_PNG: $err\n" if $err;
		if($ENABLE_ZOOM eq "Y") {
			RRDs::graph("$BASE_WWW{$OSTYPE}$INT3Z_PNG",
				"--title=Low-devices activity  (1$when)",
				"--start=-1$when",
				"--imgformat=PNG",
				"--vertical-label=Ticks/sec",
				"--width=$zwidth",
				"--height=$zheight",
				"--lower-limit=0",
				@VERSION12,
				@VERSION12_23,
				@tmp,
				@graph_colors,
				@DEF3,
				@AREA3,
				@LINE3);
			$err = RRDs::error;
			die "ERROR: while graphing $BASE_WWW{$OSTYPE}$INT3Z_PNG: $err\n" if $err;
		}
		if($_[0] || ($silent =~ /imagetag/ && $graph =~ /int3/)) {
			if($ENABLE_ZOOM eq "Y") {
				print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $INT3Z_PNG . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 150) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$INT3_PNG border=0></a>\n";
			} else {
				print "  <img src=$BASE_URL$INT3_PNG>\n";
			}
		}
	}
	if($_[0]) {
		image_footer();
	}
}

sub multihost_stats {
	my $n;
	my $n2;
	my @SERV_NAME;
	my @SERV_URL;

	for($n = 0, $n2 = 0; $n < scalar(@SERV_LIST); $n += 2, $n2++) {
		$SERV_NAME[$n2] = $SERV_LIST[$n];
		$SERV_URL[$n2] = $SERV_LIST[$n + 1];
	}

	if($MULTIHOST_IMGPERLINE < 1) {
		$MULTIHOST_IMGPERLINE = 1;
	}
	$graph = $graph eq "all" ? "_cpu1" : $graph;

	if($val eq "all") {
		for($n = 0; $n < scalar(@SERV_NAME); $n += $MULTIHOST_IMGPERLINE) {
			print "<table cellspacing=5 cellpadding=0 width=1 bgcolor=" . $graph_back_color . " border=1>\n";
			print " <tr>\n";
			for($n2 = 0; $n2 < $MULTIHOST_IMGPERLINE; $n2++) {
				if($n < scalar(@SERV_NAME)) {
					print "  <td bgcolor=" . $title_back_color . ">\n";
					print "   <font face='Verdana, Tahoma, sans-serif' color=" . $fore_color . ">\n";
					print "   <b>&nbsp;&nbsp;" . $SERV_NAME[$n] . "<b>\n";
					print "   </font>\n";
					print "  </td>\n";
				}
				$n++;
			}
			print " </tr>\n";
			print " <tr>\n";
			for($n2 = 0, $n = $n - $MULTIHOST_IMGPERLINE; $n2 < $MULTIHOST_IMGPERLINE; $n2++) {
				if($n < scalar(@SERV_NAME)) {
					print "  <td bgcolor=" . $title_back_color . " style='vertical-align: top; height: 10%; width: 10%;'>\n";
					print "   <iframe src=$SERV_URL[$n]/cgi-bin/monitorix.cgi?mode=localhost&when=$when&graph=$graph&color=$color&silent=imagetag height=201 width=397 frameborder=0 marginwidth=0 marginheight=0 scrolling=no></iframe>\n";
					print "  </td>\n";

				}
				$n++;
			}
			print " </tr>\n";
			print " <tr>\n";
			for($n2 = 0, $n = $n - $MULTIHOST_IMGPERLINE; $n2 < $MULTIHOST_IMGPERLINE; $n2++) {
				if($n < scalar(@SERV_NAME)) {
				if($MULTIHOST_FOOTER) {
					print "  <td bgcolor=" . $title_back_color . ">\n";
					print "   <font face='Verdana, Tahoma, sans-serif' color=" . $title_fore_color . ">\n";
					print "   <font size=-1>\n";
					print "    <b>&nbsp;&nbsp;<a href='" . $SERV_URL[$n] . "/monitorix/' style='{color: $title_fore_color}'>$SERV_URL[$n]</a><b>\n";
					print "   </font></font>\n";
					print "  </td>\n";
				}
				}
				$n++;
			}
			$n = $n - $MULTIHOST_IMGPERLINE;
			print " </tr>\n";
			print "</table>\n";
			print "<br>\n";
		}
	} else {
		print "  <table cellspacing=5 cellpadding=0 width=1 bgcolor=" . $graph_back_color . " border=1>\n";
		print "   <tr>\n";
		print "    <td bgcolor=" . $title_back_color . ">\n";
		print "    <font face='Verdana, Tahoma, sans-serif' color=" . $fore_color . ">\n";
		print "    <b>&nbsp;&nbsp;" . $SERV_NAME[$val] . "<b>\n";
		print "    </font>\n";
		print "    </td>\n";
		print "   </tr>\n";
		print "   <tr>\n";
		print "    <td bgcolor=" . $title_back_color . " style='vertical-align: top; height: 10%; width: 10%;'>\n";
		print "     <iframe src=$SERV_URL[$val]/cgi-bin/monitorix.cgi?mode=localhost&when=$when&graph=$graph&color=$color&silent=imagetagbig height=249 width=545 frameborder=0 marginwidth=0 marginheight=0 scrolling=no></iframe>\n";
		print "    </td>\n";
		print "   </tr>\n";
		print "   <tr>\n";
		if($MULTIHOST_FOOTER) {
			print "   <td bgcolor=" . $title_back_color . ">\n";
			print "    <font face='Verdana, Tahoma, sans-serif' color=" . $title_fore_color . ">\n";
			print "    <font size=-1>\n";
			print "    <b>&nbsp;&nbsp;<a href='" . $SERV_URL[$val] . "/monitorix/' style='{color: $title_fore_color}'>$SERV_URL[$val]</a><b>\n";
			print "    </font></font>\n";
			print "   </td>\n";
		}
		print "   </tr>\n";
		print "  </table>\n";
		print "  <br>\n";
	}
}

sub panoramic_stats {
	my $n;
	my @tmp;
	my $err;

	if($NET_RIGID[$inetpos] eq 1) {
		$tmp[0] = "--upper-limit=$NET_LIMIT[$inetpos]";
	} else {
		if($NET_RIGID[$inetpos] eq 2) {
			$tmp[0] = "--upper-limit=$NET_LIMIT[$inetpos]";
			$tmp[1] = "--rigid";
		}
	}

	print "  <table cellspacing=5 cellpadding=0 width=1 bgcolor=" . $graph_back_color . " border=1>\n";
	print "  <tr>\n";
	print "  <td bgcolor=" . $title_back_color . " colspan=2>\n";
	print "  <font face='Verdana, Tahoma, sans-serif' color=" . $title_fore_color . ">\n";
	print "    <b>&nbsp;&nbsp;Internet traffic and usage<b>\n";
	print "  </font>\n";
	print "  </td>\n";
	print "  </tr>\n";
	for($n = 0; $n < scalar(@PC_LIST); $n++) {
	if(!($n % 2)) {
		print "  <tr>\n";
	}
	print "  <td bgcolor=" . $title_back_color . ">\n";
	unlink ("$BASE_WWW{$OSTYPE}$PANO_PNG[$n]");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$PANOZ_PNG[$n]");
	}
	my @DEF;
	$DEF[0] = "DEF:B_in=$PC_RRD:pc" . ($n+1) . "_bytes_in:AVERAGE";
	$DEF[1] = "DEF:B_out=$PC_RRD:pc" . ($n+1) . "_bytes_out:AVERAGE";
	RRDs::graph("$BASE_WWW{$OSTYPE}$PANO_PNG[$n]",
		"--title=$PC_LIST[$n] traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=300",
		"--height=100",
		"--lower-limit=0",
		@VERSION12,
		@tmp,
		@graph_colors,
		@DEF,
		"CDEF:K_in=B_in,1024,/",
		"CDEF:K_out=B_out,1024,/",
		"AREA:B_out#4444EE:Output",
		"AREA:B_in#44EE44:Input",
			"LINE1:B_out#0000EE",
			"LINE1:B_in#00EE00");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PANO_PNG[$n]: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PANOZ_PNG[$n]",
			"--title=$PC_LIST[$n] traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@tmp,
			@graph_colors,
			@DEF,
			"CDEF:K_in=B_in,1024,/",
			"CDEF:K_out=B_out,1024,/",
			"AREA:B_out#4444EE:Output",
			"AREA:B_in#44EE44:Input",
				"LINE1:B_out#0000EE",
				"LINE1:B_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PANOZ_PNG[$n]: $err\n" if $err;
	}
	if($ENABLE_ZOOM eq "Y") {
		print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PANOZ_PNG[$n] . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PANO_PNG[$n] border=0></a>\n";
	} else {
		print "  <img src=$BASE_URL$PANO_PNG[$n]>\n";
	}
	if(!(($n+1) % 2)) {
		print "  </td>\n";
		print "  </tr>\n";
	} else {
		print "  </td>\n";
	}
	}
	print "  </td>\n";
	print "  </tr>\n";
	print "  </table>\n";
}

sub pc_stats {
	my @tmp;
	my $err;

	if($NET_RIGID[$inetpos] eq 1) {
		$tmp[0] = "--upper-limit=$NET_LIMIT[$inetpos]";
	} else {
		if($NET_RIGID[$inetpos] eq 2) {
			$tmp[0] = "--upper-limit=$NET_LIMIT[$inetpos]";
			$tmp[1] = "--rigid";
		}
	}

	unlink ("$BASE_WWW{$OSTYPE}$PC_PNG[$val]");
	if($ENABLE_ZOOM eq "Y") {
		unlink ("$BASE_WWW{$OSTYPE}$PCZ_PNG[$val]");
	}
	if($PC_LIST[$val]) {
	my @DEF;
	print "  <table cellspacing=5 cellpadding=0 width=1 bgcolor=" . $graph_back_color . " border=1>\n";
	print "  <tr>\n";
	print "  <td bgcolor=" . $title_back_color . " colspan=2>\n";
	print "  <font face='Verdana, Tahoma, sans-serif' color=" . $title_fore_color . ">\n";
	print "    <b>&nbsp;&nbsp;Internet traffic and usage<b>\n";
	print "  </font>\n";
	print "  </td>\n";
	print "  </tr>\n";
	print "  <tr>\n";
	print "  <td bgcolor=" . $title_back_color . ">\n";
	$DEF[0] = "DEF:B_in=$PC_RRD:pc" . ($val+1) . "_bytes_in:AVERAGE";
	$DEF[1] = "DEF:B_out=$PC_RRD:pc" . ($val+1) . "_bytes_out:AVERAGE";
	RRDs::graph("$BASE_WWW{$OSTYPE}$PC_PNG[$val]",
		"--title=$PC_LIST[$val] traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=450",
		"--height=150",
		"--lower-limit=0",
		@VERSION12,
		@tmp,
		@graph_colors,
		@DEF,
		"CDEF:K_in=B_in,1024,/",
		"CDEF:K_out=B_out,1024,/",
		"AREA:B_out#4444EE:Output",
		"AREA:B_in#44EE44:Input",
			"LINE1:B_out#0000EE",
			"LINE1:B_in#00EE00",
		"COMMENT: \\n",
		"COMMENT: \\n",
		"GPRINT:K_out:LAST:KB/s Output      Current\\: %5.0lf",
		"GPRINT:K_out:AVERAGE:    Average\\: %5.0lf",
		"GPRINT:K_out:MIN:    Min\\: %5.0lf",
		"GPRINT:K_out:MAX:    Max\\: %5.0lf\\n",
		"GPRINT:K_in:LAST:KB/s Input       Current\\: %5.0lf",
		"GPRINT:K_in:AVERAGE:    Average\\: %5.0lf",
		"GPRINT:K_in:MIN:    Min\\: %5.0lf",
		"GPRINT:K_in:MAX:    Max\\: %5.0lf\\n",
		"COMMENT: \\n");
	$err = RRDs::error;
	die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PC_PNG[$val]: $err\n" if $err;
	if($ENABLE_ZOOM eq "Y") {
		RRDs::graph("$BASE_WWW{$OSTYPE}$PCZ_PNG[$val]",
			"--title=$PC_LIST[$val] traffic  (1$when)",
			"--start=-1$when",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=$zwidth",
			"--height=$zheight",
			"--lower-limit=0",
			@VERSION12,
			@tmp,
			@graph_colors,
			@DEF,
			"CDEF:K_in=B_in,1024,/",
			"CDEF:K_out=B_out,1024,/",
			"AREA:B_out#4444EE:Output",
			"AREA:B_in#44EE44:Input",
				"LINE1:B_out#0000EE",
				"LINE1:B_in#00EE00");
		$err = RRDs::error;
		die "ERROR: while graphing $BASE_WWW{$OSTYPE}$PCZ_PNG[$val]: $err\n" if $err;
	}
	if($ENABLE_ZOOM eq "Y") {
		print "  <a href=\"javascript:void(window.open('" . $BASE_URL . $PCZ_PNG[$val] . "','','width=" . ($zwidth + 115) . ",height=" . ($zheight + 100) . ",scrollbars=0,resizable=0'))\"><img src=$BASE_URL$PC_PNG[$val] border=0></a>\n";
	} else {
		print "  <img src=$BASE_URL$PC_PNG[$val]>\n";
	}
	print "  </td>\n";
	print "  </tr>\n";
	print "  </table>\n";
	}
}
