#!/bin/sh
#
# @(#) Fibranet NSP, SL
# Copyright (C) 2005-2010 by Jordi Sanfeliu <jordi@fibranet.cat>
# 	- Debian contribution by Uwe Heidrich <uweheidrich@hotmail.com>
#	- Gentoo contribution by Markus Rennings <mren@mrmx.de>
# 	- Gentoo contribution by Matej Povazaj <ybdaba@gmail.com>
#	- Slackware contribution by Bogdan <bogdan@nimblex.net>
#	- FreeBSD contribution by Michael Brune <admin@mjbrune.org>
#
# Install shell-script for Monitorix.
#
# Syntax: install.sh [Y|y]
#
#	- 'Y' or 'y' option assume yes to any question.
#

show_paths() {
	echo
	echo "The following is a list of the default paths where the Monitorix components"
	echo "will be installed:"
	echo
	echo "	1 - $SBIN"
	echo "	2 - $ETC"
	echo "	3 - $INIT"
	echo "	4 - $LIB"
	echo "	5 - $DOC"
	echo "	6 - $HTDOCS"
	echo "	7 - $CGIBIN"
	echo "	8 - $MAN"
}

OS=`uname -s`
case $1 in
	Y|y)	assumeyes="yes"
		;;
esac

clear
echo "Welcome to Monitorix v1.5.2 installation process."
echo

case $OS in
	Linux)
		OK=0
		while [ $OK -eq 0 ] ; do
		echo "IMPORTANT NOTE"
		echo "--------------"
		echo "This is not the recommended method of installing Monitorix."
		echo
		echo "If your distribution doesn't appears in the below list it could be because there is already a package for download either from the Monitorix web site or directly using your distribution repositories."
		echo
		echo "Please, use this script as a last alternative for installing Monitorix."
		echo
		echo "This installation script supports only the following $OS distributions:"
		echo
		echo "	1 - Generic"
		echo "	2 - Debian (Ubuntu)"
		echo "	3 - Slackware"
		echo
		echo -n "	Please select your option: "
		read distro
		case $distro in
			1)
				SBIN="/usr/local/sbin"
				ETC="/usr/local/etc"
				INIT="/usr/local/etc/rc.d"
				LIB="/usr/local/lib"
				DOC="/usr/local/share"
				HTDOCS="/usr/local/www/data"
				CGIBIN="/usr/local/www/cgi-bin"
				MAN="/usr/local/man/man5"
				PORTS="${OS}-Generic"
				show_paths
				OK=1
				;;
			2)
				SBIN="/usr/bin"
				ETC="/etc"
				INIT="/etc/init.d"
				LIB="/var/lib"
				DOC="/usr/share/doc"
				HTDOCS="/var/www"
				CGIBIN="/usr/lib/cgi-bin"
				MAN="/usr/share/man/man5"
				PORTS="${OS}-Debian"
				show_paths
				OK=1
				;;
			3)
				SBIN="/usr/sbin"
				ETC="/etc"
				INIT="/etc/rc.d"
				LIB="/var/lib"
				DOC="/usr/share/doc"
				HTDOCS="/var/www/htdocs"
				CGIBIN="/var/www/cgi-bin"
				MAN="/usr/share/man/man5"
				PORTS="${OS}-Slack"
				show_paths
				OK=1
				;;
			*)
				echo "Bad option!. Try again please."
				echo
				;;
		esac
		done
		;;

	FreeBSD)
		echo "The install script has detected that this is a $OS operating system."
		[ -z $PREFIX ] && PREFIX="/usr/local"
		SBIN="${PREFIX}/sbin"
		ETC="${PREFIX}/etc"
		INIT="${PREFIX}/etc/rc.d"
		LIB="/var/db"
		DOC="${PREFIX}/share/doc"
		HTDOCS="${PREFIX}/www/"
		CGIBIN="${PREFIX}/www/cgi-bin"
		MAN="${PREFIX}/man/man5"
		PORTS="$OS"
		show_paths
		;;

	*)
		echo
		echo "Sorry. Your operating system \"$OS\" is not supported right now."
		echo "Please contact to Jordi Sanfeliu <jordi@fibranet.cat> if you are interested"
		echo "to start the portability process together."
		echo
		exit 1
		;;

esac

echo
[ -z $assumeyes ] && echo "Last chance to stop the installation."
if [ $OS = "FreeBSD" ] ; then
	echo
	echo "IMPORTANT NOTE:"
	echo "Monitorix is a crond-based application and must be executed by root. This means"
	echo "that every time it is started or stopped it will overwrite or remove its own"
	echo "crontab file in the /var/cron/tabs directory."
	echo "This may create a conflict if another application is using the same method."
	echo "You have been warned."
	echo
fi

OK=1
[ -z $assumeyes ] && OK=0
while [ $OK -eq 0 ] ; do
echo -n "Are you sure to install Monitorix on the paths shown? [y/n]: "
read sure
case $sure in
	[nN])
		echo
		echo "Aborting installation."
		exit 1
		;;

	[yY])
		echo
		echo "Starting installation."
		OK=1
		;;

	*)
		;;
esac
done

echo "Copying core script to $SBIN directory"
echo "monitorix.pl"
if [ $OS = "Linux" ] ; then
	install -D -m 755 monitorix.pl $SBIN/monitorix.pl
elif [ $OS = "FreeBSD" ] ; then
	install -d -m 755 $SBIN
	install -c -m 755 monitorix.pl $SBIN
fi
if [ $? -gt 0 ] ; then
	echo
	echo "You don't have enough permissions to install Monitorix."
	echo "Please, execute this script as 'root' or use the command sudo:"
	echo "sudo ./install.sh"
	echo
	exit 1
fi
echo

echo "Copying configuration file to $ETC directory"
echo "monitorix.conf"
if [ -f $ETC/monitorix.conf ] ; then
	echo "backing up the previous monitorix.conf file."
	mv -f $ETC/monitorix.conf $ETC/monitorix.conf.bak
fi
if [ $OS = "Linux" ] ; then
	install -D -m 644 monitorix.conf $ETC/monitorix.conf
	sed -i 's/our \$OSTYPE = \"Linux-RHFC\"/our \$OSTYPE = \"'$PORTS'\"/' $ETC/monitorix.conf
elif [ $OS = "FreeBSD" ] ; then
	install -c -m 644 monitorix.conf $ETC
	sed -i "" 's/our \$OSTYPE = \"Linux-RHFC\"/our \$OSTYPE = \"'$PORTS'\"/' $ETC/monitorix.conf
	sed -i "" "s%\"FreeBSD\"[[:space:]]=> \"/usr/local/www/apache22/data\"%\"FreeBSD\"	=> \"$HTDOCS\"%" $ETC/monitorix.conf
fi
echo

echo "Copying init script to $INIT directory"
echo "ports/${PORTS}/monitorix.init"
if [ $OS = "Linux" ] ; then
	install -D -m 755 ports/${PORTS}/monitorix.init $INIT/monitorix
elif [ $OS = "FreeBSD" ] ; then
	install -d -m 755 $INIT
	install -c -m 755 ports/${PORTS}/monitorix.init $INIT/monitorix
	sed -i "" "s%PREFIX_FOR_CHANGE%$LIB%" $INIT/monitorix
fi
echo

echo "Copying report files to $LIB directory"
echo "reports/"
if [ $OS = "Linux" ] ; then
	install -m 755 -d reports $LIB/monitorix/reports
	cp -r reports $LIB/monitorix/
	mkdir $LIB/monitorix/usage
elif [ $OS = "FreeBSD" ] ; then
	install -d -m 755 $LIB/monitorix/reports
	install -d -m 755 $LIB/monitorix/usage
	cp -r reports $LIB/monitorix/
fi
echo

echo "Copying documentation files to $DOC directory"
objs="Changes COPYING monitorix-apache.conf monitorix-alert.sh monitorix.spec README README.nginx README.Slackware README.FreeBSD TODO"
echo $objs
for file in $objs ; do
	if [ $OS = "Linux" ] ; then
		install -D -m 644 $file $DOC/monitorix/$file
	elif [ $OS = "FreeBSD" ] ; then
		install -d -m 755 $DOC/monitorix
		install -c -m 644 $file $DOC/monitorix
	fi
done
echo

echo "Copying html files to $HTDOCS directory"
objs="logo_bot.png logo_top.png monitorixico.png"
echo $objs
for file in $objs ; do
	if [ $OS = "Linux" ] ; then
		install -D -m 644 $file $HTDOCS/monitorix/$file
	elif [ $OS = "FreeBSD" ] ; then
		install -d -m 755 $HTDOCS/monitorix
		install -c -m 644 $file $HTDOCS/monitorix
	fi
done
mkdir -p $HTDOCS/monitorix/imgs
chmod 777 $HTDOCS/monitorix/imgs
echo

echo "Copying cgi-bin files to $CGIBIN directory"
echo "monitorix.cgi"
if [ $OS = "Linux" ] ; then
	install -D -m 755 monitorix.cgi $CGIBIN/monitorix.cgi
elif [ $OS = "FreeBSD" ] ; then
	install -d -m 755 $CGIBIN
	install -c -m 755 monitorix.cgi $CGIBIN
fi
echo

echo "Copying man pages to $MAN directory"
echo "monitorix.conf.5"
gzip -9 man/man5/monitorix.conf.5
if [ $OS = "Linux" ] ; then
	install -D -m 644 man/man5/monitorix.conf.5.gz $MAN/monitorix.conf.5.gz
elif [ $OS = "FreeBSD" ] ; then
	install -d -m 755 $MAN
	install -c -m 644 man/man5/monitorix.conf.5.gz $MAN
fi
echo

if [ $OS = "Linux" ] ; then
	# required for Slackware and maybe others
	if [ $distro = "3" ] ; then
		mkdir /etc/cron.d 2>/dev/null
		mkdir /var/lib/monitorix 2>/dev/null
	fi
fi

echo "-----------------------------------------------------------------------"
echo "			INSTALLATION SUCCESFULLY FINISHED"
echo "-----------------------------------------------------------------------"
echo "Now make your last adjustments in the monitorix.conf file and finally"
echo "start Monitorix executing the init script:"
echo
echo "service monitorix start"
echo "or"
echo "$INIT/monitorix start"
echo
echo "wait a few minutes and go to http://localhost/monitorix/ to start seeing"
echo "the results."
echo "(don't forget to start your webserver)"
echo
echo "NOTE: As a crond-based application, the root user will receive emails"
echo "about Monitorix execution errors. Please check the root email.".
echo
exit 0

