#!/usr/bin/perl
#
# @(#) Fibranet NSP, SL
# Copyright (C) 2005 by Jordi Sanfeliu <admin@fibranet.com>
#

use strict;
use warnings;
use Time::Local;
use File::Copy;
use IO::Socket;
use RRDs;

our $MONITORIX_VER = "0.7.12";
our $TITLE;
our $SAMBAVER;
our $MULTIHOST;
our $REPORT_LANG;
our $INETIF;
our $IDATE;
our $BASE_DIR;
our $BASE_WWW;
our $USAGE_DIR;
our $REPORT_DIR;
our $PORT01;
our $PORT02;
our $PORT03;
our $PORT04;
our $PORT05;
our $PORT06;
our $PORT07;
our $PORT08;
our $PORT09;
our $PORT10;
our $PORT11;
our $PORT12;
our @MNT_LIST;
our @NET_LIST;
our @PC_LIST;
our $PC_MAX;
our @PC_IP;
our @NET_LIMIT;
our @SERV_LIST;

our $CPU_RRD;
our $DISK_RRD;
our $NET_RRD;
our $SERVU_RRD;
our $PORT_RRD;
our $USER_RRD;
our $INT_RRD;
our $PC_RRD;
our $TEMP_RRD;

our $MACHINE;
our @GRAPH_NAME;
our %GRAPH_TITLE;
our %GRAPHS;

our $LOGO;
our $TIT;
our $BLANK;
our $SIGN;
our $PC_DEFMAIL;
our @PC_MAIL;
our $IPTABLES;

if( -x "/usr/sbin/iptables" ) {
	$IPTABLES="/usr/sbin/iptables";
}
if( -x "/sbin/iptables" ) {
	$IPTABLES="/sbin/iptables";
}


require "/etc/monitorix/monitorix.conf";

if(($#ARGV+1) != 1) {
	syntax();
	exit(1);
}

if($ARGV[0] eq "init") {
	init();
}
elsif($ARGV[0] eq "collect") {
	get_counters();
	reset_counters();
}
elsif($ARGV[0] eq "create") {
	rrd_cpu();
	if($MACHINE eq "ML310") {
		rrd_temp_ML310();
	}
	elsif($MACHINE eq "ML330G3") {
		rrd_temp_ML350G3();
	}
	elsif($MACHINE eq "ML350G3") {
		rrd_temp_ML350G3();
	}
	elsif($MACHINE eq "ML570") {
		rrd_temp_ML570();
	}
	rrd_disk();
	rrd_net();
	rrd_servu();
	rrd_port();
	rrd_user();
	rrd_ints();
	if(scalar(@PC_LIST) != 0) {
		rrd_pc();
	}
}
elsif($ARGV[0] eq "report") {
	if(scalar(@PC_LIST) != 0) {
		report();
	}
}
elsif($ARGV[0] eq "update") {
	update();
}
else {
	syntax();
	exit(1);
}
exit(0);

sub syntax {
	print "Monitorix 3.0\n";
	print "This program must be called by the Monitorix initialization scripts.\n";
	print "Syntax: monitorix.pl [init|collect|create|report|update]\n";
	print "\n";
}

# =========================================================
# 			INIT OPTION
# =========================================================

sub init {
	my $n;
	my $O_INDEX=$BASE_WWW . "/monitorix/index.html.tmp";

	open OHTML, "> $O_INDEX";
	print OHTML <<EOF;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML>
 <HEAD>
  <TITLE>FIBRANET NSP, SL</TITLE>
 </HEAD>
 <BODY
  BGCOLOR="#000000"
  TEXT="#FFFFFF"
  LINK="#8888FF"
  VLINK="#FF8888"
  ALINK="#FF8888">
  <CENTER>
  <FONT FACE="Arial, Helvetica, sans-serif">
  <A HREF="http://www.monitorix.org/"><IMG SRC="logo_top.jpg" BORDER=0></A>
  <H1 ALIGN="CENTER">MONITORIX_VERSION</H1>
  <P>
  <FONT COLOR=888888>
started on 01 Nov 2005
  <HR>
  <BR>
select statistics type
  </FONT>
  <P>
  <FORM ACTION="/cgi-bin/monitorix.cgi" METHOD="POST">
    <TABLE CELLSPACING=5 CELLPADDING=0 BGCOLOR="#888888" BORDER=1>
      <TR>
        <TD BGCOLOR="#333333">
          <FONT FACE="Arial, Helvetica, sans-serif" COLOR="#888800">
<B>&nbsp;Hostname&nbsp;</B>
          </FONT>
       </TD>
        <TD BGCOLOR="#333333">
          <FONT FACE="Arial, Helvetica, sans-serif" COLOR="#888800">
<B>&nbsp;Graph&nbsp;</B>
          </FONT>
       </TD>
     </TR>
      <TR>
        <TD BGCOLOR="#000000">
<!MARK 1>
        </TD>
        <TD BGCOLOR="#000000">
<!MARK 2>
        </TD>
     </TR>
    </TABLE>
    <P>
    <TABLE CELLSPACING=5 CELLPADDING=0 BGCOLOR="#888888" BORDER=1>
     <TR>
        <TD BGCOLOR="#000000">
          <INPUT TYPE="radio" CHECKED NAME="time" VALUE="day">
            <FONT FACE="Arial, Helvetica, sans-serif" COLOR="#888800">Daily&nbsp;</FONT>
        </TD>
        <TD BGCOLOR="#000000">
          <INPUT TYPE="radio" NAME="time" VALUE="week">
            <FONT FACE="Arial, Helvetica, sans-serif" COLOR="#888800">Weekly&nbsp;</FONT>
        </TD>
        <TD BGCOLOR="#000000">
          <INPUT TYPE="radio" NAME="time" VALUE="month">
            <FONT FACE="Arial, Helvetica, sans-serif" COLOR="#888800">Monthly&nbsp;</FONT>
        </TD>
        <TD BGCOLOR="#000000">
          <INPUT TYPE="radio" NAME="time" VALUE="year">
            <FONT FACE="Arial, Helvetica, sans-serif" COLOR="#888800">Yearly&nbsp;</FONT>
        </TD>
      </TR>
    </TABLE>
    <P>
    <BR>
    <INPUT TYPE="submit" VALUE="    Ok    ">
  </FORM>
  </FONT>
  </CENTER>
 </BODY>
</HTML>
EOF
	close OHTML;
	my $I_INDEX=$BASE_WWW . "/monitorix/index.html.tmp";
	$O_INDEX=$BASE_WWW . "/monitorix/index.html";

	open IHTML, "< $I_INDEX";
	open OHTML, "> $O_INDEX";
	while(<IHTML>) {
		if(/<TITLE>/) {
			if(!(/$TITLE/)) {
				s/<TITLE>.*$/<TITLE>$TITLE<\/TITLE>/;
			}
		}
		if(/MONITORIX_VERSION/) {
			s/MONITORIX_VERSION/Monitorix v$MONITORIX_VER/;
		}
		if(/started on/) {
			s/started on.*$/started on $IDATE/;
		}
		if(/<!MARK 1/) {
#			s/<OPTION>.*$/\$ENV{HOSTNAME}<\/OPTION>/;
			print OHTML "          <SELECT NAME='host' SIZE=1>\n";
			print OHTML "            <OPTION VALUE='localhost'>Local Host<\/OPTION>\n";
			if((scalar(@SERV_LIST)) && ($MULTIHOST eq "Y")) {
				print OHTML "            <OPTGROUP LABEL='Multihost'>\n";
				print OHTML "            <OPTION VALUE='multihost.all'>All hosts<\/OPTION>\n";
				for($n = 0; $n < scalar(@SERV_LIST); $n += 2) {
					print OHTML "              <OPTION VALUE='multihost." . ($n / 2). "'>" . $SERV_LIST[$n] . "<\/OPTION>\n";
                                }
				print OHTML "            <\/OPTGROUP>\n";
			}
			if(scalar(@PC_LIST)) {
				print OHTML "            <OPTGROUP LABEL='LAN PCs'>\n";
				print OHTML "              <OPTION VALUE='pc.all'>All LAN PCs<\/OPTION>\n";
				for($n = 0; $n < scalar(@PC_LIST); $n++) {
					print OHTML "              <OPTION VALUE='pc." . $n . "'>" . $PC_LIST[$n] . "<\/OPTION>\n";
                                }
				print OHTML "            <\/OPTGROUP>\n";
			}
			print OHTML "          <\/SELECT>\n";
			next;
		}
		if(/<!MARK 2/) {
			my $gname;
			my $n2;
			my %rgraphs = reverse %GRAPHS;

			print OHTML "          <SELECT NAME='graph' SIZE=1>\n";
			print OHTML "            <OPTION VALUE='all'>All graphs<\/OPTION>\n";
			for($n = 0; $n < scalar(@GRAPH_NAME); $n++) {
				print OHTML "            <OPTGROUP LABEL='" . $GRAPH_TITLE{$GRAPH_NAME[$n]} . "'>\n";
				for($n2 = 0; $n2 <= 23; $n2++) {
					if($GRAPH_NAME[$n] eq "port" ||
						$GRAPH_NAME[$n] eq "net") {
						$gname = sprintf("_%s%02d", $GRAPH_NAME[$n], $n2);
					} else {
						$gname = "_" . $GRAPH_NAME[$n] . $n2;
					}
					if($rgraphs{$gname}) {
						print OHTML "              <OPTION>" . $rgraphs{$gname} . "<\/OPTION>\n";
					}
				}
				print OHTML "            <\/OPTGROUP>\n";
			}
			print OHTML "          <\/SELECT>\n";
			next;
		}
		print OHTML $_;
	}
	close IHTML;
	close OHTML;
	unlink($I_INDEX);

	# create port counters
	system("$IPTABLES -N PORT01_IN 2>/dev/null");
	if(!($? >> 8)) {
		system("$IPTABLES -N PORT01_OUT 2>/dev/null");
		system("$IPTABLES -N PORT02_IN 2>/dev/null");
		system("$IPTABLES -N PORT02_OUT 2>/dev/null");
		system("$IPTABLES -N PORT03_IN 2>/dev/null");
		system("$IPTABLES -N PORT03_OUT 2>/dev/null");
		system("$IPTABLES -N PORT04_IN 2>/dev/null");
		system("$IPTABLES -N PORT04_OUT 2>/dev/null");
		system("$IPTABLES -N PORT05_IN 2>/dev/null");
		system("$IPTABLES -N PORT05_OUT 2>/dev/null");
		system("$IPTABLES -N PORT06_IN 2>/dev/null");
		system("$IPTABLES -N PORT06_OUT 2>/dev/null");
		system("$IPTABLES -N PORT07_IN 2>/dev/null");
		system("$IPTABLES -N PORT07_OUT 2>/dev/null");
		system("$IPTABLES -N PORT08_IN 2>/dev/null");
		system("$IPTABLES -N PORT08_OUT 2>/dev/null");
		system("$IPTABLES -N PORT09_IN 2>/dev/null");
		system("$IPTABLES -N PORT09_OUT 2>/dev/null");
		system("$IPTABLES -N PORT10_IN 2>/dev/null");
		system("$IPTABLES -N PORT10_OUT 2>/dev/null");
		system("$IPTABLES -N PORT11_IN 2>/dev/null");
		system("$IPTABLES -N PORT11_OUT 2>/dev/null");
		system("$IPTABLES -N PORT12_IN 2>/dev/null");
		system("$IPTABLES -N PORT12_OUT 2>/dev/null");

		system("$IPTABLES -A INPUT -p tcp --dport $PORT01 -j PORT01_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT01 -j PORT01_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT02 -j PORT02_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT02 -j PORT02_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT03 -j PORT03_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT03 -j PORT03_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT04 -j PORT04_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT04 -j PORT04_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT05 -j PORT05_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT05 -j PORT05_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT06 -j PORT06_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT06 -j PORT06_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT07 -j PORT07_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT07 -j PORT07_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT08 -j PORT08_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT08 -j PORT08_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT09 -j PORT09_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT09 -j PORT09_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT10 -j PORT10_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT10 -j PORT10_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT11 -j PORT11_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT11 -j PORT11_OUT -c 0 0");
		system("$IPTABLES -A INPUT -p tcp --dport $PORT12 -j PORT12_IN -c 0 0");
		system("$IPTABLES -A OUTPUT -p tcp --sport $PORT12 -j PORT12_OUT -c 0 0");
	}

	# create PC counters
	if(scalar(@PC_LIST)) {
		my $ip;
		for($n = 0; $n < scalar(@PC_LIST); $n++) {
			if(!($ip = $PC_IP[$n])) {
				if(!(gethostbyname($PC_LIST[$n]))) {
					print "DNS problem with: ", $PC_LIST[$n], "\n";
				}
				$ip = inet_ntoa((gethostbyname($PC_LIST[$n]))[4]);
				$ip = $ip . "/32";
			}
			system("$IPTABLES -N $PC_LIST[$n]_total 2>/dev/null");
			if(!($? >> 8)) {
				system("$IPTABLES -N $PC_LIST[$n]_daily");
				system("$IPTABLES -I FORWARD -j $PC_LIST[$n]_total");
				system("$IPTABLES -A $PC_LIST[$n]_total -s $ip -d 0/0 -o $INETIF");
				system("$IPTABLES -A $PC_LIST[$n]_total -s 0/0 -d $ip -i $INETIF");
				system("$IPTABLES -I FORWARD -j $PC_LIST[$n]_daily");
				system("$IPTABLES -A $PC_LIST[$n]_daily -s $ip -d 0/0 -o $INETIF");
				system("$IPTABLES -A $PC_LIST[$n]_daily -s 0/0 -d $ip -i $INETIF");
			}
		}
	}
}

# =========================================================
# 			COLLECT OPTION
# =========================================================

sub get_counters {
	my $n;
	my $ip;
	my $IN;
	my $OUT;
	my ($day) = (localtime(time))[3];

	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		if(!($ip = $PC_IP[$n])) {
			if(!(gethostbyname($PC_LIST[$n]))) {
				print "DNS problem with: ", $PC_LIST[$n], "\n";
			}
			$ip = inet_ntoa((gethostbyname($PC_LIST[$n]))[4]);
		}
		$IN=`$IPTABLES -nxvL | grep -A 3 "Chain $PC_LIST[$n]_daily" | grep $ip | tail -1 | awk -F " " '{ print \$2 }'`;
		$OUT=`$IPTABLES -nxvL | grep -A 3 "Chain $PC_LIST[$n]_daily" | grep $ip | head -1 | awk -F " " '{ print \$2 }'`;
		chomp($IN, $OUT);
		{
			my $STATS=$BASE_DIR . $USAGE_DIR . $PC_LIST[$n];
			open PCSTATS, ">> $STATS" or die $!;
			print PCSTATS $day, " ", $IN, " ", $OUT, "\n";
			close PCSTATS;
		}
	}
}

sub reset_counters {
	my $n;

	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		system("$IPTABLES -Z $PC_LIST[$n]_daily");
	}
}

# ==================================================
# 			REPORT OPTION
# ==================================================

sub report {
	my $n;
	my $TOT_IN;
	my $TOT_OUT;
	my $TOTAL;
	my @f_totin;
	my @f_totout;
	my @f_total;
	my $rline;
	my $month=(localtime(time))[4];	# (0-11  where 0==january)
	my $year=(localtime(time))[5] + 1900;
	my $inetpos;

	for($n = 0; $n < scalar(@NET_LIST); $n++) {
		if($NET_LIST[$n] eq $INETIF) {
			$inetpos=$n;
		}
	}

# Catalan localization
	my @monthlist=("Desembre",
	   	"Gener",
	   	"Febrer",
	   	"Mar",
	   	"Abril",
	   	"Maig",
	   	"Juny",
	   	"Juliol",
	   	"Agost",
	   	"Setembre",
	   	"Octubre",
	   	"Novembre");

	sub adjust($);

	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		my $CURR_STATS=$BASE_DIR . $USAGE_DIR . $PC_LIST[$n];
		my $IHTML_FILE=$BASE_DIR . $REPORT_DIR . $REPORT_LANG . "/" . "traffic_report.html";
		my $OHTML_FILE=$BASE_DIR . $REPORT_DIR . $REPORT_LANG . "/" . $PC_LIST[$n] . ".html";
		my $GRAPH=$BASE_DIR . $REPORT_DIR . $REPORT_LANG . "/" . $PC_LIST[$n] . ".png";
		my @DEF;
		my $TO_ADDR;

	if (-e $CURR_STATS) {
		$TOT_IN=0;
		$TOT_OUT=0;
		$rline="";
		open PC_CURRSTATS, "< $CURR_STATS";
		$rline .= "DAY      INPUT            OUTPUT                 TOTAL\n";
		$rline .= "------------------------------------------------------------\n";
		while(<PC_CURRSTATS>) {
			my @stats = split(/ /, $_);
			chomp(@stats);
			$TOT_IN += $stats[1];
			$TOT_OUT += $stats[2];
			$TOTAL = $stats[1] + $stats[2];
			@f_totin=adjust($stats[1]);
			@f_totout=adjust($stats[2]);
			@f_total=adjust($TOTAL);
			$rline .= sprintf("%-3u %10u %3u%s %11u %3u%s %15u %3u%s\n", $stats[0], $stats[1], $f_totin[0], $f_totin[1], $stats[2], $f_totout[0], $f_totout[1], $TOTAL, $f_total[0], $f_total[1]);
		}
		close PC_CURRSTATS;
		$rline .= "   ---------------------------------------------------------\n";
		$TOTAL=$TOT_IN + $TOT_OUT;
		@f_totin=adjust($TOT_IN);
		@f_totout=adjust($TOT_OUT);
		@f_total=adjust($TOTAL);
		$rline .= sprintf("%14.0f %3u%s %11.0f %3u%s %15.0f %3u%s\n", $TOT_IN, $f_totin[0], $f_totin[1], $TOT_OUT, $f_totout[0], $f_totout[1], $TOTAL, $f_total[0], $f_total[1]);

		open IHTML, "< $IHTML_FILE";
		open OHTML, "> $OHTML_FILE";
		while(<IHTML>) {
			if(/TRAFFICTRAFFICTRAFFIC/) {
				print OHTML $rline;
			} else {
				print OHTML $_;
			}
		}
		close IHTML;
		close OHTML;
		$DEF[0] = "DEF:B_in=$PC_RRD:pc" . ($n+1) . "_bytes_in:AVERAGE \\";
		$DEF[1] = "DEF:B_out=$PC_RRD:pc" . ($n+1) . "_bytes_out:AVERAGE \\";
		RRDs::graph("$GRAPH",
			"--title=$PC_LIST[$n] traffic  (1month)",
			"--start=-1month",
			"--imgformat=PNG",
			"--vertical-label=bytes/sec",
			"--width=450",
			"--height=150",
			"--upper-limit=$NET_LIMIT[$inetpos]",
			"--lower-limit=0",
			"--rigid",
			"--color=CANVAS#000000",
			"--color=BACK#101010",
			"--color=FONT#C0C0C0",
			"--color=MGRID#80C080",
			"--color=GRID#808020",
			"--color=FRAME#808080",
			"--color=ARROW#FFFFFF",
			"--color=SHADEA#404040",
			"--color=SHADEB#404040",
			@DEF,
			"CDEF:K_in=B_in,1024,/",
			"CDEF:K_out=B_out,1024,/",
			"AREA:B_out#4444EE:Output",
			"AREA:B_in#44EE44:Input",
				"LINE1:B_out#0000EE",
				"LINE1:B_in#00EE00",
			"COMMENT:\\n",
			"COMMENT:\\n",
			"GPRINT:K_out:LAST:KB/s Output      Current\\: %5.0lf",
			"GPRINT:K_out:AVERAGE:    Average\\: %5.0lf",
			"GPRINT:K_out:MIN:    Min\\: %5.0lf",
			"GPRINT:K_out:MAX:    Max\\: %5.0lf\\n",
			"GPRINT:K_in:LAST:KB/s Input       Current\\: %5.0lf",
			"GPRINT:K_in:AVERAGE:    Average\\: %5.0lf",
			"GPRINT:K_in:MIN:    Min\\: %5.0lf",
			"GPRINT:K_in:MAX:    Max\\: %5.0lf\\n",
			"COMMENT:\\n");
		$TO_ADDR = $PC_MAIL[$n] ? $PC_MAIL[$n] : $PC_DEFMAIL;
		if($TO_ADDR) {
			system("$BASE_DIR$REPORT_DIR$REPORT_LANG/traffic_report.sh $TO_ADDR $monthlist[$month] $PC_LIST[$n] $OHTML_FILE $GRAPH $LOGO $TIT $BLANK $SIGN");
		}
		unlink($OHTML_FILE, $GRAPH);
		my $NEW_CURR_STATS=sprintf("%s.%02u-%u", $CURR_STATS, ($month + 1), $year);
		rename($CURR_STATS, $NEW_CURR_STATS);
	}
	}
}

sub adjust($) {
	my $bytes=(shift);
	my $adjust=0;
	my $b="  ";

	if($bytes > 0  &&  $bytes < 1048576) {
		$adjust=$bytes/1024;
		$b="KB";
	}
	if($bytes > 1048576  &&  $bytes < 1073741824) {
		$adjust=$bytes/1024/1024;
		$b="MB";
	}
	if($bytes > 1073741824  &&  $bytes < 1000000000000) {
		$adjust=$bytes/1024/1024/1024;
		$b="GB";
	}
	return $adjust, $b;
}

# ==================================================
# 			CREATE OPTION
# ==================================================

sub rrd_cpu {
# RRA: average data of 60*1440 secs = 1 day
# RRA: average data of 60*30*336 secs = 1 week
# RRA: average data of 60*60*744 secs = 1 month
# RRA: average data of 60*1440*365 secs = 1 year
# RRA: min data of 60*1440 secs = 1 day
# RRA: min data of 60*30*336 secs = 1 week
# RRA: min data of 60*60*744 secs = 1 month
# RRA: min data of 60*1440*365 secs = 1 year
# RRA: max data of 60*1440 secs = 1 day
# RRA: max data of 60*30*336 secs = 1 week
# RRA: max data of 60*60*744 secs = 1 month
# RRA: max data of 60*1440*365 secs = 1 year
# RRA: last data of 60*1440 secs = 1 day
# RRA: last data of 60*30*336 secs = 1 week
# RRA: last data of 60*60*744 secs = 1 month
# RRA: last data of 60*1440*365 secs = 1 year

	if(!(-e $CPU_RRD)) {
		RRDs::create($CPU_RRD,
			"--step=60",
			"DS:cpu_load1:GAUGE:120:0:U",
			"DS:cpu_load5:GAUGE:120:0:U",
			"DS:cpu_load15:GAUGE:120:0:U",
			"DS:cpu_nproc:GAUGE:120:0:U",
			"DS:cpu_mbuff:GAUGE:120:0:U",
			"DS:cpu_mcach:GAUGE:120:0:U",
			"DS:cpu_mfree:GAUGE:120:0:U",
			"RRA:AVERAGE:0.5:1:1440",
			"RRA:AVERAGE:0.5:30:336",
			"RRA:AVERAGE:0.5:60:744",
			"RRA:AVERAGE:0.5:1440:365",
			"RRA:MIN:0.5:1:1440",
			"RRA:MIN:0.5:30:336",
			"RRA:MIN:0.5:60:744",
			"RRA:MIN:0.5:1440:365",
			"RRA:MAX:0.5:1:1440",
			"RRA:MAX:0.5:30:336",
			"RRA:MAX:0.5:60:744",
			"RRA:MAX:0.5:1440:365",
			"RRA:LAST:0.5:1:1440",
			"RRA:LAST:0.5:30:336",
			"RRA:LAST:0.5:60:744",
			"RRA:LAST:0.5:1440:365");
	}
}

sub rrd_disk {
# RRA: average data of 300*288 secs = 1 day
# RRA: average data of 300*6*336 secs = 1 week
# RRA: average data of 300*12*744 secs = 1 month
# RRA: average data of 300*288*365 secs = 1 year
# RRA: min data of 300*288 secs = 1 day
# RRA: min data of 300*6*336 secs = 1 week
# RRA: min data of 300*12*744 secs = 1 month
# RRA: min data of 300*288*365 secs = 1 year
# RRA: max data of 300*288 secs = 1 day
# RRA: max data of 300*6*336 secs = 1 week
# RRA: max data of 300*12*744 secs = 1 month
# RRA: max data of 300*288*365 secs = 1 year
# RRA: last data of 300*288 secs = 1 day
# RRA: last data of 300*6*336 secs = 1 week
# RRA: last data of 300*12*744 secs = 1 month
# RRA: last data of 300*288*365 secs = 1 year

	if(!(-e $DISK_RRD)) {
		RRDs::create($DISK_RRD,
			"--step=300",
			"DS:root_tot:GAUGE:600:0:U",
			"DS:root_used:GAUGE:600:0:U",
			"DS:root_free:GAUGE:600:0:U",
			"DS:swap_tot:GAUGE:600:0:U",
			"DS:swap_used:GAUGE:600:0:U",
			"DS:swap_free:GAUGE:600:0:U",
			"DS:mnt1_tot:GAUGE:600:0:U",
			"DS:mnt1_used:GAUGE:600:0:U",
			"DS:mnt1_free:GAUGE:600:0:U",
			"DS:mnt2_tot:GAUGE:600:0:U",
			"DS:mnt2_used:GAUGE:600:0:U",
			"DS:mnt2_free:GAUGE:600:0:U",
			"DS:mnt3_tot:GAUGE:600:0:U",
			"DS:mnt3_used:GAUGE:600:0:U",
			"DS:mnt3_free:GAUGE:600:0:U",
			"DS:mnt4_tot:GAUGE:600:0:U",
			"DS:mnt4_used:GAUGE:600:0:U",
			"DS:mnt4_free:GAUGE:600:0:U",
			"DS:mnt5_tot:GAUGE:600:0:U",
			"DS:mnt5_used:GAUGE:600:0:U",
			"DS:mnt5_free:GAUGE:600:0:U",
			"DS:mnt6_tot:GAUGE:600:0:U",
			"DS:mnt6_used:GAUGE:600:0:U",
			"DS:mnt6_free:GAUGE:600:0:U",
			"DS:mnt7_tot:GAUGE:600:0:U",
			"DS:mnt7_used:GAUGE:600:0:U",
			"DS:mnt7_free:GAUGE:600:0:U",
			"DS:read_cnt:COUNTER:600:0:U",
			"DS:write_cnt:COUNTER:600:0:U",
			"DS:read_sec:COUNTER:600:0:U",
			"DS:write_sec:COUNTER:600:0:U",
			"RRA:AVERAGE:0.5:1:288",
			"RRA:AVERAGE:0.5:6:336",
			"RRA:AVERAGE:0.5:12:744",
			"RRA:AVERAGE:0.5:288:365",
			"RRA:MIN:0.5:1:288",
			"RRA:MIN:0.5:6:336",
			"RRA:MIN:0.5:12:744",
			"RRA:MIN:0.5:288:365",
			"RRA:MAX:0.5:1:288",
			"RRA:MAX:0.5:6:336",
			"RRA:MAX:0.5:12:744",
			"RRA:MAX:0.5:288:365",
			"RRA:LAST:0.5:1:288",
			"RRA:LAST:0.5:6:336",
			"RRA:LAST:0.5:12:744",
			"RRA:LAST:0.5:288:365");
	}
}

sub rrd_net {
# RRA: average data of 60*1440 secs = 1 day
# RRA: average data of 60*30*336 secs = 1 week
# RRA: average data of 60*60*744 secs = 1 month
# RRA: average data of 60*1440*365 secs = 1 year
# RRA: min data of 60*1440 secs = 1 day
# RRA: min data of 60*30*336 secs = 1 week
# RRA: min data of 60*60*744 secs = 1 month
# RRA: min data of 60*1440*365 secs = 1 year
# RRA: max data of 60*1440 secs = 1 day
# RRA: max data of 60*30*336 secs = 1 week
# RRA: max data of 60*60*744 secs = 1 month
# RRA: max data of 60*1440*365 secs = 1 year
# RRA: last data of 60*1440 secs = 1 day
# RRA: last data of 60*30*336 secs = 1 week
# RRA: last data of 60*60*744 secs = 1 month
# RRA: last data of 60*1440*365 secs = 1 year

	if(!(-e $NET_RRD)) {
		RRDs::create($NET_RRD,
			"--step=60",
			"DS:net0_bytes_in:COUNTER:120:0:U",
			"DS:net0_bytes_out:COUNTER:120:0:U",
			"DS:net0_packs_in:COUNTER:120:0:U",
			"DS:net0_packs_out:COUNTER:120:0:U",
			"DS:net0_error_in:COUNTER:120:0:U",
			"DS:net0_error_out:COUNTER:120:0:U",
			"DS:net1_bytes_in:COUNTER:120:0:U",
			"DS:net1_bytes_out:COUNTER:120:0:U",
			"DS:net1_packs_in:COUNTER:120:0:U",
			"DS:net1_packs_out:COUNTER:120:0:U",
			"DS:net1_error_in:COUNTER:120:0:U",
			"DS:net1_error_out:COUNTER:120:0:U",
			"DS:net2_bytes_in:COUNTER:120:0:U",
			"DS:net2_bytes_out:COUNTER:120:0:U",
			"DS:net2_packs_in:COUNTER:120:0:U",
			"DS:net2_packs_out:COUNTER:120:0:U",
			"DS:net2_error_in:COUNTER:120:0:U",
			"DS:net2_error_out:COUNTER:120:0:U",
			"RRA:AVERAGE:0.5:1:1440",
			"RRA:AVERAGE:0.5:30:336",
			"RRA:AVERAGE:0.5:60:744",
			"RRA:AVERAGE:0.5:1440:365",
			"RRA:MIN:0.5:1:1440",
			"RRA:MIN:0.5:30:336",
			"RRA:MIN:0.5:60:744",
			"RRA:MIN:0.5:1440:365",
			"RRA:MAX:0.5:1:1440",
			"RRA:MAX:0.5:30:336",
			"RRA:MAX:0.5:60:744",
			"RRA:MAX:0.5:1440:365",
			"RRA:LAST:0.5:1:1440",
			"RRA:LAST:0.5:30:336",
			"RRA:LAST:0.5:60:744",
			"RRA:LAST:0.5:1440:365");
	}
}

sub rrd_servu {
# RRA: average data of 300*288 secs = 1 day
# RRA: average data of 300*6*336 secs = 1 week
# RRA: average data of 300*12*744 secs = 1 month
# RRA: average data of 300*288*365 secs = 1 year
# RRA: min data of 300*288 secs = 1 day
# RRA: min data of 300*6*336 secs = 1 week
# RRA: min data of 300*12*744 secs = 1 month
# RRA: min data of 300*288*365 secs = 1 year
# RRA: max data of 300*288 secs = 1 day
# RRA: max data of 300*6*336 secs = 1 week
# RRA: max data of 300*12*744 secs = 1 month
# RRA: max data of 300*288*365 secs = 1 year
# RRA: last data of 300*288 secs = 1 day
# RRA: last data of 300*6*336 secs = 1 week
# RRA: last data of 300*12*744 secs = 1 month
# RRA: last data of 300*288*365 secs = 1 year

	if(!(-e $SERVU_RRD)) {
		RRDs::create($SERVU_RRD,
			"--step=300",
			"DS:pop3:GAUGE:600:0:U",
			"DS:smtp:GAUGE:600:0:U",
			"DS:ssh:GAUGE:600:0:U",
			"DS:ftp:GAUGE:600:0:U",
			"DS:telnet:GAUGE:600:0:U",
			"DS:www:GAUGE:600:0:U",
			"DS:smb:GAUGE:600:0:U",
			"DS:virusmail:GAUGE:600:0:U",
			"DS:fax:GAUGE:600:0:U",
			"RRA:AVERAGE:0.5:1:288",
			"RRA:AVERAGE:0.5:6:336",
			"RRA:AVERAGE:0.5:12:744",
			"RRA:AVERAGE:0.5:288:365",
			"RRA:MIN:0.5:1:288",
			"RRA:MIN:0.5:6:336",
			"RRA:MIN:0.5:12:744",
			"RRA:MIN:0.5:288:365",
			"RRA:MAX:0.5:1:288",
			"RRA:MAX:0.5:6:336",
			"RRA:MAX:0.5:12:744",
			"RRA:MAX:0.5:288:365",
			"RRA:LAST:0.5:1:288",
			"RRA:LAST:0.5:6:336",
			"RRA:LAST:0.5:12:744",
			"RRA:LAST:0.5:288:365");
	}
}

sub rrd_port {
# RRA: average data of 60*1440 secs = 1 day
# RRA: average data of 60*30*336 secs = 1 week
# RRA: average data of 60*60*744 secs = 1 month
# RRA: average data of 60*1440*365 secs = 1 year
# RRA: min data of 60*1440 secs = 1 day
# RRA: min data of 60*30*336 secs = 1 week
# RRA: min data of 60*60*744 secs = 1 month
# RRA: min data of 60*1440*365 secs = 1 year
# RRA: max data of 60*1440 secs = 1 day
# RRA: max data of 60*30*336 secs = 1 week
# RRA: max data of 60*60*744 secs = 1 month
# RRA: max data of 60*1440*365 secs = 1 year
# RRA: last data of 60*1440 secs = 1 day
# RRA: last data of 60*30*336 secs = 1 week
# RRA: last data of 60*60*744 secs = 1 month
# RRA: last data of 60*1440*365 secs = 1 year

	if(!(-e $PORT_RRD)) {
		RRDs::create($PORT_RRD,
			"--step=60",
			"DS:port01_bytes_in:COUNTER:120:0:U",
			"DS:port01_bytes_out:COUNTER:120:0:U",
			"DS:port02_bytes_in:COUNTER:120:0:U",
			"DS:port02_bytes_out:COUNTER:120:0:U",
			"DS:port03_bytes_in:COUNTER:120:0:U",
			"DS:port03_bytes_out:COUNTER:120:0:U",
			"DS:port04_bytes_in:COUNTER:120:0:U",
			"DS:port04_bytes_out:COUNTER:120:0:U",
			"DS:port05_bytes_in:COUNTER:120:0:U",
			"DS:port05_bytes_out:COUNTER:120:0:U",
			"DS:port06_bytes_in:COUNTER:120:0:U",
			"DS:port06_bytes_out:COUNTER:120:0:U",
			"DS:port07_bytes_in:COUNTER:120:0:U",
			"DS:port07_bytes_out:COUNTER:120:0:U",
			"DS:port08_bytes_in:COUNTER:120:0:U",
			"DS:port08_bytes_out:COUNTER:120:0:U",
			"DS:port09_bytes_in:COUNTER:120:0:U",
			"DS:port09_bytes_out:COUNTER:120:0:U",
			"DS:port10_bytes_in:COUNTER:120:0:U",
			"DS:port10_bytes_out:COUNTER:120:0:U",
			"DS:port11_bytes_in:COUNTER:120:0:U",
			"DS:port11_bytes_out:COUNTER:120:0:U",
			"DS:port12_bytes_in:COUNTER:120:0:U",
			"DS:port12_bytes_out:COUNTER:120:0:U",
			"RRA:AVERAGE:0.5:1:1440",
			"RRA:AVERAGE:0.5:30:336",
			"RRA:AVERAGE:0.5:60:744",
			"RRA:AVERAGE:0.5:1440:365",
			"RRA:MIN:0.5:1:1440",
			"RRA:MIN:0.5:30:336",
			"RRA:MIN:0.5:60:744",
			"RRA:MIN:0.5:1440:365",
			"RRA:MAX:0.5:1:1440",
			"RRA:MAX:0.5:30:336",
			"RRA:MAX:0.5:60:744",
			"RRA:MAX:0.5:1440:365",
			"RRA:LAST:0.5:1:1440",
			"RRA:LAST:0.5:30:336",
			"RRA:LAST:0.5:60:744",
			"RRA:LAST:0.5:1440:365");
	}
}

sub rrd_user {
# RRA: average data of 60*1440 secs = 1 day
# RRA: average data of 60*30*336 secs = 1 week
# RRA: average data of 60*60*744 secs = 1 month
# RRA: average data of 60*1440*365 secs = 1 year
# RRA: min data of 60*1440 secs = 1 day
# RRA: min data of 60*30*336 secs = 1 week
# RRA: min data of 60*60*744 secs = 1 month
# RRA: min data of 60*1440*365 secs = 1 year
# RRA: max data of 60*1440 secs = 1 day
# RRA: max data of 60*30*336 secs = 1 week
# RRA: max data of 60*60*744 secs = 1 month
# RRA: max data of 60*1440*365 secs = 1 year
# RRA: last data of 60*1440 secs = 1 day
# RRA: last data of 60*30*336 secs = 1 week
# RRA: last data of 60*60*744 secs = 1 month
# RRA: last data of 60*1440*365 secs = 1 year

	if(!(-e $USER_RRD)) {
		RRDs::create($USER_RRD,
			"--step=60",
			"DS:user_usr:GAUGE:120:0:U",
			"DS:user_smb:GAUGE:120:0:U",
			"DS:user_mac:GAUGE:120:0:U",
			"RRA:AVERAGE:0.5:1:1440",
			"RRA:AVERAGE:0.5:30:336",
			"RRA:AVERAGE:0.5:60:744",
			"RRA:AVERAGE:0.5:1440:365",
			"RRA:MIN:0.5:1:1440",
			"RRA:MIN:0.5:30:336",
			"RRA:MIN:0.5:60:744",
			"RRA:MIN:0.5:1440:365",
			"RRA:MAX:0.5:1:1440",
			"RRA:MAX:0.5:30:336",
			"RRA:MAX:0.5:60:744",
			"RRA:MAX:0.5:1440:365",
			"RRA:LAST:0.5:1:1440",
			"RRA:LAST:0.5:30:336",
			"RRA:LAST:0.5:60:744",
			"RRA:LAST:0.5:1440:365");
	}
}

sub rrd_ints {
# RRA: average data of 60*1440 secs = 1 day
# RRA: average data of 60*30*336 secs = 1 week
# RRA: average data of 60*60*744 secs = 1 month
# RRA: average data of 60*1440*365 secs = 1 year
# RRA: min data of 60*1440 secs = 1 day
# RRA: min data of 60*30*336 secs = 1 week
# RRA: min data of 60*60*744 secs = 1 month
# RRA: min data of 60*1440*365 secs = 1 year
# RRA: max data of 60*1440 secs = 1 day
# RRA: max data of 60*30*336 secs = 1 week
# RRA: max data of 60*60*744 secs = 1 month
# RRA: max data of 60*1440*365 secs = 1 year
# RRA: last data of 60*1440 secs = 1 day
# RRA: last data of 60*30*336 secs = 1 week
# RRA: last data of 60*60*744 secs = 1 month
# RRA: last data of 60*1440*365 secs = 1 year

	if(!(-e $INT_RRD)) {
		RRDs::create($INT_RRD,
			"--step=60",
			"DS:int_0:COUNTER:120:0:U",
			"DS:int_1:COUNTER:120:0:U",
			"DS:int_2:COUNTER:120:0:U",
			"DS:int_3:COUNTER:120:0:U",
			"DS:int_4:COUNTER:120:0:U",
			"DS:int_5:COUNTER:120:0:U",
			"DS:int_6:COUNTER:120:0:U",
			"DS:int_7:COUNTER:120:0:U",
			"DS:int_8:COUNTER:120:0:U",
			"DS:int_9:COUNTER:120:0:U",
			"DS:int_10:COUNTER:120:0:U",
			"DS:int_11:COUNTER:120:0:U",
			"DS:int_12:COUNTER:120:0:U",
			"DS:int_13:COUNTER:120:0:U",
			"DS:int_14:COUNTER:120:0:U",
			"DS:int_15:COUNTER:120:0:U",
			"RRA:AVERAGE:0.5:1:1440",
			"RRA:AVERAGE:0.5:30:336",
			"RRA:AVERAGE:0.5:60:744",
			"RRA:AVERAGE:0.5:1440:365",
			"RRA:MIN:0.5:1:1440",
			"RRA:MIN:0.5:30:336",
			"RRA:MIN:0.5:60:744",
			"RRA:MIN:0.5:1440:365",
			"RRA:MAX:0.5:1:1440",
			"RRA:MAX:0.5:30:336",
			"RRA:MAX:0.5:60:744",
			"RRA:MAX:0.5:1440:365",
			"RRA:LAST:0.5:1:1440",
			"RRA:LAST:0.5:30:336",
			"RRA:LAST:0.5:60:744",
			"RRA:LAST:0.5:1440:365");
	}
}

sub rrd_pc {
# RRA: average data of 60*1440 secs = 1 day
# RRA: average data of 60*30*336 secs = 1 week
# RRA: average data of 60*60*744 secs = 1 month
# RRA: average data of 60*1440*365 secs = 1 year
# RRA: min data of 60*1440 secs = 1 day
# RRA: min data of 60*30*336 secs = 1 week
# RRA: min data of 60*60*744 secs = 1 month
# RRA: min data of 60*1440*365 secs = 1 year
# RRA: max data of 60*1440 secs = 1 day
# RRA: max data of 60*30*336 secs = 1 week
# RRA: max data of 60*60*744 secs = 1 month
# RRA: max data of 60*1440*365 secs = 1 year
# RRA: last data of 60*1440 secs = 1 day
# RRA: last data of 60*30*336 secs = 1 week
# RRA: last data of 60*60*744 secs = 1 month
# RRA: last data of 60*1440*365 secs = 1 year

	if(!(-e $PC_RRD)) {
		RRDs::create($PC_RRD,
			"--step=60",
			"DS:pc1_bytes_in:COUNTER:120:0:U",
			"DS:pc1_bytes_out:COUNTER:120:0:U",
			"DS:pc2_bytes_in:COUNTER:120:0:U",
			"DS:pc2_bytes_out:COUNTER:120:0:U",
			"DS:pc3_bytes_in:COUNTER:120:0:U",
			"DS:pc3_bytes_out:COUNTER:120:0:U",
			"DS:pc4_bytes_in:COUNTER:120:0:U",
			"DS:pc4_bytes_out:COUNTER:120:0:U",
			"DS:pc5_bytes_in:COUNTER:120:0:U",
			"DS:pc5_bytes_out:COUNTER:120:0:U",
			"DS:pc6_bytes_in:COUNTER:120:0:U",
			"DS:pc6_bytes_out:COUNTER:120:0:U",
			"DS:pc7_bytes_in:COUNTER:120:0:U",
			"DS:pc7_bytes_out:COUNTER:120:0:U",
			"DS:pc8_bytes_in:COUNTER:120:0:U",
			"DS:pc8_bytes_out:COUNTER:120:0:U",
			"DS:pc9_bytes_in:COUNTER:120:0:U",
			"DS:pc9_bytes_out:COUNTER:120:0:U",
			"DS:pc10_bytes_in:COUNTER:120:0:U",
			"DS:pc10_bytes_out:COUNTER:120:0:U",
			"DS:pc11_bytes_in:COUNTER:120:0:U",
			"DS:pc11_bytes_out:COUNTER:120:0:U",
			"DS:pc12_bytes_in:COUNTER:120:0:U",
			"DS:pc12_bytes_out:COUNTER:120:0:U",
			"DS:pc13_bytes_in:COUNTER:120:0:U",
			"DS:pc13_bytes_out:COUNTER:120:0:U",
			"DS:pc14_bytes_in:COUNTER:120:0:U",
			"DS:pc14_bytes_out:COUNTER:120:0:U",
			"DS:pc15_bytes_in:COUNTER:120:0:U",
			"DS:pc15_bytes_out:COUNTER:120:0:U",
			"DS:pc16_bytes_in:COUNTER:120:0:U",
			"DS:pc16_bytes_out:COUNTER:120:0:U",
			"DS:pc17_bytes_in:COUNTER:120:0:U",
			"DS:pc17_bytes_out:COUNTER:120:0:U",
			"DS:pc18_bytes_in:COUNTER:120:0:U",
			"DS:pc18_bytes_out:COUNTER:120:0:U",
			"DS:pc19_bytes_in:COUNTER:120:0:U",
			"DS:pc19_bytes_out:COUNTER:120:0:U",
			"DS:pc20_bytes_in:COUNTER:120:0:U",
			"DS:pc20_bytes_out:COUNTER:120:0:U",
			"DS:pc21_bytes_in:COUNTER:120:0:U",
			"DS:pc21_bytes_out:COUNTER:120:0:U",
			"DS:pc22_bytes_in:COUNTER:120:0:U",
			"DS:pc22_bytes_out:COUNTER:120:0:U",
			"DS:pc23_bytes_in:COUNTER:120:0:U",
			"DS:pc23_bytes_out:COUNTER:120:0:U",
			"DS:pc24_bytes_in:COUNTER:120:0:U",
			"DS:pc24_bytes_out:COUNTER:120:0:U",
			"DS:pc25_bytes_in:COUNTER:120:0:U",
			"DS:pc25_bytes_out:COUNTER:120:0:U",
			"DS:pc26_bytes_in:COUNTER:120:0:U",
			"DS:pc26_bytes_out:COUNTER:120:0:U",
			"DS:pc27_bytes_in:COUNTER:120:0:U",
			"DS:pc27_bytes_out:COUNTER:120:0:U",
			"DS:pc28_bytes_in:COUNTER:120:0:U",
			"DS:pc28_bytes_out:COUNTER:120:0:U",
			"DS:pc29_bytes_in:COUNTER:120:0:U",
			"DS:pc29_bytes_out:COUNTER:120:0:U",
			"DS:pc30_bytes_in:COUNTER:120:0:U",
			"DS:pc30_bytes_out:COUNTER:120:0:U",
			"DS:pc31_bytes_in:COUNTER:120:0:U",
			"DS:pc31_bytes_out:COUNTER:120:0:U",
			"DS:pc32_bytes_in:COUNTER:120:0:U",
			"DS:pc32_bytes_out:COUNTER:120:0:U",
			"DS:pc33_bytes_in:COUNTER:120:0:U",
			"DS:pc33_bytes_out:COUNTER:120:0:U",
			"DS:pc34_bytes_in:COUNTER:120:0:U",
			"DS:pc34_bytes_out:COUNTER:120:0:U",
			"DS:pc35_bytes_in:COUNTER:120:0:U",
			"DS:pc35_bytes_out:COUNTER:120:0:U",
			"DS:pc36_bytes_in:COUNTER:120:0:U",
			"DS:pc36_bytes_out:COUNTER:120:0:U",
			"DS:pc37_bytes_in:COUNTER:120:0:U",
			"DS:pc37_bytes_out:COUNTER:120:0:U",
			"DS:pc38_bytes_in:COUNTER:120:0:U",
			"DS:pc38_bytes_out:COUNTER:120:0:U",
			"DS:pc39_bytes_in:COUNTER:120:0:U",
			"DS:pc39_bytes_out:COUNTER:120:0:U",
			"DS:pc40_bytes_in:COUNTER:120:0:U",
			"DS:pc40_bytes_out:COUNTER:120:0:U",
			"DS:pc41_bytes_in:COUNTER:120:0:U",
			"DS:pc41_bytes_out:COUNTER:120:0:U",
			"DS:pc42_bytes_in:COUNTER:120:0:U",
			"DS:pc42_bytes_out:COUNTER:120:0:U",
			"DS:pc43_bytes_in:COUNTER:120:0:U",
			"DS:pc43_bytes_out:COUNTER:120:0:U",
			"DS:pc44_bytes_in:COUNTER:120:0:U",
			"DS:pc44_bytes_out:COUNTER:120:0:U",
			"DS:pc45_bytes_in:COUNTER:120:0:U",
			"DS:pc45_bytes_out:COUNTER:120:0:U",
			"DS:pc46_bytes_in:COUNTER:120:0:U",
			"DS:pc46_bytes_out:COUNTER:120:0:U",
			"DS:pc47_bytes_in:COUNTER:120:0:U",
			"DS:pc47_bytes_out:COUNTER:120:0:U",
			"DS:pc48_bytes_in:COUNTER:120:0:U",
			"DS:pc48_bytes_out:COUNTER:120:0:U",
			"DS:pc49_bytes_in:COUNTER:120:0:U",
			"DS:pc49_bytes_out:COUNTER:120:0:U",
			"DS:pc50_bytes_in:COUNTER:120:0:U",
			"DS:pc50_bytes_out:COUNTER:120:0:U",
			"DS:pc51_bytes_in:COUNTER:120:0:U",
			"DS:pc51_bytes_out:COUNTER:120:0:U",
			"DS:pc52_bytes_in:COUNTER:120:0:U",
			"DS:pc52_bytes_out:COUNTER:120:0:U",
			"DS:pc53_bytes_in:COUNTER:120:0:U",
			"DS:pc53_bytes_out:COUNTER:120:0:U",
			"DS:pc54_bytes_in:COUNTER:120:0:U",
			"DS:pc54_bytes_out:COUNTER:120:0:U",
			"DS:pc55_bytes_in:COUNTER:120:0:U",
			"DS:pc55_bytes_out:COUNTER:120:0:U",
			"DS:pc56_bytes_in:COUNTER:120:0:U",
			"DS:pc56_bytes_out:COUNTER:120:0:U",
			"DS:pc57_bytes_in:COUNTER:120:0:U",
			"DS:pc57_bytes_out:COUNTER:120:0:U",
			"DS:pc58_bytes_in:COUNTER:120:0:U",
			"DS:pc58_bytes_out:COUNTER:120:0:U",
			"DS:pc59_bytes_in:COUNTER:120:0:U",
			"DS:pc59_bytes_out:COUNTER:120:0:U",
			"DS:pc60_bytes_in:COUNTER:120:0:U",
			"DS:pc60_bytes_out:COUNTER:120:0:U",
			"DS:pc61_bytes_in:COUNTER:120:0:U",
			"DS:pc61_bytes_out:COUNTER:120:0:U",
			"DS:pc62_bytes_in:COUNTER:120:0:U",
			"DS:pc62_bytes_out:COUNTER:120:0:U",
			"DS:pc63_bytes_in:COUNTER:120:0:U",
			"DS:pc63_bytes_out:COUNTER:120:0:U",
			"DS:pc64_bytes_in:COUNTER:120:0:U",
			"DS:pc64_bytes_out:COUNTER:120:0:U",
			"DS:pc65_bytes_in:COUNTER:120:0:U",
			"DS:pc65_bytes_out:COUNTER:120:0:U",
			"DS:pc66_bytes_in:COUNTER:120:0:U",
			"DS:pc66_bytes_out:COUNTER:120:0:U",
			"DS:pc67_bytes_in:COUNTER:120:0:U",
			"DS:pc67_bytes_out:COUNTER:120:0:U",
			"DS:pc68_bytes_in:COUNTER:120:0:U",
			"DS:pc68_bytes_out:COUNTER:120:0:U",
			"DS:pc69_bytes_in:COUNTER:120:0:U",
			"DS:pc69_bytes_out:COUNTER:120:0:U",
			"DS:pc70_bytes_in:COUNTER:120:0:U",
			"DS:pc70_bytes_out:COUNTER:120:0:U",
			"DS:pc71_bytes_in:COUNTER:120:0:U",
			"DS:pc71_bytes_out:COUNTER:120:0:U",
			"DS:pc72_bytes_in:COUNTER:120:0:U",
			"DS:pc72_bytes_out:COUNTER:120:0:U",
			"DS:pc73_bytes_in:COUNTER:120:0:U",
			"DS:pc73_bytes_out:COUNTER:120:0:U",
			"DS:pc74_bytes_in:COUNTER:120:0:U",
			"DS:pc74_bytes_out:COUNTER:120:0:U",
			"DS:pc75_bytes_in:COUNTER:120:0:U",
			"DS:pc75_bytes_out:COUNTER:120:0:U",
			"DS:pc76_bytes_in:COUNTER:120:0:U",
			"DS:pc76_bytes_out:COUNTER:120:0:U",
			"DS:pc77_bytes_in:COUNTER:120:0:U",
			"DS:pc77_bytes_out:COUNTER:120:0:U",
			"DS:pc78_bytes_in:COUNTER:120:0:U",
			"DS:pc78_bytes_out:COUNTER:120:0:U",
			"DS:pc79_bytes_in:COUNTER:120:0:U",
			"DS:pc79_bytes_out:COUNTER:120:0:U",
			"DS:pc80_bytes_in:COUNTER:120:0:U",
			"DS:pc80_bytes_out:COUNTER:120:0:U",
			"DS:pc81_bytes_in:COUNTER:120:0:U",
			"DS:pc81_bytes_out:COUNTER:120:0:U",
			"DS:pc82_bytes_in:COUNTER:120:0:U",
			"DS:pc82_bytes_out:COUNTER:120:0:U",
			"DS:pc83_bytes_in:COUNTER:120:0:U",
			"DS:pc83_bytes_out:COUNTER:120:0:U",
			"DS:pc84_bytes_in:COUNTER:120:0:U",
			"DS:pc84_bytes_out:COUNTER:120:0:U",
			"DS:pc85_bytes_in:COUNTER:120:0:U",
			"DS:pc85_bytes_out:COUNTER:120:0:U",
			"DS:pc86_bytes_in:COUNTER:120:0:U",
			"DS:pc86_bytes_out:COUNTER:120:0:U",
			"DS:pc87_bytes_in:COUNTER:120:0:U",
			"DS:pc87_bytes_out:COUNTER:120:0:U",
			"DS:pc88_bytes_in:COUNTER:120:0:U",
			"DS:pc88_bytes_out:COUNTER:120:0:U",
			"DS:pc89_bytes_in:COUNTER:120:0:U",
			"DS:pc89_bytes_out:COUNTER:120:0:U",
			"DS:pc90_bytes_in:COUNTER:120:0:U",
			"DS:pc90_bytes_out:COUNTER:120:0:U",
			"DS:pc91_bytes_in:COUNTER:120:0:U",
			"DS:pc91_bytes_out:COUNTER:120:0:U",
			"DS:pc92_bytes_in:COUNTER:120:0:U",
			"DS:pc92_bytes_out:COUNTER:120:0:U",
			"DS:pc93_bytes_in:COUNTER:120:0:U",
			"DS:pc93_bytes_out:COUNTER:120:0:U",
			"DS:pc94_bytes_in:COUNTER:120:0:U",
			"DS:pc94_bytes_out:COUNTER:120:0:U",
			"DS:pc95_bytes_in:COUNTER:120:0:U",
			"DS:pc95_bytes_out:COUNTER:120:0:U",
			"DS:pc96_bytes_in:COUNTER:120:0:U",
			"DS:pc96_bytes_out:COUNTER:120:0:U",
			"DS:pc97_bytes_in:COUNTER:120:0:U",
			"DS:pc97_bytes_out:COUNTER:120:0:U",
			"DS:pc98_bytes_in:COUNTER:120:0:U",
			"DS:pc98_bytes_out:COUNTER:120:0:U",
			"DS:pc99_bytes_in:COUNTER:120:0:U",
			"DS:pc99_bytes_out:COUNTER:120:0:U",
			"DS:pc100_bytes_in:COUNTER:120:0:U",
			"DS:pc100_bytes_out:COUNTER:120:0:U",
			"RRA:AVERAGE:0.5:1:1440",
			"RRA:AVERAGE:0.5:30:336",
			"RRA:AVERAGE:0.5:60:744",
			"RRA:AVERAGE:0.5:1440:365",
			"RRA:MIN:0.5:1:1440",
			"RRA:MIN:0.5:30:336",
			"RRA:MIN:0.5:60:744",
			"RRA:MIN:0.5:1440:365",
			"RRA:MAX:0.5:1:1440",
			"RRA:MAX:0.5:30:336",
			"RRA:MAX:0.5:60:744",
			"RRA:MAX:0.5:1440:365",
			"RRA:LAST:0.5:1:1440",
			"RRA:LAST:0.5:30:336",
			"RRA:LAST:0.5:60:744",
			"RRA:LAST:0.5:1440:365");
	}
}

sub rrd_temp_ML310 {
# RRA: average data of 60*1440 secs = 1 day
# RRA: average data of 60*30*336 secs = 1 week
# RRA: average data of 60*60*744 secs = 1 month
# RRA: average data of 60*1440*365 secs = 1 year
# RRA: min data of 60*1440 secs = 1 day
# RRA: min data of 60*30*336 secs = 1 week
# RRA: min data of 60*60*744 secs = 1 month
# RRA: min data of 60*1440*365 secs = 1 year
# RRA: max data of 60*1440 secs = 1 day
# RRA: max data of 60*30*336 secs = 1 week
# RRA: max data of 60*60*744 secs = 1 month
# RRA: max data of 60*1440*365 secs = 1 year
# RRA: last data of 60*1440 secs = 1 day
# RRA: last data of 60*30*336 secs = 1 week
# RRA: last data of 60*60*744 secs = 1 month
# RRA: last data of 60*1440*365 secs = 1 year

	if(!(-e $TEMP_RRD)) {
		RRDs::create($TEMP_RRD,
			"--step=60",
			"DS:sb:GAUGE:120:0:U",
			"DS:cpu1:GAUGE:120:0:U",
			"RRA:AVERAGE:0.5:1:1440",
			"RRA:AVERAGE:0.5:30:336",
			"RRA:AVERAGE:0.5:60:744",
			"RRA:AVERAGE:0.5:1440:365",
			"RRA:MIN:0.5:1:1440",
			"RRA:MIN:0.5:30:336",
			"RRA:MIN:0.5:60:744",
			"RRA:MIN:0.5:1440:365",
			"RRA:MAX:0.5:1:1440",
			"RRA:MAX:0.5:30:336",
			"RRA:MAX:0.5:60:744",
			"RRA:MAX:0.5:1440:365",
			"RRA:LAST:0.5:1:1440",
			"RRA:LAST:0.5:30:336",
			"RRA:LAST:0.5:60:744",
			"RRA:LAST:0.5:1440:365");
	}
}

sub rrd_temp_ML350G3 {
# RRA: average data of 60*1440 secs = 1 day
# RRA: average data of 60*30*336 secs = 1 week
# RRA: average data of 60*60*744 secs = 1 month
# RRA: average data of 60*1440*365 secs = 1 year
# RRA: min data of 60*1440 secs = 1 day
# RRA: min data of 60*30*336 secs = 1 week
# RRA: min data of 60*60*744 secs = 1 month
# RRA: min data of 60*1440*365 secs = 1 year
# RRA: max data of 60*1440 secs = 1 day
# RRA: max data of 60*30*336 secs = 1 week
# RRA: max data of 60*60*744 secs = 1 month
# RRA: max data of 60*1440*365 secs = 1 year
# RRA: last data of 60*1440 secs = 1 day
# RRA: last data of 60*30*336 secs = 1 week
# RRA: last data of 60*60*744 secs = 1 month
# RRA: last data of 60*1440*365 secs = 1 year

	if(!(-e $TEMP_RRD)) {
		RRDs::create($TEMP_RRD,
			"--step=60",
			"DS:sb:GAUGE:120:0:U",
			"DS:cpu1:GAUGE:120:0:U",
			"DS:cpu2:GAUGE:120:0:U",
			"RRA:AVERAGE:0.5:1:1440",
			"RRA:AVERAGE:0.5:30:336",
			"RRA:AVERAGE:0.5:60:744",
			"RRA:AVERAGE:0.5:1440:365",
			"RRA:MIN:0.5:1:1440",
			"RRA:MIN:0.5:30:336",
			"RRA:MIN:0.5:60:744",
			"RRA:MIN:0.5:1440:365",
			"RRA:MAX:0.5:1:1440",
			"RRA:MAX:0.5:30:336",
			"RRA:MAX:0.5:60:744",
			"RRA:MAX:0.5:1440:365",
			"RRA:LAST:0.5:1:1440",
			"RRA:LAST:0.5:30:336",
			"RRA:LAST:0.5:60:744",
			"RRA:LAST:0.5:1440:365");
	}
}

sub rrd_temp_ML570 {
# RRA: average data of 60*1440 secs = 1 day
# RRA: average data of 60*30*336 secs = 1 week
# RRA: average data of 60*60*744 secs = 1 month
# RRA: average data of 60*1440*365 secs = 1 year
# RRA: min data of 60*1440 secs = 1 day
# RRA: min data of 60*30*336 secs = 1 week
# RRA: min data of 60*60*744 secs = 1 month
# RRA: min data of 60*1440*365 secs = 1 year
# RRA: max data of 60*1440 secs = 1 day
# RRA: max data of 60*30*336 secs = 1 week
# RRA: max data of 60*60*744 secs = 1 month
# RRA: max data of 60*1440*365 secs = 1 year
# RRA: last data of 60*1440 secs = 1 day
# RRA: last data of 60*30*336 secs = 1 week
# RRA: last data of 60*60*744 secs = 1 month
# RRA: last data of 60*1440*365 secs = 1 year

	if(!(-e $TEMP_RRD)) {
		RRDs::create($TEMP_RRD,
			"--step=60",
			"DS:cpu1:GAUGE:120:0:U",
			"DS:cpu2:GAUGE:120:0:U",
			"DS:cpu3:GAUGE:120:0:U",
			"DS:cpu4:GAUGE:120:0:U",
			"DS:sb1:GAUGE:120:0:U",
			"DS:sb2:GAUGE:120:0:U",
			"DS:scsi1:GAUGE:120:0:U",
			"DS:scsi2:GAUGE:120:0:U",
			"RRA:AVERAGE:0.5:1:1440",
			"RRA:AVERAGE:0.5:30:336",
			"RRA:AVERAGE:0.5:60:744",
			"RRA:AVERAGE:0.5:1440:365",
			"RRA:MIN:0.5:1:1440",
			"RRA:MIN:0.5:30:336",
			"RRA:MIN:0.5:60:744",
			"RRA:MIN:0.5:1440:365",
			"RRA:MAX:0.5:1:1440",
			"RRA:MAX:0.5:30:336",
			"RRA:MAX:0.5:60:744",
			"RRA:MAX:0.5:1440:365",
			"RRA:LAST:0.5:1:1440",
			"RRA:LAST:0.5:30:336",
			"RRA:LAST:0.5:60:744",
			"RRA:LAST:0.5:1440:365");
	}
}

# ==================================================
# 			UPDATE OPTION
# ==================================================

sub update {
	sleep(5);

	my ($min) = (localtime(time))[1];
	cpu();
	if(!($min % 5)) {
		disk();
	}
	net();
	if(!($min % 5)) {
		servu();
	}
	port();
	user();
	ints();
	if(scalar(@PC_LIST) != 0) {
		pc();
	}
	if($MACHINE eq "ML310") {
		temp_ML310();
	}
	elsif($MACHINE eq "ML330G3") {
		temp_ML350G3();
	}
	elsif($MACHINE eq "ML350G3") {
		temp_ML350G3();
	}
	elsif($MACHINE eq "ML570") {
		temp_ML570();
	}
}

sub cpu {
	my $LOAD1=`cat /proc/loadavg | awk -F " " '{ print \$1 }'`;
	my $LOAD5=`cat /proc/loadavg | awk -F " " '{ print \$2 }'`;
	my $LOAD15=`cat /proc/loadavg | awk -F " " '{ print \$3 }'`;
	
	my $NPROC=`cat /proc/loadavg | awk -F " " '{ print \$4 }' | awk -F "/" '{ print \$2 }'`;
	my $MBUF=`cat /proc/meminfo | grep "Buffers:" | awk -F " " '{ print \$2 }'`;
	my $MCAC=`cat /proc/meminfo | grep "Cached:" | head -1 | awk -F " " '{ print \$2 }'`;
	my $MFRE=`cat /proc/meminfo | grep "MemFree:" | awk -F " " '{ print \$2 }'`;
	my $rrdata="N";

	chomp($LOAD1);
	chomp($LOAD5);
	chomp($LOAD15);
	chomp($NPROC);
	chomp($MBUF);
	chomp($MCAC);
	chomp($MFRE);
	$rrdata .= ":$LOAD1:$LOAD5:$LOAD15:$NPROC:$MBUF:$MCAC:$MFRE";
	RRDs::update($CPU_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $CPU_RRD: $err\n" if $err;
}

sub disk {
	my $n;
	my $kernel_branch=`uname -r | awk -F '.' '{print \$1\".\"\$2}'`;
	my @MNT_TOTAL;
	my @MNT_USED;
	my @MNT_FREE;
	my $rrdata="N";
	my $root_disk;
	my $READ_CNT;
	my $READ_SEC;
	my $WRITE_CNT;
	my $WRITE_SEC;

	my $ROOT_TOTAL=`df / | grep / | awk -F " " '{ print \$2 }'`;
	my $ROOT_USED=`df / | grep / | awk -F " " '{ print \$3 }'`;
	my $ROOT_FREE=`df / | grep / | awk -F " " '{ print \$4 }'`;
	my $SWAP_TOTAL=`free | grep Swap | awk -F " " '{ print \$2 }'`;
	my $SWAP_USED=`free | grep Swap | awk -F " " '{ print \$3 }'`;
	my $SWAP_FREE=`free | grep Swap | awk -F " " '{ print \$4 }'`;

# We need to know exactly the name of the disk where the root filesystem
# resides. With a simple "df" command we only gets the partition name. That's
# why we need to make some steps before to obtain what we want.
# Only supports devices with one partition digit (hda3, sda9, etc.) not hda12.
# Fix this XXX.
	if($kernel_branch > 2.4) {
		$root_disk=`df / | grep / | awk -F " " '{ print \$1 }' | sed s'/.\$//'`;
		chomp($root_disk);
		$root_disk =~ s/.*\///;
		chomp($root_disk);
	}

	chomp($ROOT_TOTAL);
	chomp($ROOT_USED);
	chomp($ROOT_FREE);
	chomp($SWAP_TOTAL);
	chomp($SWAP_USED);
	chomp($SWAP_FREE);
	$rrdata .= ":$ROOT_TOTAL:$ROOT_USED:$ROOT_FREE:$SWAP_TOTAL:$SWAP_USED:$SWAP_FREE";
	for($n = 0; $n < 7 ; $n++) {
		$MNT_TOTAL[$n]=0;
		$MNT_USED[$n]=0;
		$MNT_FREE[$n]=0;
		if($n < scalar(@MNT_LIST)) {
			$MNT_TOTAL[$n]=`df $MNT_LIST[$n] | grep -s $MNT_LIST[$n] | awk -F " " '{ print \$2 }'`;
			$MNT_USED[$n]=`df $MNT_LIST[$n] | grep -s $MNT_LIST[$n] | awk -F " " '{ print \$3 }'`;
			$MNT_FREE[$n]=`df $MNT_LIST[$n] | grep -s $MNT_LIST[$n] | awk -F " " '{ print \$4 }'`;
		}
		chomp($MNT_TOTAL[$n]);
		chomp($MNT_USED[$n]);
		chomp($MNT_FREE[$n]);
		$rrdata .= ":$MNT_TOTAL[$n]:$MNT_USED[$n]:$MNT_FREE[$n]";
	}
	if($kernel_branch > 2.4) {
		$READ_CNT=`cat /proc/diskstats | grep -w $root_disk | awk -F " " '{ print \$4 }'`;
		$READ_SEC=`cat /proc/diskstats | grep -w $root_disk | awk -F " " '{ print \$6 }'`;
		$WRITE_CNT=`cat /proc/diskstats | grep -w $root_disk | awk -F " " '{ print \$8 }'`;
		$WRITE_SEC=`cat /proc/diskstats | grep -w $root_disk | awk -F " " '{ print \$10 }'`;
	} else {
		$READ_CNT=`cat /proc/stat | grep "disk_io" | awk -F " " '{ print \$NF }' | awk -F ":" '{ print \$NF }' | awk -F "," '{ print \$2 }'`;
		$READ_SEC=`cat /proc/stat | grep "disk_io" | awk -F " " '{ print \$NF }' | awk -F ":" '{ print \$NF }' | awk -F "," '{ print \$3 }'`;
		$WRITE_CNT=`cat /proc/stat | grep "disk_io" | awk -F " " '{ print \$NF }' | awk -F ":" '{ print \$NF }' | awk -F "," '{ print \$4 }'`;
		$WRITE_SEC=`cat /proc/stat | grep "disk_io" | awk -F " " '{ print \$NF }' | awk -F ":" '{ print \$NF }' | awk -F "," '{ print \$5 }' | awk -F ")" '{ print \$1 }'`;
	}

	chomp($READ_CNT);
	chomp($READ_SEC);
	chomp($WRITE_CNT);
	chomp($WRITE_SEC);
	$rrdata .= ":$READ_CNT:$READ_SEC:$WRITE_CNT:$WRITE_SEC";
	RRDs::update($DISK_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $DISK_RRD: $err\n" if $err;
}

sub net {
	my $n;
	my @NET_BYTES_IN;
	my @NET_BYTES_OUT;
	my @NET_PACKS_IN;
	my @NET_PACKS_OUT;
	my @NET_ERROR_IN;
	my @NET_ERROR_OUT;
	my $rrdata="N";

	for($n = 0; $n < 3 ; $n++) {
		$NET_BYTES_IN[$n]=0;
		$NET_BYTES_OUT[$n]=0;
		$NET_PACKS_IN[$n]=0;
		$NET_PACKS_OUT[$n]=0;
		$NET_ERROR_IN[$n]=0;
		$NET_ERROR_OUT[$n]=0;
		if($n < scalar(@NET_LIST)) {
			$NET_BYTES_IN[$n]=`cat /proc/net/dev | grep $NET_LIST[$n] | awk -F ":" '{ print \$2 }' | awk -F " " '{ print \$1 }'`;
			$NET_BYTES_OUT[$n]=`cat /proc/net/dev | grep $NET_LIST[$n] | awk -F ":" '{ print \$2 }' | awk -F " " '{ print \$9 }'`;
			$NET_PACKS_IN[$n]=`cat /proc/net/dev | grep $NET_LIST[$n] | awk -F ":" '{ print \$2 }' | awk -F " " '{ print \$2 }'`;
			$NET_PACKS_OUT[$n]=`cat /proc/net/dev | grep $NET_LIST[$n] | awk -F ":" '{ print \$2 }' | awk -F " " '{ print \$10 }'`;
			$NET_ERROR_IN[$n]=`cat /proc/net/dev | grep $NET_LIST[$n] | awk -F ":" '{ print \$2 }' | awk -F " " '{ print \$3 }'`;
			$NET_ERROR_OUT[$n]=`cat /proc/net/dev | grep $NET_LIST[$n] | awk -F ":" '{ print \$2 }' | awk -F " " '{ print \$11 }'`;
		}
		chomp($NET_BYTES_IN[$n]);
		chomp($NET_BYTES_OUT[$n]);
		chomp($NET_PACKS_IN[$n]);
		chomp($NET_PACKS_OUT[$n]);
		chomp($NET_ERROR_IN[$n]);
		chomp($NET_ERROR_OUT[$n]);
		$rrdata .= ":$NET_BYTES_IN[$n]:$NET_BYTES_OUT[$n]:$NET_PACKS_IN[$n]:$NET_PACKS_OUT[$n]:$NET_ERROR_IN[$n]:$NET_ERROR_OUT[$n]";
	}

	RRDs::update($NET_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $NET_RRD: $err\n" if $err;
}

sub servu {
	my $SECURE_LOG="/var/log/secure";
	my $MAIL_LOG="/var/log/maillog";
	my $HTTP_LOG="/var/log/httpd/access_log";
	my $FAX_LOG="/var/spool/hylafax/etc/xferfaxlog";
	my $SMBSTATUS=`which smbstatus 2>/dev/null`;
	chomp($SMBSTATUS);
	my $DATE_STR=`date '+\%b \%e'`;
	my $DATE_WWW=`date +\%d/\%b/\%Y`;
	my $DATE_FAX=`date +\%m/\%d/\%y`;
	chomp($DATE_STR);
	chomp($DATE_WWW);
	chomp($DATE_FAX);
	my $POP3=0;
	my $FTP=0;
	my $TELNET=0;
	my $SSH=0;
	my $SMTP=0;
	my $VIRUSMAIL=0;
	my $WWW=0;
	my $SMB=0;
	my $rrdata="N";

	if( -r $SECURE_LOG ) {
		open(LISTING, "< $SECURE_LOG");
		while(<LISTING>) {
			if(/$DATE_STR/) {
				if(/START: pop3/) {
					$POP3++;
				}
				if(/START: ftp/) {
					$FTP++;
				}
				if(/START: telnet/) {
					$TELNET++;
				}
				if(/sshd/ && /Accepted password/) {
					$SSH++;
				}
			}
		}
		close(LISTING);
	}

	if( -r $MAIL_LOG ) {
		open(LISTING, "< $MAIL_LOG");
		while(<LISTING>) {
			if(/$DATE_STR/) {
				if(/to=</ && /stat=Sent/) {
					$SMTP++;	
				}
				if(/to=virusmail/ && /stat=Sent/) {
					$VIRUSMAIL++;
				}
			}
		}
		close(LISTING);
	}

	if( -r $HTTP_LOG ) {
		open(LISTING, "< $HTTP_LOG");
		while(<LISTING>) {
			if(/$DATE_WWW/) {
				$WWW++;	
			}
		}
		close(LISTING);
	} else {
		print "can't read ", $HTTP_LOG, "\n";
	}

	if(stat($SMBSTATUS)) {
		my $SMB_L=0;
		my $SMB_S=0;
		if($SAMBAVER eq "2") {
        		$SMB_L=`$SMBSTATUS -L 2>/dev/null | wc -l`;
        		$SMB_L=$SMB_L - 5;
        		$SMB_S=`$SMBSTATUS -S 2>/dev/null | wc -l`;
        		$SMB_S=$SMB_S - 5;
		}
		elsif($SAMBAVER eq "3") {
        		$SMB_L=`$SMBSTATUS -L 2>/dev/null | wc -l`;
        		$SMB_L=$SMB_L - 4;
        		$SMB_S=`$SMBSTATUS -S 2>/dev/null | grep -iA 9999 "Service      pid     machine       Connected at" | wc -l`;
        		$SMB_S=$SMB_S - 2;
		}
        	$SMB=$SMB_L + $SMB_S;
	}

	my $FAX=0;
	if( -r $FAX_LOG ) {
		open(LISTING, "< $FAX_LOG");
		while(<LISTING>) {
			if(/$DATE_FAX/) {
				$FAX++;
			}
		}
		close(LISTING);
	}
	chomp($POP3);
	chomp($SMTP);
	chomp($SSH);
	chomp($FTP);
	chomp($TELNET);
	chomp($WWW);
	chomp($SMB);
	chomp($VIRUSMAIL);
	chomp($FAX);
	$rrdata .= ":$POP3:$SMTP:$SSH:$FTP:$TELNET:$WWW:$SMB:$VIRUSMAIL:$FAX";
	RRDs::update($SERVU_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $SERVU_RRD: $err\n" if $err;
}

sub port {
	my $PORT01_IN=`$IPTABLES -nvxL | grep PORT01_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT01_OUT=`$IPTABLES -nvxL | grep PORT01_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT02_IN=`$IPTABLES -nvxL | grep PORT02_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT02_OUT=`$IPTABLES -nvxL | grep PORT02_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT03_IN=`$IPTABLES -nvxL | grep PORT03_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT03_OUT=`$IPTABLES -nvxL | grep PORT03_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT04_IN=`$IPTABLES -nvxL | grep PORT04_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT04_OUT=`$IPTABLES -nvxL | grep PORT04_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT05_IN=`$IPTABLES -nvxL | grep PORT05_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT05_OUT=`$IPTABLES -nvxL | grep PORT05_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT06_IN=`$IPTABLES -nvxL | grep PORT06_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT06_OUT=`$IPTABLES -nvxL | grep PORT06_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT07_IN=`$IPTABLES -nvxL | grep PORT07_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT07_OUT=`$IPTABLES -nvxL | grep PORT07_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT08_IN=`$IPTABLES -nvxL | grep PORT08_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT08_OUT=`$IPTABLES -nvxL | grep PORT08_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT09_IN=`$IPTABLES -nvxL | grep PORT09_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT09_OUT=`$IPTABLES -nvxL | grep PORT09_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT10_IN=`$IPTABLES -nvxL | grep PORT10_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT10_OUT=`$IPTABLES -nvxL | grep PORT10_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT11_IN=`$IPTABLES -nvxL | grep PORT11_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT11_OUT=`$IPTABLES -nvxL | grep PORT11_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT12_IN=`$IPTABLES -nvxL | grep PORT12_IN | head -1 | awk -F " " '{ print \$2 }'`;
	my $PORT12_OUT=`$IPTABLES -nvxL | grep PORT12_OUT | head -1 | awk -F " " '{ print \$2 }'`;
	my $rrdata="N";

	chomp($PORT01_IN);
	chomp($PORT01_OUT);
	chomp($PORT02_IN);
	chomp($PORT02_OUT);
	chomp($PORT03_IN);
	chomp($PORT03_OUT);
	chomp($PORT04_IN);
	chomp($PORT04_OUT);
	chomp($PORT05_IN);
	chomp($PORT05_OUT);
	chomp($PORT06_IN);
	chomp($PORT06_OUT);
	chomp($PORT07_IN);
	chomp($PORT07_OUT);
	chomp($PORT08_IN);
	chomp($PORT08_OUT);
	chomp($PORT09_IN);
	chomp($PORT09_OUT);
	chomp($PORT10_IN);
	chomp($PORT10_OUT);
	chomp($PORT11_IN);
	chomp($PORT11_OUT);
	chomp($PORT12_IN);
	chomp($PORT12_OUT);
	$rrdata .= ":$PORT01_IN:$PORT01_OUT:$PORT02_IN:$PORT02_OUT:$PORT03_IN:$PORT03_OUT:$PORT04_IN:$PORT04_OUT:$PORT05_IN:$PORT05_OUT:$PORT06_IN:$PORT06_OUT:$PORT07_IN:$PORT07_OUT:$PORT08_IN:$PORT08_OUT:$PORT09_IN:$PORT09_OUT:$PORT10_IN:$PORT10_OUT:$PORT11_IN:$PORT11_OUT:$PORT12_IN:$PORT12_OUT";
	RRDs::update($PORT_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $PORT_RRD: $err\n" if $err;
}

sub user {
	my $SMB=0;
	my $MAC=0;
	my $SMBSTATUS=`which smbstatus 2>/dev/null`;
	chomp($SMBSTATUS);
	my $MACUSERS=`which macusers 2>/dev/null`;
	chomp($MACUSERS);
	my $USR=`who -q | grep users | sed 's/^.*=//'`;
	my $rrdata="N";

	if(stat($SMBSTATUS)) {
		if($SAMBAVER eq "2") {
			$SMB=`$SMBSTATUS -b 2>/dev/null | wc -l`;
			$SMB-=5;
		} elsif($SAMBAVER eq "3") {
			$SMB=`$SMBSTATUS -b 2>/dev/null | wc -l`;
			$SMB-=4;
		}
	}
	if(stat($MACUSERS)) {
		$MAC=`'$MACUSERS' | wc -l`;
		$MAC--;
	}

	chomp($USR);
	chomp($SMB);
	chomp($MAC);
	$rrdata .= ":$USR:$SMB:$MAC";
	RRDs::update($USER_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $USER_RRD: $err\n" if $err;
}

sub ints {
	my $INT0=`grep "intr" /proc/stat | awk -F " " '{ print \$3 }'`;
	my $INT1=`grep "intr" /proc/stat | awk -F " " '{ print \$4 }'`;
	my $INT2=`grep "intr" /proc/stat | awk -F " " '{ print \$5 }'`;
	my $INT3=`grep "intr" /proc/stat | awk -F " " '{ print \$6 }'`;
	my $INT4=`grep "intr" /proc/stat | awk -F " " '{ print \$7 }'`;
	my $INT5=`grep "intr" /proc/stat | awk -F " " '{ print \$8 }'`;
	my $INT6=`grep "intr" /proc/stat | awk -F " " '{ print \$9 }'`;
	my $INT7=`grep "intr" /proc/stat | awk -F " " '{ print \$10 }'`;
	my $INT8=`grep "intr" /proc/stat | awk -F " " '{ print \$11 }'`;
	my $INT9=`grep "intr" /proc/stat | awk -F " " '{ print \$12 }'`;
	my $INT10=`grep "intr" /proc/stat | awk -F " " '{ print \$13 }'`;
	my $INT11=`grep "intr" /proc/stat | awk -F " " '{ print \$14 }'`;
	my $INT12=`grep "intr" /proc/stat | awk -F " " '{ print \$15 }'`;
	my $INT13=`grep "intr" /proc/stat | awk -F " " '{ print \$16 }'`;
	my $INT14=`grep "intr" /proc/stat | awk -F " " '{ print \$17 }'`;
	my $INT15=`grep "intr" /proc/stat | awk -F " " '{ print \$18 }'`;
	my $rrdata="N";

	chomp($INT0);
	chomp($INT1);
	chomp($INT2);
	chomp($INT3);
	chomp($INT4);
	chomp($INT5);
	chomp($INT6);
	chomp($INT7);
	chomp($INT8);
	chomp($INT9);
	chomp($INT10);
	chomp($INT11);
	chomp($INT12);
	chomp($INT13);
	chomp($INT14);
	chomp($INT15);
	$rrdata .= ":$INT0:$INT1:$INT2:$INT3:$INT4:$INT5:$INT6:$INT7:$INT8:$INT9:$INT10:$INT11:$INT12:$INT13:$INT14:$INT15";
	RRDs::update($INT_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $INT_RRD: $err\n" if $err;
}

sub pc {
	my $n;
	my $ip;
	my @PC_BYTES_IN;
	my @PC_BYTES_OUT;
	my $rrdata="N";

	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		$PC_BYTES_IN[$n]=0;
		$PC_BYTES_OUT[$n]=0;
		if(!($ip = $PC_IP[$n])) {
			if(!(gethostbyname($PC_LIST[$n]))) {
				print "DNS problem with: ", $PC_LIST[$n], "\n";
			}
			$ip = inet_ntoa((gethostbyname($PC_LIST[$n]))[4]);
		}
		$PC_BYTES_IN[$n]=`$IPTABLES -nxvL | grep -A 3 "Chain $PC_LIST[$n]_total" | grep $ip | tail -1 | awk -F " " '{ print \$2 }'`;
		$PC_BYTES_OUT[$n]=`$IPTABLES -nxvL | grep -A 3 "Chain $PC_LIST[$n]_total" | grep $ip | head -1 | awk -F " " '{ print \$2 }'`;
		chomp($PC_BYTES_IN[$n]);
		chomp($PC_BYTES_OUT[$n]);
		$rrdata .= ":$PC_BYTES_IN[$n]:$PC_BYTES_OUT[$n]";
	}
	for(;$n < $PC_MAX; $n++) {
		$PC_BYTES_IN[$n]=0;
		$PC_BYTES_OUT[$n]=0;
		$rrdata .= ":$PC_BYTES_IN[$n]:$PC_BYTES_OUT[$n]";
	}
	RRDs::update($PC_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $PC_RRD: $err\n" if $err;
}

sub temp_ML310 {
	my $SB;
	my $CPU1;
	my $rrdata="N";

	if (-e "/proc/cpqtemp") {
		$SB=`cat /proc/cpqtemp | grep "System Board" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
		$CPU1=`cat /proc/cpqtemp | grep "CPU (1)" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
	} else {
		$SB=`/sbin/hplog -t | grep "System Board" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
		$CPU1=`/sbin/hplog -t | grep "CPU (1)" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
	}
        
	chomp($SB);
	chomp($CPU1);
	$rrdata .= ":$SB:$CPU1";
	RRDs::update($TEMP_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $TEMP_RRD: $err\n" if $err;
}

sub temp_ML350G3 {
	my $SB;
	my $CPU1;
	my $CPU2;
	my $rrdata="N";

	if (-e "/proc/cpqtemp") {
		$SB=`cat /proc/cpqtemp | grep "System Board" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
		$CPU1=`cat /proc/cpqtemp | grep "CPU (1)" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
		$CPU2=`cat /proc/cpqtemp | grep "CPU (2)" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
	} else {
		$SB=`/sbin/hplog -t | grep "System Board" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
		$CPU1=`/sbin/hplog -t | grep "CPU (1)" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
		$CPU2=`/sbin/hplog -t | grep "CPU (2)" | awk -F " " '{ print \$7 }' | sed s'/C//'`;
	}

	chomp($SB);
	chomp($CPU1);
	chomp($CPU2);
	$rrdata .= ":$SB:$CPU1:$CPU2";
	RRDs::update($TEMP_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $TEMP_RRD: $err\n" if $err;
}

sub temp_ML570 {
	my $CPU1;
	my $CPU2;
	my $CPU3;
	my $CPU4;
	my $SB1;
	my $SB2;
	my $SCS1;
	my $SCS2;
	my $rrdata="N";

	if (-e "/proc/cpqtemp") {
		$CPU1=`cat /proc/cpqtemp | grep "CPU (1)" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$CPU2=`cat /proc/cpqtemp | grep "CPU (2)" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$CPU3=`cat /proc/cpqtemp | grep "CPU (4)" | tr "-" " " | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$CPU4=`cat /proc/cpqtemp | grep "CPU (8)" | tr "-" " " | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$SB1=`cat /proc/cpqtemp | grep "5  LM75 Sensor" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$SB2=`cat /proc/cpqtemp | grep "6  LM75 Sensor" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$SCS1=`cat /proc/cpqtemp | grep "7  LM75 Sensor" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$SCS2=`cat /proc/cpqtemp | grep "8  LM75 Sensor" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
	} else {
		$CPU1=`/sbin/hplog -t | grep "CPU (1)" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$CPU2=`/sbin/hplog -t | grep "CPU (2)" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$CPU3=`/sbin/hplog -t | grep "CPU (4)" | tr "-" " " | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$CPU4=`/sbin/hplog -t | grep "CPU (8)" | tr "-" " " | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$SB1=`/sbin/hplog -t | grep "5  LM75 Sensor" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$SB2=`/sbin/hplog -t | grep "6  LM75 Sensor" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$SCS1=`/sbin/hplog -t | grep "7  LM75 Sensor" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
		$SCS2=`/sbin/hplog -t | grep "8  LM75 Sensor" | awk -F " " '{ print \$8 }' | sed s'/C.*\$//'`;
	}

	chomp($CPU1);
	chomp($CPU2);
	chomp($CPU3);
	chomp($CPU4);
	chomp($SB1);
	chomp($SB2);
	chomp($SCS1);
	chomp($SCS2);
	$rrdata .= ":$CPU1:$CPU2:$CPU3:$CPU4:$SB1:$SB2:$SCS1:$SCS2";
	RRDs::update($TEMP_RRD, $rrdata);
	my $err=RRDs::error;
	die "ERROR: while updating $TEMP_RRD: $err\n" if $err;
}

