#!/usr/bin/perl
#
# @(#) Fibranet NSP, SL
# Copyright (C) 2005 by Jordi Sanfeliu <admin@fibranet.com>
#
# Monitorix cgi for localhost and multihost.
#
use strict;
use warnings;
use RRDs;
use CGI qw/:standard/;

# external variables
our $CPU_RRD;
our $DISK_RRD;
our $NET_RRD;
our $SERVU_RRD;
our $PORT_RRD;
our $USER_RRD;
our $INT_RRD;
our $PC_RRD;
our $TEMP_RRD;

our $CPU1_RIGID;
our $CPU1_LIMIT;
our $CPU2_RIGID;
our $CPU2_LIMIT;
our $MEMORY;
our $DISK2_RIGID;
our $DISK2_LIMIT;
our $DISK3_RIGID;
our $DISK3_LIMIT;
our @MNT_LIST;
our @MNT_ACOL;
our @MNT_LCOL;
our @NET_LIST;
our @NET_TYPE;
our @NET_RIGID;
our @NET_LIMIT;
our $SERVU1_RIGID;
our $SERVU1_LIMIT;
our $SERVU2_RIGID;
our $SERVU2_LIMIT;
our $SERVU3_RIGID;
our $SERVU3_LIMIT;
our $PORT01_RIGID;
our $PORT01_LIMIT;
our $PORT02_RIGID;
our $PORT02_LIMIT;
our $PORT03_RIGID;
our $PORT03_LIMIT;
our $PORT04_RIGID;
our $PORT04_LIMIT;
our $PORT05_RIGID;
our $PORT05_LIMIT;
our $PORT06_RIGID;
our $PORT06_LIMIT;
our $PORT07_RIGID;
our $PORT07_LIMIT;
our $PORT08_RIGID;
our $PORT08_LIMIT;
our $PORT09_RIGID;
our $PORT09_LIMIT;
our $PORT10_RIGID;
our $PORT10_LIMIT;
our $PORT11_RIGID;
our $PORT11_LIMIT;
our $PORT12_RIGID;
our $PORT12_LIMIT;
our $USER1_RIGID;
our $USER1_LIMIT;
our $USER2_RIGID;
our $USER2_LIMIT;
our $USER3_RIGID;
our $USER3_LIMIT;
our $INT1_RIGID;
our $INT1_LIMIT;
our $INT2_RIGID;
our $INT2_LIMIT;
our $INT3_RIGID;
our $INT3_LIMIT;
our $INT0_NAME;
our $INT1_NAME;
our $INT2_NAME;
our $INT3_NAME;
our $INT4_NAME;
our $INT5_NAME;
our $INT6_NAME;
our $INT7_NAME;
our $INT8_NAME;
our $INT9_NAME;
our $INT10_NAME;
our $INT11_NAME;
our $INT12_NAME;
our $INT13_NAME;
our $INT14_NAME;
our $INT15_NAME;

our $PORT01_NAME;
our $PORT02_NAME;
our $PORT03_NAME;
our $PORT04_NAME;
our $PORT05_NAME;
our $PORT06_NAME;
our $PORT07_NAME;
our $PORT08_NAME;
our $PORT09_NAME;
our $PORT10_NAME;
our $PORT11_NAME;
our $PORT12_NAME;

our %GRAPH_TITLE;
our %GRAPHS;
our %BLACK;

our @PC_LIST;
our $TITLE;
our $HOSTNAME;
our $BASE_URL;
our $BASE_WWW;

our $MACHINE;
our $INETIF;

our $MULTIHOST_FOOTER;
our $MULTIHOST_IMGPERLINE;
our @SERV_LIST;

require "/etc/monitorix/monitorix.conf";

my $UPTIME=`uptime | sed 's/^.*up//' | sed 's/.....user.*\$//'`;
chomp($UPTIME);
if($RRDs::VERSION > 1.2) {
	$UPTIME =~ s/:/\\:/;	# escape colons to support RRDtool v1.2+
}
my $DATE=`date`;

if(!($HOSTNAME)) {
	$HOSTNAME=$ENV{SERVER_NAME};
}

my $when = param('when');
my $graph = param('graph');
my $color = param('color');
my $mode = param('mode');
my $val = param('val')		if(defined(param('val')));
my $silent = param('silent')	if(defined(param('silent')));
my $width="450";
my $height="150";
my $miniwidth="200";
my $miniheight="66";
my $portwidth="183";

our @graph_colors;
our $back_color = "#FFFFFF";
our $fore_color = "#000000";
our $title_back_color = "#777777";
our $title_fore_color = "#CCCC00";
our $graph_back_color = "#CCCCCC";
if(defined($color)) {
	if($color eq "black") {
		$graph_colors[0] = "--color=CANVAS" . $BLACK{canvas};
		$graph_colors[1] = "--color=BACK" . $BLACK{back};
		$graph_colors[2] = "--color=FONT" . $BLACK{font};
		$graph_colors[3] = "--color=MGRID" . $BLACK{mgrid};
		$graph_colors[4] = "--color=GRID" . $BLACK{grid};
		$graph_colors[5] = "--color=FRAME" . $BLACK{frame};
		$graph_colors[6] = "--color=ARROW" . $BLACK{arrow};
		$graph_colors[7] = "--color=SHADEA" . $BLACK{shadea};
		$graph_colors[8] = "--color=SHADEB" . $BLACK{shadeb};
		$back_color = "#000000";
		$fore_color = "#FFFFFF";
		$title_back_color = "#333333";
		$title_fore_color = "#888800";
		$graph_back_color = "#888888";
	}
}

my $u="";
if(defined($silent) && $silent eq "yes") {
	$u="_";
}

my $CPU1_PNG="/monitorix/imgs/" . $u . "cpu1.$when.png";
my $CPU2_PNG="/monitorix/imgs/" . $u . "cpu2.$when.png";
my $CPU3_PNG="/monitorix/imgs/" . $u . "cpu3.$when.png";
my $TEMP1_PNG="/monitorix/imgs/" . $u . "temp1.$when.png";
my $TEMP2_PNG="/monitorix/imgs/" . $u . "temp2.$when.png";
my $TEMP3_PNG="/monitorix/imgs/" . $u . "temp3.$when.png";
my $DISK1_PNG="/monitorix/imgs/" . $u . "disk1.$when.png";
my $DISK2_PNG="/monitorix/imgs/" . $u . "disk2.$when.png";
my $DISK3_PNG="/monitorix/imgs/" . $u . "disk3.$when.png";
my @NET1_PNG;
my @NET2_PNG;
my @NET3_PNG;
{
my $n;
for($n = 0; $n < scalar(@NET_LIST); $n++) {
	$NET1_PNG[$n]="/monitorix/imgs/" . $u . "net" . $n . "1.$when.png";
	$NET2_PNG[$n]="/monitorix/imgs/" . $u . "net" . $n . "2.$when.png";
	$NET3_PNG[$n]="/monitorix/imgs/" . $u . "net" . $n . "3.$when.png";
}
}
my $SERVU1_PNG="/monitorix/imgs/" . $u . "servu1.$when.png";
my $SERVU2_PNG="/monitorix/imgs/" . $u . "servu2.$when.png";
my $SERVU3_PNG="/monitorix/imgs/" . $u . "servu3.$when.png";
my $PORT01_PNG="/monitorix/imgs/" . $u . "port01.$when.png";
my $PORT02_PNG="/monitorix/imgs/" . $u . "port02.$when.png";
my $PORT03_PNG="/monitorix/imgs/" . $u . "port03.$when.png";
my $PORT04_PNG="/monitorix/imgs/" . $u . "port04.$when.png";
my $PORT05_PNG="/monitorix/imgs/" . $u . "port05.$when.png";
my $PORT06_PNG="/monitorix/imgs/" . $u . "port06.$when.png";
my $PORT07_PNG="/monitorix/imgs/" . $u . "port07.$when.png";
my $PORT08_PNG="/monitorix/imgs/" . $u . "port08.$when.png";
my $PORT09_PNG="/monitorix/imgs/" . $u . "port09.$when.png";
my $PORT10_PNG="/monitorix/imgs/" . $u . "port10.$when.png";
my $PORT11_PNG="/monitorix/imgs/" . $u . "port11.$when.png";
my $PORT12_PNG="/monitorix/imgs/" . $u . "port12.$when.png";
my $USER1_PNG="/monitorix/imgs/" . $u . "user1.$when.png";
my $USER2_PNG="/monitorix/imgs/" . $u . "user2.$when.png";
my $USER3_PNG="/monitorix/imgs/" . $u . "user3.$when.png";
my $INT1_PNG="/monitorix/imgs/" . $u . "int1.$when.png";
my $INT2_PNG="/monitorix/imgs/" . $u . "int2.$when.png";
my $INT3_PNG="/monitorix/imgs/" . $u . "int3.$when.png";
my @PC_PNG;
{
	my $n;
	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		$PC_PNG[$n]="/monitorix/imgs/pc" . ($n+1) . ".$when.png";
	}
}
my @PANO_PNG;
{
	my $n;
	for($n = 0; $n < scalar(@PC_LIST); $n++) {
		$PANO_PNG[$n]="/monitorix/imgs/pano" . ($n+1) . ".$when.png";
	}
}

my $inetpos;
{
	my $n;
	for($n = 0; $n < scalar(@NET_LIST); $n++) {
        	if($NET_LIST[$n] eq $INETIF) {
                	$inetpos=$n;
		}
        }
}

sub image_header {
	my $title = $_[0];
	my $colspan = $_[1];
	print "  <TABLE CELLSPACING=5 CELLPADDING=0 WIDTH=1 BGCOLOR=" . $graph_back_color . " BORDER=1>\n";
	print "  <TR>\n";
	print "  <TD BGCOLOR=" . $title_back_color . " COLSPAN=$colspan>\n";
	print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $title_fore_color . ">\n";
	print "    <B>&nbsp;&nbsp;$title<B>\n";
	print "  </FONT>\n";
	print "  </TD>\n";
	print "  </TR>\n";
	print "  <TR>\n";
	print "  <TD>\n";
}
sub image_footer {
	print "  </TD>\n";
	print "  </TR>\n";
	print "  </TABLE>\n";
}

print "Content-Type: text/html\n";
print "\n";
if(!defined($silent)) {
	my $title;

	print "<HTML>\n";
	print "  <HEAD>\n";
	print "    <TITLE>$TITLE</TITLE>\n";
	print "    <META HTTP-EQUIV=Refresh CONTENT=150>\n";
	print "  </HEAD>\n";
	print "  <BODY BGCOLOR=" . $back_color . ">\n";
	print "  <CENTER>\n";
	print "  <TABLE CELLSPACING=5 CELLPADDING=0 WIDTH=1 BGCOLOR=" . $graph_back_color . " BORDER=1>\n";
	print "  <TR>\n";
	if($val ne "all" && $mode ne "multihost") {
		print "  <TD BGCOLOR=" . $title_back_color . ">\n";
		print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $title_fore_color . ">\n";
		print "    <FONT SIZE=5><B>&nbsp;&nbsp;Host:&nbsp;<B></FONT>\n";
		print "  </FONT>\n";
		print "  </TD>\n";
	}
	print "  <TD BGCOLOR=" . $back_color . ">\n";
	print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $fore_color . ">\n";
	if($mode eq "localhost" || $mode eq "pc") {
		$title = $HOSTNAME;
	} elsif($mode eq "multihost") {
		my %rgraphs = reverse %GRAPHS;
		$graph = !$graph ? "_cpu1" : $graph;
		$title = $rgraphs{$graph};
	}
	$title =~ s/ /&nbsp;/g;
	print "    <FONT SIZE=5><B>&nbsp;&nbsp;$title&nbsp;&nbsp;</B></FONT>\n";
	print "  </TD>\n";
	print "  </TR>\n";
	print "  </TABLE>";
	print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $fore_color . ">\n";
	print "  <H2><FONT COLOR=888800>(last $when)</FONT></H2>\n";
	print "  <H5><FONT COLOR=888888>\n";
	print $DATE;
	print "  </FONT></H5>\n";
}
if(($mode eq "localhost") || ($silent)) {
	my $TITLE_CPU=$GRAPH_TITLE{cpu};
	my $TITLE_TEMP=$MACHINE . " " . $GRAPH_TITLE{temp};
	my $TITLE_DISK=$GRAPH_TITLE{disk};
	my $TITLE_NET=$GRAPH_TITLE{net};
	my $TITLE_SERVU=$GRAPH_TITLE{servu};
	my $TITLE_PORT1=$GRAPH_TITLE{port} . " (1/2)";
	my $TITLE_PORT2=$GRAPH_TITLE{port} . " (2/2)";
	my $TITLE_USER=$GRAPH_TITLE{user};
	my $TITLE_INT=$GRAPH_TITLE{int};
	if($silent) {
		$TITLE_CPU="";
		$TITLE_TEMP="";
		$TITLE_DISK="";
		$TITLE_NET="";
		$TITLE_SERVU="";
		$TITLE_PORT1="";
		$TITLE_PORT2="";
		$TITLE_USER="";
		$TITLE_INT="";
		$width="300";
		$height="100";
		$miniwidth="300";
		$miniheight="100";
		$portwidth="300";
	}
	if(!$graph || $graph =~ /cpu/) {
		cpu_stats($TITLE_CPU);
		print "  <BR>\n";
	}
	if($MACHINE eq "ML310") {
		if(!$graph || $graph =~ /temp/) {
			temp_ML310($TITLE_TEMP);
			print "  <BR>\n";
		}
	}
	elsif($MACHINE eq "ML330G3") {
		if(!$graph || $graph =~ /temp/) {
			temp_ML350G3($TITLE_TEMP);
			print "  <BR>\n";
		}
	}
	elsif($MACHINE eq "ML350G3") {
		if(!$graph || $graph =~ /temp/) {
			temp_ML350G3($TITLE_TEMP);
			print "  <BR>\n";
		}
	}
	elsif($MACHINE eq "ML570") {
		if(!$graph || $graph =~ /temp/) {
			temp_ML570($TITLE_TEMP);
			print "  <BR>\n";
		}
	}
	if(!$graph || $graph =~ /disk/) {
		disk_stats($TITLE_DISK);
		print "  <BR>\n";
	}
	if(!$graph || $graph =~ /net/) {
		net_stats($TITLE_NET);
	}
	if(!$graph || $graph =~ /serv/) {
		servu_stats($TITLE_SERVU);
		print "  <BR>\n";
	}
	if(!$graph || $graph =~ /port/) {
		if(($graph eq "_port01") || ($graph eq "_port02") ||
		($graph eq "_port03") || ($graph eq "_port04") ||
		($graph eq "_port05") || ($graph eq "_port06") ||
		(!$graph)) {
			port1_stats($TITLE_PORT1);
			print "  <BR>\n";
		}
	}
	if(!$graph || $graph =~ /port/) {
		if(($graph eq "_port07") || ($graph eq "_port08") ||
		($graph eq "_port09") || ($graph eq "_port10") ||
		($graph eq "_port11") || ($graph eq "_port12") ||
		(!$graph)) {
			port2_stats($TITLE_PORT2);
			print "  <BR>\n";
		}
	}
	if(!$graph || $graph =~ /user/) {
		user_stats($TITLE_USER);
		print "  <BR>\n";
	}
	if(!$graph || $graph =~ /int/) {
		int_stats($TITLE_INT);
		print "  <BR>\n";
	}
} elsif($mode eq "multihost") {
	multihost_stats();
} else {
	if($val eq "all") {
		panoramic_stats();
	} else {
		pc_stats();
	}
}

if(!defined($silent)) {
	print "  </FONT>\n";
	print "  </CENTER>\n";
	print "  </BODY>\n";
	print "  <P>\n";
	print "  <A HREF=http://www.monitorix.org><IMG SRC=/monitorix/logo_bot.jpg BORDER=0></A>\n";
	print "  <BR>\n";
	print "  <A HREF=MAILTO:info\@monitorix.org><IMG SRC=/monitorix/envelope.png BORDER=0></A>\n";
	print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $fore_color . " SIZE=-2>\n";
	print "Copyright 2005 &copy; Fibranet NSP, SL\n";
	print "  </FONT>\n";
	print "<HTML>\n";
}
exit(0);


sub cpu_stats {
	my @tmp;
	my @tmp2;
	if($_[0]) {
		image_header($_[0], 2);
		$tmp2[0] = "COMMENT:\\n";
		$tmp2[1] = "GPRINT:lcpu1:LAST: 1 minute average    Current\\: %2.2lf";
		$tmp2[2] = "GPRINT:lcpu1:AVERAGE:   Average\\: %2.2lf";
		$tmp2[3] = "GPRINT:lcpu1:MIN:   Min\\: %2.2lf";
		$tmp2[4] = "GPRINT:lcpu1:MAX:   Max\\: %2.2lf\\n";
		$tmp2[5] = "GPRINT:lcpu5:LAST: 5 minute average    Current\\: %2.2lf";
		$tmp2[6] = "GPRINT:lcpu5:AVERAGE:   Average\\: %2.2lf";
		$tmp2[7] = "GPRINT:lcpu5:MIN:   Min\\: %2.2lf";
		$tmp2[8] = "GPRINT:lcpu5:MAX:   Max\\: %2.2lf\\n";
		$tmp2[9] = "GPRINT:lcpu15:LAST:15 minute average    Current\\: %2.2lf";
		$tmp2[10] = "GPRINT:lcpu15:AVERAGE:   Average\\: %2.2lf";
		$tmp2[11] = "GPRINT:lcpu15:MIN:   Min\\: %2.2lf";
		$tmp2[12] = "GPRINT:lcpu15:MAX:   Max\\: %2.2lf\\n";
	}
	unlink ("$BASE_WWW$CPU1_PNG",
		"$BASE_WWW$CPU2_PNG",
		"$BASE_WWW$CPU3_PNG");
	if ($CPU1_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$CPU1_LIMIT";
		$tmp[1] = "--lower-limit=0";
	} else {
		if ($CPU1_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$CPU1_LIMIT";
			$tmp[1] = "--lower-limit=0";
			$tmp[2] = "--rigid";
		}
	}
	my $UPTIMELINE;
	if($RRDs::VERSION > 1.2) {
		$UPTIMELINE = "COMMENT:system uptime\\: " . $UPTIME . "\\c";
	} else {
		$UPTIMELINE = "COMMENT:system uptime: " . $UPTIME . "\\c";
	}
	RRDs::graph("$BASE_WWW$CPU1_PNG",
		"--title=CPU load average  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Load average",
		"--width=$width",
		"--height=$height",
		@tmp,
		@graph_colors,
		"DEF:lcpu1=$CPU_RRD:cpu_load1:AVERAGE",
		"DEF:lcpu5=$CPU_RRD:cpu_load5:AVERAGE",
		"DEF:lcpu15=$CPU_RRD:cpu_load15:AVERAGE",
		"AREA:lcpu1#4444EE:1 minute average",
			"LINE1:lcpu1#0000EE",
			"LINE1:lcpu5#EEEE00:5 minute average",
			"LINE1:lcpu15#00EEEE:15 minute average",
		"COMMENT:\\n",
		@tmp2,
		"COMMENT:\\n",
		$UPTIMELINE);
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$CPU1_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	my @tmp3;
	if ($CPU2_RIGID eq 1) {
		$tmp3[0] = "--upper-limit=$CPU2_LIMIT";
		$tmp3[1] = "--lower-limit=0";
	} else {
		if ($CPU2_RIGID eq 2) {
			$tmp3[0] = "--upper-limit=$CPU2_LIMIT";
			$tmp3[1] = "--lower-limit=0";
			$tmp3[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$CPU2_PNG",
		"--title=Active processes  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Processes/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		@tmp3,
		@graph_colors,
		"DEF:nproc=$CPU_RRD:cpu_nproc:AVERAGE",
		"AREA:nproc#44EEEE:Number of processes",
			"LINE1:nproc#00EEEE",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:nproc:LAST:nprocs   Cur\\:%2.0lf",
		"GPRINT:nproc:AVERAGE: Avg\\:%2.0lf",
		"GPRINT:nproc:MIN: Min\\:%2.0lf",
		"GPRINT:nproc:MAX: Max\\:%2.0lf\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$CPU2_PNG>\n";
	}
	RRDs::graph("$BASE_WWW$CPU3_PNG",
		"--title=Memory allocation of ${MEMORY}MB  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Megabytes",
		"--width=$miniwidth",
		"--height=$miniheight",
		"--upper-limit=$MEMORY",
		"--lower-limit=0",
		"--rigid",
		@graph_colors,
		"DEF:mbuff=$CPU_RRD:cpu_mbuff:AVERAGE",
		"DEF:mcach=$CPU_RRD:cpu_mcach:AVERAGE",
		"DEF:mfree=$CPU_RRD:cpu_mfree:AVERAGE",
		"CDEF:m_mbuff=mbuff,1024,/",
		"CDEF:m_mcach=mcach,1024,/",
		"CDEF:m_mused=$MEMORY,mfree,1024,/,-",
		"AREA:m_mused#EE4444:Used",
		"AREA:m_mcach#44EE44:Cached",
		"AREA:m_mbuff#CCCCCC:Buffers",
			"LINE1:m_mbuff#888888",
			"LINE1:m_mcach#00EE00",
			"LINE1:m_mused#EE0000");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$CPU3_PNG>\n";
		image_footer();
	}
}

sub temp_ML310 {
	my @tmp;
	if($_[0]) {
		image_header($_[0], 2);
		$tmp[0] = "COMMENT:\\n",
		$tmp[1] = "COMMENT:\\n",
		$tmp[2] = "GPRINT:tcpu1:LAST: CPU 1               Current\\: %2.0lf",
		$tmp[3] = "GPRINT:tcpu1:AVERAGE:   Average\\: %2.0lf",
		$tmp[4] = "GPRINT:tcpu1:MIN:   Min\\: %2.0lf",
		$tmp[5] = "GPRINT:tcpu1:MAX:   Max\\: %2.0lf\\n",
		$tmp[6] = "COMMENT:\\n",
		$tmp[7] = "COMMENT:\\n",
	}
	unlink ("$BASE_WWW$TEMP1_PNG",
		"$BASE_WWW$TEMP2_PNG",
		"$BASE_WWW$TEMP3_PNG");
	RRDs::graph("$BASE_WWW$TEMP1_PNG",
		"--title=CPU temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=C",
		"--width=$width",
		"--height=$height",
		@graph_colors,
		"DEF:tsb=$TEMP_RRD:sb:AVERAGE",
		"DEF:tcpu1=$TEMP_RRD:cpu1:AVERAGE",
		"AREA:tcpu1#4444EE:",
			"LINE1:tcpu1#0000EE:CPU 1",
		@tmp,
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$TEMP1_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	RRDs::graph("$BASE_WWW$TEMP2_PNG",
		"--title=System board temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=C",
		"--width=$miniwidth",
		"--height=$miniheight",
		@graph_colors,
		"DEF:tsb=$TEMP_RRD:sb:AVERAGE",
		"AREA:tsb#44EEEE:System board",
			"LINE1:tsb#00EEEE",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:tsb:LAST:SB       Cur\\:%2.0lf",
		"GPRINT:tsb:AVERAGE: Avg\\:%2.0lf",
		"GPRINT:tsb:MIN: Min\\:%2.0lf",
		"GPRINT:tsb:MAX: Max\\:%2.0lf\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$TEMP2_PNG>\n";
	}
	RRDs::graph("$BASE_WWW$TEMP3_PNG",
		"--imgformat=PNG",
		"--width=$miniwidth",
		"--height=$miniheight",
		@graph_colors,
		"COMMENT:");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$TEMP3_PNG>\n";
		image_footer();
	}
}

sub temp_ML350G3 {
	my @tmp;
	if($_[0]) {
		image_header($_[0], 2);
		$tmp[0] = "COMMENT:\\n",
		$tmp[1] = "COMMENT:\\n",
		$tmp[2] = "GPRINT:tcpu1:LAST: CPU 1               Current\\: %2.0lf",
		$tmp[3] = "GPRINT:tcpu1:AVERAGE:   Average\\: %2.0lf",
		$tmp[4] = "GPRINT:tcpu1:MIN:   Min\\: %2.0lf",
		$tmp[5] = "GPRINT:tcpu1:MAX:   Max\\: %2.0lf\\n",
		$tmp[6] = "GPRINT:tcpu2:LAST: CPU 2               Current\\: %2.0lf",
		$tmp[7] = "GPRINT:tcpu2:AVERAGE:   Average\\: %2.0lf",
		$tmp[8] = "GPRINT:tcpu2:MIN:   Min\\: %2.0lf",
		$tmp[9] = "GPRINT:tcpu2:MAX:   Max\\: %2.0lf\\n",
		$tmp[10] = "COMMENT:\\n",
	}
	unlink ("$BASE_WWW$TEMP1_PNG",
		"$BASE_WWW$TEMP2_PNG",
		"$BASE_WWW$TEMP3_PNG");
	RRDs::graph("$BASE_WWW$TEMP1_PNG",
		"--title=CPU temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=C",
		"--width=$width",
		"--height=$height",
		@graph_colors,
		"DEF:tsb=$TEMP_RRD:sb:AVERAGE",
		"DEF:tcpu1=$TEMP_RRD:cpu1:AVERAGE",
		"DEF:tcpu2=$TEMP_RRD:cpu2:AVERAGE",
		"AREA:tcpu1#4444EE:",
		"AREA:tcpu2#44EEEE:",
			"LINE1:tcpu1#0000EE:CPU 1",
			"LINE1:tcpu2#00EEEE:CPU 2",
		@tmp,
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$TEMP1_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	RRDs::graph("$BASE_WWW$TEMP2_PNG",
		"--title=System board temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=C",
		"--width=$miniwidth",
		"--height=$miniheight",
		@graph_colors,
		"DEF:tsb=$TEMP_RRD:sb:AVERAGE",
		"AREA:tsb#44EEEE:System board",
			"LINE1:tsb#00EEEE",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:tsb:LAST:SB       Cur\\:%2.0lf",
		"GPRINT:tsb:AVERAGE: Avg\\:%2.0lf",
		"GPRINT:tsb:MIN: Min\\:%2.0lf",
		"GPRINT:tsb:MAX: Max\\:%2.0lf\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$TEMP2_PNG>\n";
	}
	RRDs::graph("$BASE_WWW$TEMP3_PNG",
		"--imgformat=PNG",
		"--width=$miniwidth",
		"--height=$miniheight",
		@graph_colors,
		"COMMENT:");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$TEMP3_PNG>\n";
		image_footer();
	}
}

sub temp_ML570 {
	my @tmp;
	if($_[0]) {
		image_header($_[0], 2);
		$tmp[0] = "COMMENT:\\n",
		$tmp[1] = "COMMENT:\\n",
		$tmp[2] = "GPRINT:tcpu1:LAST: CPU 1               Current\\: %2.0lf",
		$tmp[3] = "GPRINT:tcpu1:AVERAGE:   Average\\: %2.0lf",
		$tmp[4] = "GPRINT:tcpu1:MIN:   Min\\: %2.0lf",
		$tmp[5] = "GPRINT:tcpu1:MAX:   Max\\: %2.0lf\\n",
		$tmp[6] = "GPRINT:tcpu2:LAST: CPU 2               Current\\: %2.0lf",
		$tmp[7] = "GPRINT:tcpu2:AVERAGE:   Average\\: %2.0lf",
		$tmp[8] = "GPRINT:tcpu2:MIN:   Min\\: %2.0lf",
		$tmp[9] = "GPRINT:tcpu2:MAX:   Max\\: %2.0lf\\n",
		$tmp[10] = "GPRINT:tcpu3:LAST: CPU 3               Current\\: %2.0lf",
		$tmp[11] = "GPRINT:tcpu3:AVERAGE:   Average\\: %2.0lf",
		$tmp[12] = "GPRINT:tcpu3:MIN:   Min\\: %2.0lf",
		$tmp[13] = "GPRINT:tcpu3:MAX:   Max\\: %2.0lf\\n",
		$tmp[14] = "GPRINT:tcpu4:LAST: CPU 4               Current\\: %2.0lf",
		$tmp[15] = "GPRINT:tcpu4:AVERAGE:   Average\\: %2.0lf",
		$tmp[16] = "GPRINT:tcpu4:MIN:   Min\\: %2.0lf",
		$tmp[17] = "GPRINT:tcpu4:MAX:   Max\\: %2.0lf\\n",
		$tmp[18] = "COMMENT:\\n",
		$tmp[19] = "COMMENT:\\n",
		$tmp[20] = "COMMENT:\\n",
		$tmp[21] = "COMMENT:\\n",
	}
	unlink ("$BASE_WWW$TEMP1_PNG",
		"$BASE_WWW$TEMP2_PNG",
		"$BASE_WWW$TEMP3_PNG");
	RRDs::graph("$BASE_WWW$TEMP1_PNG",
		"--title=CPU temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=C",
		"--width=$width",
		"--height=$height",
		@graph_colors,
		"DEF:tcpu1=$TEMP_RRD:cpu1:AVERAGE",
		"DEF:tcpu2=$TEMP_RRD:cpu2:AVERAGE",
		"DEF:tcpu3=$TEMP_RRD:cpu3:AVERAGE",
		"DEF:tcpu4=$TEMP_RRD:cpu4:AVERAGE",
		"AREA:tcpu1#4444EE:",
		"AREA:tcpu2#44EEEE:",
		"AREA:tcpu3#44EE44:",
		"AREA:tcpu4#EEEE44:",
			"LINE1:tcpu1#0000EE:CPU 1",
			"LINE1:tcpu2#00EEEE:CPU 2",
			"LINE1:tcpu3#00EE00:CPU 3",
			"LINE1:tcpu4#EEEE00:CPU 4",
		@tmp,
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$TEMP1_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	RRDs::graph("$BASE_WWW$TEMP2_PNG",
		"--title=System board temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=C",
		"--width=$miniwidth",
		"--height=$miniheight",
		@graph_colors,
		"DEF:tsb1=$TEMP_RRD:sb1:AVERAGE",
		"DEF:tsb2=$TEMP_RRD:sb2:AVERAGE",
		"AREA:tsb1#4444EE:",
		"AREA:tsb2#44EEEE:",
			"LINE1:tsb1#0000EE:System board 1",
			"LINE1:tsb2#00EEEE:System board 2",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:tsb1:LAST:SB 1     Cur\\:%2.0lf",
		"GPRINT:tsb1:AVERAGE: Avg\\:%2.0lf",
		"GPRINT:tsb1:MIN: Min\\:%2.0lf",
		"GPRINT:tsb1:MAX: Max\\:%2.0lf\\n",
		"GPRINT:tsb2:LAST:SB 2     Cur\\:%2.0lf",
		"GPRINT:tsb2:AVERAGE: Avg\\:%2.0lf",
		"GPRINT:tsb2:MIN: Min\\:%2.0lf",
		"GPRINT:tsb2:MAX: Max\\:%2.0lf\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$TEMP2_PNG>\n";
	}
	RRDs::graph("$BASE_WWW$TEMP3_PNG",
		"--title=SCSI backplane temperatures  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=C",
		"--width=$miniwidth",
		"--height=$miniheight",
		@graph_colors,
		"DEF:tscsi1=$TEMP_RRD:scsi1:AVERAGE",
		"DEF:tscsi2=$TEMP_RRD:scsi2:AVERAGE",
		"AREA:tscsi1#4444EE:",
		"AREA:tscsi2#44EEEE:",
			"LINE1:tscsi1#0000EE:SCSI backplane 1",
			"LINE1:tscsi2#00EEEE:SCSI backplane 2",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:tscsi1:LAST:SCSI B1  Cur\\:%2.0lf",
		"GPRINT:tscsi1:AVERAGE: Avg\\:%2.0lf",
		"GPRINT:tscsi1:MIN: Min\\:%2.0lf",
		"GPRINT:tscsi1:MAX: Max\\:%2.0lf\\n",
		"GPRINT:tscsi2:LAST:SCSI B2  Cur\\:%2.0lf",
		"GPRINT:tscsi2:AVERAGE: Avg\\:%2.0lf",
		"GPRINT:tscsi2:MIN: Min\\:%2.0lf",
		"GPRINT:tscsi2:MAX: Max\\:%2.0lf\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$TEMP3_PNG>\n";
		image_footer();
	}
}

sub disk_stats {
	my $n;
	my $n1;
	my $n2;
	my $n3;
	my @DEF_AVG;
	my @DEF_LAS;
	my @DEF_MIN;
	my @DEF_MAX;
	my @CDEF_AVG;
	my @CDEF_LAS;
	my @CDEF_MIN;
	my @CDEF_MAX;
	my @LINE2;
	my @AREA;
	my @GPRINT_ALL;
	my @COMMENT;
	my @tmp;
	if($_[0]) {
		image_header($_[0], 2);
		$tmp[0] = "COMMENT:\\n",
		$tmp[1] = "COMMENT:\\n",
		$tmp[2] = "GPRINT:root_pla:LAST:/                    Current\\: %4.1lf%%",
		$tmp[3] = "GPRINT:root_pav:AVERAGE:   Average\\: %4.1lf%%",
		$tmp[4] = "GPRINT:root_pmi:MIN:   Min\\: %4.1lf%%",
		$tmp[5] = "GPRINT:root_pma:MAX:   Max\\: %4.1lf%%\\n",
		$tmp[6] = "GPRINT:swap_pla:LAST:swap                 Current\\: %4.1lf%%",
		$tmp[7] = "GPRINT:swap_pav:AVERAGE:   Average\\: %4.1lf%%",
		$tmp[8] = "GPRINT:swap_pmi:MIN:   Min\\: %4.1lf%%",
		$tmp[9] = "GPRINT:swap_pma:MAX:   Max\\: %4.1lf%%\\n",
	}
	unlink ("$BASE_WWW$DISK1_PNG",
		"$BASE_WWW$DISK2_PNG",
		"$BASE_WWW$DISK3_PNG");
	for($n = $n2 = $n3 = 0, $n1 = 1; $n < scalar(@MNT_LIST) && $n1 < 8; $n++, $n1++, $n2 = $n2 + 2, $n3 = $n3 + 4) {
		$DEF_AVG[$n2] = "DEF:mnt" . $n1 . "_used_av=$DISK_RRD:mnt" . $n1 . "_used:AVERAGE";
		$DEF_AVG[$n2 + 1] = "DEF:mnt" . $n1 . "_free_av=$DISK_RRD:mnt" . $n1 . "_free:AVERAGE";
		$DEF_LAS[$n2] = "DEF:mnt" . $n1 . "_used_la=$DISK_RRD:mnt" . $n1 . "_used:LAST";
		$DEF_LAS[$n2 + 1] = "DEF:mnt" . $n1 . "_free_la=$DISK_RRD:mnt" . $n1 . "_free:LAST";
		$DEF_MIN[$n2] = "DEF:mnt" . $n1 . "_used_mi=$DISK_RRD:mnt" . $n1 . "_used:MIN";
		$DEF_MIN[$n2 + 1] = "DEF:mnt" . $n1 . "_free_mi=$DISK_RRD:mnt" . $n1 . "_free:MIN";
		$DEF_MAX[$n2] = "DEF:mnt" . $n1 . "_used_ma=$DISK_RRD:mnt" . $n1 . "_used:MAX";
		$DEF_MAX[$n2 + 1] = "DEF:mnt" . $n1 . "_free_ma=$DISK_RRD:mnt" . $n1 . "_free:MAX";

		$CDEF_AVG[$n] = "CDEF:mnt" . $n1 . "_pav=mnt" . $n1 . "_used_av,100,*,mnt" . $n1 . "_used_av,mnt" . $n1 . "_free_av,+,/";
		$CDEF_LAS[$n] = "CDEF:mnt" . $n1 . "_pla=mnt" . $n1 . "_used_la,100,*,mnt" . $n1 . "_used_la,mnt" . $n1 . "_free_la,+,/";
		$CDEF_MIN[$n] = "CDEF:mnt" . $n1 . "_pmi=mnt" . $n1 . "_used_mi,100,*,mnt" . $n1 . "_used_mi,mnt" . $n1 . "_free_mi,+,/";
		$CDEF_MAX[$n] = "CDEF:mnt" . $n1 . "_pma=mnt" . $n1 . "_used_ma,100,*,mnt" . $n1 . "_used_ma,mnt" . $n1 . "_free_ma,+,/";

		{
			my $tmp = $MNT_LIST[$n];
			$tmp =~ s/\s+$//;	# remove trailing whitespaces
		$LINE2[$n] = "LINE2:mnt" . $n1 . "_pav" . $MNT_LCOL[$n] . ":" . $tmp;
		}

		if($_[0]) {
			$GPRINT_ALL[$n3] = "GPRINT:mnt" . $n1 . "_pla:LAST:" . $MNT_LIST[$n] . "   Current\\: %4.1lf%%";
			$GPRINT_ALL[$n3 + 1] = "GPRINT:mnt" . $n1 . "_pav:AVERAGE:   Average\\: %4.1lf%%";
			$GPRINT_ALL[$n3 + 2] = "GPRINT:mnt" . $n1 . "_pmi:MIN:   Min\\: %4.1lf%%";
			$GPRINT_ALL[$n3 + 3] = "GPRINT:mnt" . $n1 . "_pma:MAX:   Max\\: %4.1lf%%\\n";
		}
	}
	if($_[0]) {
		for($n2 = 0, $n = $n1; $n < 8; $n++, $n2++) {
			$COMMENT[$n2]="COMMENT:\\n";
		}
	}
	for($n2 = 0, $n = scalar(@MNT_LIST); $n > 0; $n--, $n2++) {
		$n1 = $n - 1;
		$AREA[$n2] = "AREA:mnt" . $n . "_pav" . $MNT_ACOL[$n1];
	}
	RRDs::graph("$BASE_WWW$DISK1_PNG",
		"--title=Disk usage  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Percent (%)",
		"--width=$width",
		"--height=$height",
		"--upper-limit=100",
		"--lower-limit=0",
		"--rigid",
		@graph_colors,
		"DEF:root_used_av=$DISK_RRD:root_used:AVERAGE",
		"DEF:root_free_av=$DISK_RRD:root_free:AVERAGE",
		"DEF:swap_used_av=$DISK_RRD:swap_used:AVERAGE",
		"DEF:swap_free_av=$DISK_RRD:swap_free:AVERAGE",
		@DEF_AVG,
		"DEF:root_used_la=$DISK_RRD:root_used:LAST",
		"DEF:root_free_la=$DISK_RRD:root_free:LAST",
		"DEF:swap_used_la=$DISK_RRD:swap_used:LAST",
		"DEF:swap_free_la=$DISK_RRD:swap_free:LAST",
		@DEF_LAS,
		"DEF:root_used_mi=$DISK_RRD:root_used:MIN",
		"DEF:root_free_mi=$DISK_RRD:root_free:MIN",
		"DEF:swap_used_mi=$DISK_RRD:swap_used:MIN",
		"DEF:swap_free_mi=$DISK_RRD:swap_free:MIN",
		@DEF_MIN,
		"DEF:root_used_ma=$DISK_RRD:root_used:MAX",
		"DEF:root_free_ma=$DISK_RRD:root_free:MAX",
		"DEF:swap_used_ma=$DISK_RRD:swap_used:MAX",
		"DEF:swap_free_ma=$DISK_RRD:swap_free:MAX",
		@DEF_MAX,
		"CDEF:root_pav=root_used_av,100,*,root_used_av,root_free_av,+,/",
		"CDEF:root_pla=root_used_la,100,*,root_used_la,root_free_la,+,/",
		"CDEF:root_pmi=root_used_mi,100,*,root_used_mi,root_free_mi,+,/",
		"CDEF:root_pma=root_used_ma,100,*,root_used_ma,root_free_ma,+,/",
		"CDEF:swap_pav=swap_used_av,100,*,swap_used_av,swap_free_av,+,/",
		"CDEF:swap_pla=swap_used_la,100,*,swap_used_la,swap_free_la,+,/",
		"CDEF:swap_pmi=swap_used_mi,100,*,swap_used_mi,swap_free_mi,+,/",
		"CDEF:swap_pma=swap_used_ma,100,*,swap_used_ma,swap_free_ma,+,/",
        	@CDEF_AVG,
        	@CDEF_LAS,
        	@CDEF_MIN,
        	@CDEF_MAX,
		@AREA,
		"AREA:root_pav#EE4444",
			"LINE2:root_pav#EE0000:/",
			"LINE2:swap_pav#EEEEEE:swap",
			@LINE2,
		@tmp,
		@GPRINT_ALL,
		@COMMENT);
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$DISK1_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	my @tmp2;
	if ($DISK2_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$DISK2_LIMIT";
		$tmp2[1] = "--lower-limit=0";
	} else {
		if ($DISK2_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$DISK2_LIMIT";
			$tmp2[1] = "--lower-limit=0";
			$tmp2[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$DISK2_PNG",
		"--title=I/O activity  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=I/O /sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		@tmp2,
		@graph_colors,
		"DEF:r_cnt=$DISK_RRD:read_cnt:AVERAGE",
		"DEF:w_cnt=$DISK_RRD:write_cnt:AVERAGE",
		"AREA:w_cnt#4444EE:Write count",
		"AREA:r_cnt#44EE44:Read count",
			"LINE1:w_cnt#0000EE",
			"LINE1:r_cnt#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:r_cnt:LAST:Reads    Current\\: %8.0lf",
		"GPRINT:w_cnt:LAST:Writes   Current\\: %8.0lf");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$DISK2_PNG>\n";
	}
	my @tmp3;
	if ($DISK3_RIGID eq 1) {
		$tmp3[0] = "--upper-limit=$DISK3_LIMIT";
		$tmp3[1] = "--lower-limit=0";
	} else {
		if ($DISK3_RIGID eq 2) {
			$tmp3[0] = "--upper-limit=$DISK3_LIMIT";
			$tmp3[1] = "--lower-limit=0";
			$tmp3[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$DISK3_PNG",
		"--title=Sectors activity  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Sectors r/w /sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		@tmp3,
		@graph_colors,
		"DEF:r_sec=$DISK_RRD:read_sec:AVERAGE",
		"DEF:w_sec=$DISK_RRD:write_sec:AVERAGE",
		"AREA:w_sec#4444EE:Sectors written",
		"AREA:r_sec#44EE44:Sectors read",
			"LINE1:w_sec#0000EE",
			"LINE1:r_sec#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:r_sec:LAST:Read    Current\\: %8.0lf",
		"GPRINT:w_sec:LAST:Written Current\\: %8.0lf");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$DISK3_PNG>\n";
		image_footer();
	}
}

sub net_stats {
	my $n;
	my @tmp;
	for($n = 0; $n < scalar(@NET_LIST); $n++) {
	unlink ("$BASE_WWW$NET1_PNG[$n]",
		"$BASE_WWW$NET2_PNG[$n]",
		"$BASE_WWW$NET3_PNG[$n]");
	if($_[0]) {
		my $title=$NET_LIST[$n] . " " . $_[0];
		image_header($title, 2);
		$tmp[0] = "COMMENT:\\n",
		$tmp[1] = "COMMENT:\\n",
		$tmp[2] = "GPRINT:K_out:LAST:KB/s Output      Current\\: %5.0lf",
		$tmp[3] = "GPRINT:K_out:AVERAGE:    Average\\: %5.0lf",
		$tmp[4] = "GPRINT:K_out:MIN:    Min\\: %5.0lf",
		$tmp[5] = "GPRINT:K_out:MAX:    Max\\: %5.0lf\\n",
		$tmp[6] = "GPRINT:K_in:LAST:KB/s Input       Current\\: %5.0lf",
		$tmp[7] = "GPRINT:K_in:AVERAGE:    Average\\: %5.0lf",
		$tmp[8] = "GPRINT:K_in:MIN:    Min\\: %5.0lf",
		$tmp[9] = "GPRINT:K_in:MAX:    Max\\: %5.0lf\\n",
	}
	my @DEF;
	my @tmp2;
	if ($NET_RIGID[$n] eq 1) {
		$tmp2[0] = "--upper-limit=$NET_LIMIT[$n]";
		$tmp2[1] = "--lower-limit=0";
	} else {
		if ($NET_RIGID[$n] eq 2) {
			$tmp2[0] = "--upper-limit=$NET_LIMIT[$n]";
			$tmp2[1] = "--lower-limit=0";
			$tmp2[2] = "--rigid";
		}
	}
	$DEF[0] = "DEF:B_in=$NET_RRD:net" . $n . "_bytes_in:AVERAGE";
	$DEF[1] = "DEF:B_out=$NET_RRD:net" . $n . "_bytes_out:AVERAGE";
	RRDs::graph("$BASE_WWW$NET1_PNG[$n]",
		"--title=$NET_LIST[$n] $NET_TYPE[$n] traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$width",
		"--height=$height",
		@tmp2,
		@graph_colors,
		@DEF,
		"CDEF:K_in=B_in,1024,/",
		"CDEF:K_out=B_out,1024,/",
		"AREA:B_out#4444EE:Output",
		"AREA:B_in#44EE44:Input",
			"LINE1:B_out#0000EE",
			"LINE1:B_in#00EE00",
		@tmp,
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$NET1_PNG[$n]>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	$DEF[0] = "DEF:p_in=$NET_RRD:net" . $n . "_packs_in:AVERAGE";
	$DEF[1] = "DEF:p_out=$NET_RRD:net" . $n . "_packs_out:AVERAGE";
	RRDs::graph("$BASE_WWW$NET2_PNG[$n]",
		"--title=$NET_LIST[$n] packet traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Packets/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		@graph_colors,
		@DEF,
		"AREA:p_out#4444EE:Output",
		"AREA:p_in#44EE44:Input",
			"LINE1:p_out#0000EE",
			"LINE1:p_in#00EE00");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$NET2_PNG[$n]>\n";
	}
	$DEF[0] = "DEF:e_in=$NET_RRD:net" . $n . "_error_in:AVERAGE";
	$DEF[1] = "DEF:e_out=$NET_RRD:net" . $n . "_error_out:AVERAGE";
	RRDs::graph("$BASE_WWW$NET3_PNG[$n]",
		"--title=$NET_LIST[$n] error traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Errors",
		"--width=$miniwidth",
		"--height=$miniheight",
		@graph_colors,
		@DEF,
		"AREA:e_out#4444EE:Output",
		"AREA:e_in#44EE44:Input",
			"LINE1:e_out#0000EE",
			"LINE1:e_in#00EE00");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$NET3_PNG[$n]>\n";
		image_footer();
		print "  <BR>\n";
	}
	}
}

sub servu_stats {
	my @tmp;
	if($_[0]) {
		image_header($_[0], 2);
		$tmp[0] = "COMMENT:\\n",
		$tmp[1] = "COMMENT:\\n",
		$tmp[2] = "GPRINT:smtp:LAST:SMTP           Current\\: %5.0lf",
		$tmp[3] = "GPRINT:smtp:AVERAGE:    Average\\: %5.0lf",
		$tmp[4] = "GPRINT:smtp:MIN:    Min\\: %5.0lf",
		$tmp[5] = "GPRINT:smtp:MAX:    Max\\: %5.0lf\\n",
		$tmp[6] = "GPRINT:ssh:LAST:SSH            Current\\: %5.0lf",
		$tmp[7] = "GPRINT:ssh:AVERAGE:    Average\\: %5.0lf",
		$tmp[8] = "GPRINT:ssh:MIN:    Min\\: %5.0lf",
		$tmp[9] = "GPRINT:ssh:MAX:    Max\\: %5.0lf\\n",
		$tmp[10] = "GPRINT:ftp:LAST:FTP            Current\\: %5.0lf",
		$tmp[11] = "GPRINT:ftp:AVERAGE:    Average\\: %5.0lf",
		$tmp[12] = "GPRINT:ftp:MIN:    Min\\: %5.0lf",
		$tmp[13] = "GPRINT:ftp:MAX:    Max\\: %5.0lf\\n",
		$tmp[14] = "GPRINT:telnet:LAST:Telnet         Current\\: %5.0lf",
		$tmp[15] = "GPRINT:telnet:AVERAGE:    Average\\: %5.0lf",
		$tmp[16] = "GPRINT:telnet:MIN:    Min\\: %5.0lf",
		$tmp[17] = "GPRINT:telnet:MAX:    Max\\: %5.0lf\\n",
		$tmp[18] = "GPRINT:smb:LAST:Samba          Current\\: %5.0lf",
		$tmp[19] = "GPRINT:smb:AVERAGE:    Average\\: %5.0lf",
		$tmp[20] = "GPRINT:smb:MIN:    Min\\: %5.0lf",
		$tmp[21] = "GPRINT:smb:MAX:    Max\\: %5.0lf\\n",
		$tmp[22] = "GPRINT:virusmail:LAST:VirusMail      Current\\: %5.0lf",
		$tmp[23] = "GPRINT:virusmail:AVERAGE:    Average\\: %5.0lf",
		$tmp[24] = "GPRINT:virusmail:MIN:    Min\\: %5.0lf",
		$tmp[25] = "GPRINT:virusmail:MAX:    Max\\: %5.0lf\\n",
		$tmp[26] = "GPRINT:fax:LAST:Fax            Current\\: %5.0lf",
		$tmp[27] = "GPRINT:fax:AVERAGE:    Average\\: %5.0lf",
		$tmp[28] = "GPRINT:fax:MIN:    Min\\: %5.0lf",
		$tmp[29] = "GPRINT:fax:MAX:    Max\\: %5.0lf\\n"
	}
	my @tmp2;
	unlink ("$BASE_WWW$SERVU1_PNG",
		"$BASE_WWW$SERVU2_PNG",
		"$BASE_WWW$SERVU3_PNG");
	if ($SERVU1_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$SERVU1_LIMIT";
		$tmp2[1] = "--lower-limit=0";
	} else {
		if ($SERVU1_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$SERVU1_LIMIT";
			$tmp2[1] = "--lower-limit=0";
			$tmp2[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$SERVU1_PNG",
		"--title=Network services demand  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Incremental hits",
		"--width=$width",
		"--height=$height",
		@tmp2,
		@graph_colors,
		"DEF:smtp=$SERVU_RRD:smtp:AVERAGE",
		"DEF:ssh=$SERVU_RRD:ssh:AVERAGE",
		"DEF:ftp=$SERVU_RRD:ftp:AVERAGE",
		"DEF:telnet=$SERVU_RRD:telnet:AVERAGE",
		"DEF:smb=$SERVU_RRD:smb:AVERAGE",
		"DEF:virusmail=$SERVU_RRD:virusmail:AVERAGE",
		"DEF:fax=$SERVU_RRD:fax:AVERAGE",
		"AREA:smtp#44EEEE:SMTP",
		"AREA:ssh#4444EE:SSH",
		"AREA:ftp#44EE44:FTP",
		"AREA:telnet#EE44EE:Telnet",
		"AREA:smb#EEEE44:Samba",
		"AREA:virusmail#EE4444:VirusMail",
		"AREA:fax#FFFFFF:Fax",
			"LINE1:smtp#00EEEE",
			"LINE1:ssh#0000EE",
			"LINE1:ftp#00EE00",
			"LINE1:telnet#EE00EE",
			"LINE1:smb#EEEE00",
			"LINE1:virusmail#EE0000",
			"LINE1:fax#FFFFFF",
		@tmp
		);
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$SERVU1_PNG>\n";
		print"  </TD>\n";
		print"  <TD>\n";
	}
	my @tmp3;
	if ($SERVU2_RIGID eq 1) {
		$tmp3[0] = "--upper-limit=$SERVU2_LIMIT";
		$tmp3[1] = "--lower-limit=0";
	} else {
		if ($SERVU2_RIGID eq 2) {
			$tmp3[0] = "--upper-limit=$SERVU2_LIMIT";
			$tmp3[1] = "--lower-limit=0";
			$tmp3[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$SERVU2_PNG",
		"--title=POP3 service demand  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Incremental hits",
		"--width=$miniwidth",
		"--height=$miniheight",
		@tmp3,
		@graph_colors,
		"DEF:pop3=$SERVU_RRD:pop3:AVERAGE",
		"AREA:pop3#4444EE:POP3",
			"LINE1:pop3#0000EE",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:pop3:LAST:POP3    Current\\: %5.0lf");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$SERVU2_PNG>\n";
	}
	my @tmp4;
	if ($SERVU3_RIGID eq 1) {
		$tmp4[0] = "--upper-limit=$SERVU3_LIMIT";
		$tmp4[1] = "--lower-limit=0";
	} else {
		if ($SERVU3_RIGID eq 2) {
			$tmp4[0] = "--upper-limit=$SERVU3_LIMIT";
			$tmp4[1] = "--lower-limit=0";
			$tmp4[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$SERVU3_PNG",
		"--title=WWW service demand  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Incremental hits",
		"--width=$miniwidth",
		"--height=$miniheight",
		@tmp4,
		@graph_colors,
		"DEF:www=$SERVU_RRD:www:AVERAGE",
		"AREA:www#44EE44:WWW",
			"LINE1:www#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:www:LAST:WWW     Current\\: %5.0lf");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$SERVU3_PNG>\n";
		image_footer();
	}
}

sub port1_stats {
	if($_[0]) {
		image_header($_[0], 3);
	}
	my @tmp;
	unlink ("$BASE_WWW$PORT01_PNG",
		"$BASE_WWW$PORT02_PNG",
		"$BASE_WWW$PORT03_PNG",
		"$BASE_WWW$PORT04_PNG",
		"$BASE_WWW$PORT05_PNG",
		"$BASE_WWW$PORT06_PNG");
	if ($PORT01_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT01_LIMIT";
		$tmp[1] = "--lower-limit=0";
	} else {
		if ($PORT01_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT01_LIMIT";
			$tmp[1] = "--lower-limit=0";
			$tmp[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT01_PNG",
		"--title=01 - $PORT01_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp,
		@graph_colors,
		"DEF:port01_b_in=$PORT_RRD:port01_bytes_in:AVERAGE",
		"DEF:port01_b_out=$PORT_RRD:port01_bytes_out:AVERAGE",
		"AREA:port01_b_out#4444EE:Output",
		"AREA:port01_b_in#44EE44:Input",
			"LINE1:port01_b_out#0000EE",
			"LINE1:port01_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT01_PNG>\n";
	}
	my @tmp2;
	if ($PORT02_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$PORT02_LIMIT";
		$tmp2[1] = "--lower-limit=0";
	} else {
		if ($PORT02_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$PORT02_LIMIT";
			$tmp2[1] = "--lower-limit=0";
			$tmp2[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT02_PNG",
		"--title=02 - $PORT02_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp2,
		@graph_colors,
		"DEF:port02_b_in=$PORT_RRD:port02_bytes_in:AVERAGE",
		"DEF:port02_b_out=$PORT_RRD:port02_bytes_out:AVERAGE",
		"AREA:port02_b_out#4444EE:Output",
		"AREA:port02_b_in#44EE44:Input",
			"LINE1:port02_b_out#0000EE",
			"LINE1:port02_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT02_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	my @tmp3;
	if ($PORT03_RIGID eq 1) {
		$tmp3[0] = "--upper-limit=$PORT03_LIMIT";
		$tmp3[1] = "--lower-limit=0";
	} else {
		if ($PORT03_RIGID eq 2) {
			$tmp3[0] = "--upper-limit=$PORT03_LIMIT";
			$tmp3[1] = "--lower-limit=0";
			$tmp3[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT03_PNG",
		"--title=03 - $PORT03_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp3,
		@graph_colors,
		"DEF:port03_b_in=$PORT_RRD:port03_bytes_in:AVERAGE",
		"DEF:port03_b_out=$PORT_RRD:port03_bytes_out:AVERAGE",
		"AREA:port03_b_out#4444EE:Output",
		"AREA:port03_b_in#44EE44:Input",
			"LINE1:port03_b_out#0000EE",
			"LINE1:port03_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT03_PNG>\n";
	}
	my @tmp4;
	if ($PORT04_RIGID eq 1) {
		$tmp4[0] = "--upper-limit=$PORT04_LIMIT";
		$tmp4[1] = "--lower-limit=0";
	} else {
		if ($PORT04_RIGID eq 2) {
			$tmp4[0] = "--upper-limit=$PORT04_LIMIT";
			$tmp4[1] = "--lower-limit=0";
			$tmp4[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT04_PNG",
		"--title=04 - $PORT04_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp4,
		@graph_colors,
		"DEF:port04_b_in=$PORT_RRD:port04_bytes_in:AVERAGE",
		"DEF:port04_b_out=$PORT_RRD:port04_bytes_out:AVERAGE",
		"AREA:port04_b_out#4444EE:Output",
		"AREA:port04_b_in#44EE44:Input",
			"LINE1:port04_b_out#0000EE",
			"LINE1:port04_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT04_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	my @tmp5;
	if ($PORT05_RIGID eq 1) {
		$tmp5[0] = "--upper-limit=$PORT05_LIMIT";
		$tmp5[1] = "--lower-limit=0";
	} else {
		if ($PORT05_RIGID eq 2) {
			$tmp5[0] = "--upper-limit=$PORT05_LIMIT";
			$tmp5[1] = "--lower-limit=0";
			$tmp5[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT05_PNG",
		"--title=05 - $PORT05_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp5,
		@graph_colors,
		"DEF:port05_b_in=$PORT_RRD:port05_bytes_in:AVERAGE",
		"DEF:port05_b_out=$PORT_RRD:port05_bytes_out:AVERAGE",
		"AREA:port05_b_out#4444EE:Output",
		"AREA:port05_b_in#44EE44:Input",
			"LINE1:port05_b_out#0000EE",
			"LINE1:port05_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT05_PNG>\n";
	}
	my @tmp6;
	if ($PORT06_RIGID eq 1) {
		$tmp6[0] = "--upper-limit=$PORT06_LIMIT";
		$tmp6[1] = "--lower-limit=0";
	} else {
		if ($PORT06_RIGID eq 2) {
			$tmp6[0] = "--upper-limit=$PORT06_LIMIT";
			$tmp6[1] = "--lower-limit=0";
			$tmp6[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT06_PNG",
		"--title=06 - $PORT06_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp6,
		@graph_colors,
		"DEF:port06_b_in=$PORT_RRD:port06_bytes_in:AVERAGE",
		"DEF:port06_b_out=$PORT_RRD:port06_bytes_out:AVERAGE",
		"AREA:port06_b_out#4444EE:Output",
		"AREA:port06_b_in#44EE44:Input",
			"LINE1:port06_b_out#0000EE",
			"LINE1:port06_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT06_PNG>\n";
		image_footer();
	}
}

sub port2_stats {
	if($_[0]) {
		image_header($_[0], 3);
	}
	my @tmp;
	unlink ("$BASE_WWW$PORT07_PNG",
		"$BASE_WWW$PORT08_PNG",
		"$BASE_WWW$PORT09_PNG",
		"$BASE_WWW$PORT10_PNG",
		"$BASE_WWW$PORT11_PNG",
		"$BASE_WWW$PORT12_PNG");
	if ($PORT07_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$PORT07_LIMIT";
		$tmp[1] = "--lower-limit=0";
	} else {
		if ($PORT07_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$PORT07_LIMIT";
			$tmp[1] = "--lower-limit=0";
			$tmp[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT07_PNG",
		"--title=07 - $PORT07_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp,
		@graph_colors,
		"DEF:port07_b_in=$PORT_RRD:port07_bytes_in:AVERAGE",
		"DEF:port07_b_out=$PORT_RRD:port07_bytes_out:AVERAGE",
		"AREA:port07_b_out#4444EE:Output",
		"AREA:port07_b_in#44EE44:Input",
			"LINE1:port07_b_out#0000EE",
			"LINE1:port07_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT07_PNG>\n";
	}
	my @tmp2;
	if ($PORT08_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$PORT08_LIMIT";
		$tmp2[1] = "--lower-limit=0";
	} else {
		if ($PORT08_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$PORT08_LIMIT";
			$tmp2[1] = "--lower-limit=0";
			$tmp2[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT08_PNG",
		"--title=08 - $PORT08_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp2,
		@graph_colors,
		"DEF:port08_b_in=$PORT_RRD:port08_bytes_in:AVERAGE",
		"DEF:port08_b_out=$PORT_RRD:port08_bytes_out:AVERAGE",
		"AREA:port08_b_out#4444EE:Output",
		"AREA:port08_b_in#44EE44:Input",
			"LINE1:port08_b_out#0000EE",
			"LINE1:port08_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT08_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	my @tmp3;
	if ($PORT09_RIGID eq 1) {
		$tmp3[0] = "--upper-limit=$PORT09_LIMIT";
		$tmp3[1] = "--lower-limit=0";
	} else {
		if ($PORT09_RIGID eq 2) {
			$tmp3[0] = "--upper-limit=$PORT09_LIMIT";
			$tmp3[1] = "--lower-limit=0";
			$tmp3[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT09_PNG",
		"--title=09 - $PORT09_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp3,
		@graph_colors,
		"DEF:port09_b_in=$PORT_RRD:port09_bytes_in:AVERAGE",
		"DEF:port09_b_out=$PORT_RRD:port09_bytes_out:AVERAGE",
		"AREA:port09_b_out#4444EE:Output",
		"AREA:port09_b_in#44EE44:Input",
			"LINE1:port09_b_out#0000EE",
			"LINE1:port09_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT09_PNG>\n";
	}
	my @tmp4;
	if ($PORT10_RIGID eq 1) {
		$tmp4[0] = "--upper-limit=$PORT10_LIMIT";
		$tmp4[1] = "--lower-limit=0";
	} else {
		if ($PORT10_RIGID eq 2) {
			$tmp4[0] = "--upper-limit=$PORT10_LIMIT";
			$tmp4[1] = "--lower-limit=0";
			$tmp4[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT10_PNG",
		"--title=10 - $PORT10_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp4,
		@graph_colors,
		"DEF:port10_b_in=$PORT_RRD:port10_bytes_in:AVERAGE",
		"DEF:port10_b_out=$PORT_RRD:port10_bytes_out:AVERAGE",
		"AREA:port10_b_out#4444EE:Output",
		"AREA:port10_b_in#44EE44:Input",
			"LINE1:port10_b_out#0000EE",
			"LINE1:port10_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT10_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";	
	}
	my @tmp5;
	if ($PORT11_RIGID eq 1) {
		$tmp5[0] = "--upper-limit=$PORT11_LIMIT";
		$tmp5[1] = "--lower-limit=0";
	} else {
		if ($PORT11_RIGID eq 2) {
			$tmp5[0] = "--upper-limit=$PORT11_LIMIT";
			$tmp5[1] = "--lower-limit=0";
			$tmp5[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT11_PNG",
		"--title=11 - $PORT11_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp5,
		@graph_colors,
		"DEF:port11_b_in=$PORT_RRD:port11_bytes_in:AVERAGE",
		"DEF:port11_b_out=$PORT_RRD:port11_bytes_out:AVERAGE",
		"AREA:port11_b_out#4444EE:Output",
		"AREA:port11_b_in#44EE44:Input",
			"LINE1:port11_b_out#0000EE",
			"LINE1:port11_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT11_PNG>\n";
	}
	my @tmp6;
	if ($PORT12_RIGID eq 1) {
		$tmp6[0] = "--upper-limit=$PORT12_LIMIT";
		$tmp6[1] = "--lower-limit=0";
	} else {
		if ($PORT12_RIGID eq 2) {
			$tmp6[0] = "--upper-limit=$PORT12_LIMIT";
			$tmp6[1] = "--lower-limit=0";
			$tmp6[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$PORT12_PNG",
		"--title=12 - $PORT12_NAME traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=$portwidth",
		"--height=$miniheight",
		@tmp6,
		@graph_colors,
		"DEF:port12_b_in=$PORT_RRD:port12_bytes_in:AVERAGE",
		"DEF:port12_b_out=$PORT_RRD:port12_bytes_out:AVERAGE",
		"AREA:port12_b_out#4444EE:Output",
		"AREA:port12_b_in#44EE44:Input",
			"LINE1:port12_b_out#0000EE",
			"LINE1:port12_b_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$PORT12_PNG>\n";
		image_footer();
	}
}

sub user_stats {
	if($_[0]) {
		image_header($_[0], 2);
	}
	my @tmp;
	unlink ("$BASE_WWW$USER1_PNG",
		"$BASE_WWW$USER2_PNG",
		"$BASE_WWW$USER3_PNG");
	if ($USER1_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$USER1_LIMIT";
		$tmp[1] = "--lower-limit=0";
	} else {
		if ($USER1_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$USER1_LIMIT";
			$tmp[1] = "--lower-limit=0";
			$tmp[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$USER1_PNG",
		"--title=Users on system  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Number of users",
		"--width=$width",
		"--height=$height",
		@tmp,
		@graph_colors,
		"DEF:usr=$USER_RRD:user_usr:AVERAGE",
		"DEF:smb=$USER_RRD:user_smb:AVERAGE",
		"DEF:mac=$USER_RRD:user_mac:AVERAGE",
		"AREA:usr#44EE44:Telnet/SSH",
			"LINE1:usr#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:usr:LAST:Telnet/SSH     Current\\: %3.0lf",
		"GPRINT:usr:AVERAGE:    Average\\: %3.0lf",
		"GPRINT:usr:MIN:    Min\\: %3.0lf",
		"GPRINT:usr:MAX:    Max\\: %3.0lf\\n",
		"GPRINT:smb:LAST:Samba          Current\\: %3.0lf",
		"GPRINT:smb:AVERAGE:    Average\\: %3.0lf",
		"GPRINT:smb:MIN:    Min\\: %3.0lf",
		"GPRINT:smb:MAX:    Max\\: %3.0lf\\n",
		"GPRINT:mac:LAST:NetaTalk       Current\\: %3.0lf",
		"GPRINT:mac:AVERAGE:    Average\\: %3.0lf",
		"GPRINT:mac:MIN:    Min\\: %3.0lf",
		"GPRINT:mac:MAX:    Max\\: %3.0lf\\n");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$USER1_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	my @tmp2;
	if ($USER2_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$USER2_LIMIT";
		$tmp2[1] = "--lower-limit=0";
	} else {
		if ($USER2_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$USER2_LIMIT";
			$tmp2[1] = "--lower-limit=0";
			$tmp2[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$USER2_PNG",
		"--title=Users using Samba  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Number of users",
		"--width=$miniwidth",
		"--height=$miniheight",
		@tmp2,
		@graph_colors,
		"DEF:smb=$USER_RRD:user_smb:AVERAGE",
		"AREA:smb#EEEE44:Samba",
			"LINE1:smb#EEEE00");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$USER2_PNG>\n";
	}
	my @tmp3;
	if ($USER3_RIGID eq 1) {
		$tmp3[0] = "--upper-limit=$USER3_LIMIT";
		$tmp3[1] = "--lower-limit=0";
	} else {
		if ($USER3_RIGID eq 2) {
			$tmp3[0] = "--upper-limit=$USER3_LIMIT";
			$tmp3[1] = "--lower-limit=0";
			$tmp3[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$USER3_PNG",
		"--title=Users using NetaTalk  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Number of users",
		"--width=$miniwidth",
		"--height=$miniheight",
		@tmp3,
		@graph_colors,
		"DEF:mac=$USER_RRD:user_mac:AVERAGE",
		"AREA:mac#EE4444:NetaTalk",
			"LINE1:mac#EE0000");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$USER3_PNG>\n";
		image_footer();
	}
}

sub int_stats {
	if($_[0]) {
		image_header($_[0], 2);
	}
	my $INT0_R=`grep " 0:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT1_R=`grep " 1:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT2_R=`grep " 2:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT3_R=`grep " 3:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT4_R=`grep " 4:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT5_R=`grep " 5:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT6_R=`grep " 6:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT7_R=`grep " 7:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT8_R=`grep " 8:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT9_R=`grep " 9:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT10_R=`grep "10:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT11_R=`grep "11:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT12_R=`grep "12:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT13_R=`grep "13:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT14_R=`grep "14:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	my $INT15_R=`grep "15:" /proc/interrupts | awk -F "  " '{ print \$NF }'`;
	$INT0_R=$INT0_R eq "" ? $INT0_NAME : $INT0_R;
	$INT1_R=$INT1_R eq "" ? $INT1_NAME : $INT1_R;
	$INT2_R=$INT2_R eq "" ? $INT2_NAME : $INT2_R;
	$INT3_R=$INT3_R eq "" ? $INT3_NAME : $INT3_R;
	$INT4_R=$INT4_R eq "" ? $INT4_NAME : $INT4_R;
	$INT5_R=$INT5_R eq "" ? $INT5_NAME : $INT5_R;
	$INT6_R=$INT6_R eq "" ? $INT6_NAME : $INT6_R;
	$INT7_R=$INT7_R eq "" ? $INT7_NAME : $INT7_R;
	$INT8_R=$INT8_R eq "" ? $INT8_NAME : $INT8_R;
	$INT9_R=$INT9_R eq "" ? $INT9_NAME : $INT9_R;
	$INT10_R=$INT10_R eq "" ? $INT10_NAME : $INT10_R;
	$INT11_R=$INT11_R eq "" ? $INT11_NAME : $INT11_R;
	$INT12_R=$INT12_R eq "" ? $INT12_NAME : $INT12_R;
	$INT13_R=$INT13_R eq "" ? $INT13_NAME : $INT13_R;
	$INT14_R=$INT14_R eq "" ? $INT14_NAME : $INT14_R;
	$INT15_R=$INT15_R eq "" ? $INT15_NAME : $INT15_R;
	$INT0_NAME=$INT0_R ne $INT0_NAME ? $INT0_R : $INT0_NAME;
	$INT1_NAME=$INT1_R ne $INT1_NAME ? $INT1_R : $INT1_NAME;
	$INT2_NAME=$INT2_R ne $INT2_NAME ? $INT2_R : $INT2_NAME;
	$INT3_NAME=$INT3_R ne $INT3_NAME ? $INT3_R : $INT3_NAME;
	$INT4_NAME=$INT4_R ne $INT4_NAME ? $INT4_R : $INT4_NAME;
	$INT5_NAME=$INT5_R ne $INT5_NAME ? $INT5_R : $INT5_NAME;
	$INT6_NAME=$INT6_R ne $INT6_NAME ? $INT6_R : $INT6_NAME;
	$INT7_NAME=$INT7_R ne $INT7_NAME ? $INT7_R : $INT7_NAME;
	$INT8_NAME=$INT8_R ne $INT8_NAME ? $INT8_R : $INT8_NAME;
	$INT9_NAME=$INT9_R ne $INT9_NAME ? $INT9_R : $INT9_NAME;
	$INT10_NAME=$INT10_R ne $INT10_NAME ? $INT10_R : $INT10_NAME;
	$INT11_NAME=$INT11_R ne $INT11_NAME ? $INT11_R : $INT11_NAME;
	$INT12_NAME=$INT12_R ne $INT12_NAME ? $INT12_R : $INT12_NAME;
	$INT13_NAME=$INT13_R ne $INT13_NAME ? $INT13_R : $INT13_NAME;
	$INT14_NAME=$INT14_R ne $INT14_NAME ? $INT14_R : $INT14_NAME;
	$INT15_NAME=$INT15_R ne $INT15_NAME ? $INT15_R : $INT15_NAME;
	chomp($INT0_NAME);
	chomp($INT1_NAME);
	chomp($INT2_NAME);
	chomp($INT3_NAME);
	chomp($INT4_NAME);
	chomp($INT5_NAME);
	chomp($INT6_NAME);
	chomp($INT7_NAME);
	chomp($INT8_NAME);
	chomp($INT9_NAME);
	chomp($INT10_NAME);
	chomp($INT11_NAME);
	chomp($INT12_NAME);
	chomp($INT13_NAME);
	chomp($INT14_NAME);
	chomp($INT15_NAME);

# Escape colons to support RRDtool v1.2+
	$INT0_NAME =~ s/:/\\:/;
	$INT1_NAME =~ s/:/\\:/;
	$INT2_NAME =~ s/:/\\:/;
	$INT3_NAME =~ s/:/\\:/;
	$INT4_NAME =~ s/:/\\:/;
	$INT5_NAME =~ s/:/\\:/;
	$INT6_NAME =~ s/:/\\:/;
	$INT7_NAME =~ s/:/\\:/;
	$INT8_NAME =~ s/:/\\:/;
	$INT9_NAME =~ s/:/\\:/;
	$INT10_NAME =~ s/:/\\:/;
	$INT11_NAME =~ s/:/\\:/;
	$INT12_NAME =~ s/:/\\:/;
	$INT13_NAME =~ s/:/\\:/;
	$INT14_NAME =~ s/:/\\:/;
	$INT15_NAME =~ s/:/\\:/;

	my @tmp;
	unlink ("$BASE_WWW$INT1_PNG",
		"$BASE_WWW$INT2_PNG",
		"$BASE_WWW$INT3_PNG");
	if ($INT1_RIGID eq 1) {
		$tmp[0] = "--upper-limit=$INT1_LIMIT";
		$tmp[1] = "--lower-limit=0";
	} else {
		if ($INT1_RIGID eq 2) {
			$tmp[0] = "--upper-limit=$INT1_LIMIT";
			$tmp[1] = "--lower-limit=0";
			$tmp[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$INT1_PNG",
		"--title=Interrupt activity  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Ticks/sec",
		"--width=$width",
		"--height=$height",
		@tmp,
		@graph_colors,
		"DEF:int5=$INT_RRD:int_5:AVERAGE",
		"DEF:int7=$INT_RRD:int_7:AVERAGE",
		"DEF:int8=$INT_RRD:int_8:AVERAGE",
		"DEF:int9=$INT_RRD:int_9:AVERAGE",
		"DEF:int10=$INT_RRD:int_10:AVERAGE",
		"DEF:int11=$INT_RRD:int_11:AVERAGE",
		"DEF:int12=$INT_RRD:int_12:AVERAGE",
		"DEF:int13=$INT_RRD:int_13:AVERAGE",
		"DEF:int14=$INT_RRD:int_14:AVERAGE",
		"DEF:int15=$INT_RRD:int_15:AVERAGE",
		"COMMENT:\\n",
		"AREA:int5#888888:(5)$INT5_NAME",
		"AREA:int7#44EEEE:(7)$INT7_NAME",
		"AREA:int8#DDDDDD:(8)$INT8_NAME",
		"AREA:int9#B4B444:(9)$INT9_NAME",
		"COMMENT:\\n",
		"AREA:int10#4444EE:(10)$INT10_NAME",
		"AREA:int11#44EE44:(11)$INT11_NAME",
		"COMMENT:\\n",
		"AREA:int12#EEEE44:(12)$INT12_NAME",
		"AREA:int13#000000:(13)$INT13_NAME",
		"COMMENT:\\n",
		"AREA:int14#EE44EE:(14)$INT14_NAME",
		"AREA:int15#EE4444:(15)$INT15_NAME",
			"LINE1:int5#888888",
			"LINE1:int7#00EEEE",
			"LINE1:int8#DDDDDD",
			"LINE1:int9#B4B400",
			"LINE1:int10#0000EE",
			"LINE1:int11#00EE00",
			"LINE1:int12#EEEE00",
			"LINE1:int13#000000",
			"LINE1:int14#EE00EE",
			"LINE1:int15#EE0000");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$INT1_PNG>\n";
		print "  </TD>\n";
		print "  <TD>\n";
	}
	my @tmp2;
	if ($INT2_RIGID eq 1) {
		$tmp2[0] = "--upper-limit=$INT2_LIMIT";
		$tmp2[1] = "--lower-limit=0";
	} else {
		if ($INT2_RIGID eq 2) {
			$tmp2[0] = "--upper-limit=$INT2_LIMIT";
			$tmp2[1] = "--lower-limit=0";
			$tmp2[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$INT2_PNG",
		"--title=Core activity  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Ticks/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		@tmp2,
		@graph_colors,
		"DEF:int0=$INT_RRD:int_0:AVERAGE",
		"DEF:int1=$INT_RRD:int_1:AVERAGE",
		"DEF:int2=$INT_RRD:int_2:AVERAGE",
		"AREA:int0#44EEEE:(0)$INT0_NAME",
		"AREA:int1#44EE44:(1)$INT1_NAME",
		"AREA:int2#EE4444:(2)$INT2_NAME",
			"LINE1:int0#00EEEE",
			"LINE1:int1#00EE00",
			"LINE1:int2#EE0000");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$INT2_PNG>\n";
	}
	my @tmp3;
	if ($INT3_RIGID eq 1) {
		$tmp3[0] = "--upper-limit=$INT3_LIMIT";
		$tmp3[1] = "--lower-limit=0";
	} else {
		if ($INT3_RIGID eq 2) {
			$tmp3[0] = "--upper-limit=$INT3_LIMIT";
			$tmp3[1] = "--lower-limit=0";
			$tmp3[2] = "--rigid";
		}
	}
	RRDs::graph("$BASE_WWW$INT3_PNG",
		"--title=Low-devices activity  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=Ticks/sec",
		"--width=$miniwidth",
		"--height=$miniheight",
		@tmp3,
		@graph_colors,
		"DEF:int3=$INT_RRD:int_3:AVERAGE",
		"DEF:int4=$INT_RRD:int_4:AVERAGE",
		"DEF:int6=$INT_RRD:int_6:AVERAGE",
		"AREA:int3#44EE44:(3)$INT3_NAME",
		"AREA:int4#4444EE:(4)$INT4_NAME",
		"AREA:int6#EE44EE:(6)$INT6_NAME",
			"LINE1:int3#00EE00",
			"LINE1:int4#0000EE",
			"LINE1:int6#EE00EE");
	if($_[0]) {
		print "  <IMG SRC=$BASE_URL$INT3_PNG>\n";
		image_footer();
	}
}

sub multihost_stats {
	my $n;
	my $n2;
	my @SERV_NAME;
	my @SERV_URL;

	for($n = 0, $n2 = 0; $n < scalar(@SERV_LIST); $n += 2, $n2++) {
		$SERV_NAME[$n2] = $SERV_LIST[$n];
		$SERV_URL[$n2] = $SERV_LIST[$n + 1];
	}

	if($MULTIHOST_IMGPERLINE < 1) {
		$MULTIHOST_IMGPERLINE = 1;
	}
	$graph = !$graph ? "_cpu1" : $graph;

	if($val eq "all") {
		for($n = 0; $n < scalar(@SERV_NAME); $n += $MULTIHOST_IMGPERLINE) {
			print "  <TABLE CELLSPACING=5 CELLPADDING=0 WIDTH=1 BGCOLOR=" . $graph_back_color . " BORDER=1>\n";
			print "  <TR>\n";
			for($n2 = 0; $n2 < $MULTIHOST_IMGPERLINE; $n2++) {
				if($n < scalar(@SERV_NAME)) {
					print "  <TD BGCOLOR=" . $title_back_color . ">\n";
					print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $fore_color . ">\n";
					print "    <B>&nbsp;&nbsp;" . $SERV_NAME[$n] . "<B>\n";
					print "  </FONT>\n";
					print "  </TD>\n";
				}
				$n++;
			}
			print "  </TR>\n";
			for($n2 = 0, $n=$n-$MULTIHOST_IMGPERLINE; $n2 < $MULTIHOST_IMGPERLINE; $n2++) {
				if($n < scalar(@SERV_NAME)) {
					print "  <IFRAME SRC=$SERV_URL[$n]/cgi-bin/monitorix/localhost.cgi?when=$when&graph=$graph&color=$color&silent=yes HEIGHT=0 WIDTH=0 FRAMEBORDER=0></IFRAME>\n";
					print "  <TD>\n";
					print "  <IMG SRC=\"$SERV_URL[$n]/monitorix/imgs/$graph.$when.png\">\n";
					print "  </TD>\n";

				}
				$n++;
			}
			print "  </TR>\n";
			for($n2 = 0, $n=$n-$MULTIHOST_IMGPERLINE; $n2 < $MULTIHOST_IMGPERLINE; $n2++) {
				if($n < scalar(@SERV_NAME)) {
				if($MULTIHOST_FOOTER) {
					print "  <TD BGCOLOR=" . $title_back_color . ">\n";
					print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $title_fore_color . ">\n";
					print "  <FONT SIZE=-1>\n";
					print "    <B>&nbsp;&nbsp;$SERV_URL[$n]<B>\n";
					print "  </FONT></FONT>\n";
					print "  </TD>\n";
				}
				}
				$n++;
			}
			$n=$n-$MULTIHOST_IMGPERLINE;
			print "  </TR>\n";
			print "  </TABLE>\n";
			print "  <BR>\n";
		}
	} else {
		print "  <TABLE CELLSPACING=5 CELLPADDING=0 WIDTH=1 BGCOLOR=" . $graph_back_color . " BORDER=1>\n";
		print "  <TR>\n";
		print "  <TD BGCOLOR=" . $title_back_color . ">\n";
		print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $fore_color . ">\n";
		print "    <B>&nbsp;&nbsp;" . $SERV_NAME[$val] . "<B>\n";
		print "  </FONT>\n";
		print "  </TD>\n";
		print "  </TR>\n";
		print "  <IFRAME SRC=$SERV_URL[$val]/cgi-bin/monitorix/localhost.cgi?when=$when&graph=$graph&color=$color&silent=yes HEIGHT=0 WIDTH=0 FRAMEBORDER=0></IFRAME>\n";
		print "  <TD>\n";
		print "  <IMG SRC=\"$SERV_URL[$val]/monitorix/imgs/$graph.$when.png\">\n";
		print "  </TD>\n";
		print "  </TR>\n";
		if($MULTIHOST_FOOTER) {
			print "  <TD BGCOLOR=" . $title_back_color . ">\n";
			print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $title_fore_color . ">\n";
			print "  <FONT SIZE=-1>\n";
			print "    <B>&nbsp;&nbsp;$SERV_URL[$val]<B>\n";
			print "  </FONT></FONT>\n";
			print "  </TD>\n";
		}
		print "  </TR>\n";
		print "  </TABLE>\n";
		print "  <BR>\n";
	}
}

sub panoramic_stats {
	my $n;
	my @tmp;
	if ($NET_RIGID[$inetpos] eq 1) {
		$tmp[0] = "--upper-limit=$NET_LIMIT[$inetpos]";
		$tmp[1] = "--lower-limit=0";
	} else {
		if ($NET_RIGID[$inetpos] eq 2) {
			$tmp[0] = "--upper-limit=$NET_LIMIT[$inetpos]";
			$tmp[1] = "--lower-limit=0";
			$tmp[2] = "--rigid";
		}
	}

	print "  <TABLE CELLSPACING=5 CELLPADDING=0 WIDTH=1 BGCOLOR=" . $graph_back_color . " BORDER=1>\n";
	print "  <TR>\n";
	print "  <TD BGCOLOR=" . $title_back_color . " COLSPAN=2>\n";
	print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $title_fore_color . ">\n";
	print "    <B>&nbsp;&nbsp;Internet traffic and usage<B>\n";
	print "  </FONT>\n";
	print "  </TD>\n";
	print "  </TR>\n";
	for($n = 0; $n < scalar(@PC_LIST); $n++) {
	if(!($n % 2)) {
		print "  <TR>\n";
	}
	print "  <TD>\n";
	unlink ("$BASE_WWW$PANO_PNG[$n]");
	my @DEF;
	$DEF[0] = "DEF:B_in=$PC_RRD:pc" . ($n+1) . "_bytes_in:AVERAGE \\";
	$DEF[1] = "DEF:B_out=$PC_RRD:pc" . ($n+1) . "_bytes_out:AVERAGE \\";
	RRDs::graph("$BASE_WWW$PANO_PNG[$n]",
		"--title=$PC_LIST[$n] traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=300",
		"--height=100",
		@tmp,
		@graph_colors,
		@DEF,
		"CDEF:K_in=B_in,1024,/",
		"CDEF:K_out=B_out,1024,/",
		"AREA:B_out#4444EE:Output",
		"AREA:B_in#44EE44:Input",
			"LINE1:B_out#0000EE",
			"LINE1:B_in#00EE00");
	print "  <IMG SRC=$BASE_URL$PANO_PNG[$n]>\n";
	if(!(($n+1) % 2)) {
		print "  </TD>\n";
		print "  </TR>\n";
	} else {
		print "  </TD>\n";
	}
	}
	print "  </TD>\n";
	print "  </TR>\n";
	print "  </TABLE>\n";
}

sub pc_stats {
	my @tmp;
	if ($NET_RIGID[$inetpos] eq 1) {
		$tmp[0] = "--upper-limit=$NET_LIMIT[$inetpos]";
		$tmp[1] = "--lower-limit=0";
	} else {
		if ($NET_RIGID[$inetpos] eq 2) {
			$tmp[0] = "--upper-limit=$NET_LIMIT[$inetpos]";
			$tmp[1] = "--lower-limit=0";
			$tmp[2] = "--rigid";
		}
	}

	unlink ("$BASE_WWW$PC_PNG[$val]");
	if($PC_LIST[$val]) {
	my @DEF;
	print "  <TABLE CELLSPACING=5 CELLPADDING=0 WIDTH=1 BGCOLOR=" . $graph_back_color . " BORDER=1>\n";
	print "  <TR>\n";
	print "  <TD BGCOLOR=" . $title_back_color . " COLSPAN=2>\n";
	print "  <FONT FACE='Arial, Helvetica, sans-serif' COLOR=" . $title_fore_color . ">\n";
	print "    <B>&nbsp;&nbsp;Internet traffic and usage<B>\n";
	print "  </FONT>\n";
	print "  </TD>\n";
	print "  </TR>\n";
	print "  <TR>\n";
	print "  <TD>\n";
	$DEF[0] = "DEF:B_in=$PC_RRD:pc" . ($val+1) . "_bytes_in:AVERAGE \\";
	$DEF[1] = "DEF:B_out=$PC_RRD:pc" . ($val+1) . "_bytes_out:AVERAGE \\";
	RRDs::graph("$BASE_WWW$PC_PNG[$val]",
		"--title=$PC_LIST[$val] traffic  (1$when)",
		"--start=-1$when",
		"--imgformat=PNG",
		"--vertical-label=bytes/sec",
		"--width=450",
		"--height=150",
		@tmp,
		@graph_colors,
		@DEF,
		"CDEF:K_in=B_in,1024,/",
		"CDEF:K_out=B_out,1024,/",
		"AREA:B_out#4444EE:Output",
		"AREA:B_in#44EE44:Input",
			"LINE1:B_out#0000EE",
			"LINE1:B_in#00EE00",
		"COMMENT:\\n",
		"COMMENT:\\n",
		"GPRINT:K_out:LAST:KB/s Output      Current\\: %5.0lf",
		"GPRINT:K_out:AVERAGE:    Average\\: %5.0lf",
		"GPRINT:K_out:MIN:    Min\\: %5.0lf",
		"GPRINT:K_out:MAX:    Max\\: %5.0lf\\n",
		"GPRINT:K_in:LAST:KB/s Input       Current\\: %5.0lf",
		"GPRINT:K_in:AVERAGE:    Average\\: %5.0lf",
		"GPRINT:K_in:MIN:    Min\\: %5.0lf",
		"GPRINT:K_in:MAX:    Max\\: %5.0lf\\n",
		"COMMENT:\\n");
	print "  <IMG SRC=$BASE_URL$PC_PNG[$val]>\n";
	print "  </TD>\n";
	print "  </TR>\n";
	print "  </TABLE>\n";
	}
}

