#!/usr/bin/perl
#
# @(#) Fibranet NSP, SL
# Copyright (C) 2005 by Jordi Sanfeliu <admin@fibranet.com>
#
# Monitorix v3
#

use strict;
use CGI;
my $query = new CGI;

require "/etc/monitorix/monitorix.conf";

our %GRAPHS;
our $THEME_COLOR;

my $time = "?when=" . $query->param('time');
my $graph = "&graph=" . $GRAPHS{$query->param('graph')};
my @host = split(/\./, $query->param('host'));

my $theme = "&color=" . $THEME_COLOR;
my $back_color = $THEME_COLOR eq "black" ? "#000000" : "#FFFFFF";
my $url = "/cgi-bin/monitorix/localhost.cgi" . $time . $graph . $theme;

if($host[0] eq 'localhost') {
	$url .= "&mode=" . $host[0];
} else {
	$url .= "&mode=" . $host[0] . "&val=" . $host[1];
}
calltocgi($url);
exit(0);


sub calltocgi {
print $query->header('text/html');
print <<HTML;
  <HTML>
    <BODY BGCOLOR="$back_color"></BODY>
    <META HTTP-EQUIV="Refresh" CONTENT="0; URL=$_[0]">
  </HTML>
HTML
}

